/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.InstallManager;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryNotAvailableException;
import com.sun.prodreg.core.RegistryQuery;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.event.ProgressListener;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.TypedSystemSubprocess;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ProgressView;
import com.sun.prodreg.view.ViewManager;
import java.util.Vector;

public class WebstartRegistry
implements Registry {
    public static final String REGCONVERT_UTIL = "/usr/sadm/install/bin/regconvert";
    private static final int WSREG_FILE_NOT_FOUND = 1;
    private static final int WSREG_NO_REG_ACCESS = 2;
    private static final int WSREG_NO_FILE_ACCESS = 3;
    private static final int WSREG_UNZIP_ERROR = 4;
    private static final int WSREG_CANT_CREATE_TMP_DIR = 5;
    private static final int WSREG_UNZIP_NOT_INSTALLED = 6;
    private static final int WSREG_BAD_REGISTRY_FILE = 7;
    private static final int WSREG_SUCCESS = 8;
    private static final int WSREG_O_RDONLY = 5;
    private static final int WSREG_O_RDWR = 6;
    private ViewManager vm = null;
    private InstallManager mgr = null;

    static {
        System.loadLibrary("prodreg");
    }

    public synchronized native void cleanup();

    private synchronized native int convert(String var1, ProgressListener var2);

    private void convertRegistry(String string, ProgressListener progressListener) {
        int n = this.convert(string, progressListener);
        Object[] objectArray = new String[]{string};
        switch (n) {
            case 1: {
                String string2 = Localizer.resolve("<L ProdRegResources.NoConversionFileFound>", objectArray);
                this.noConversion(string2, string);
                break;
            }
            case 3: {
                String string3 = Localizer.resolve("<L ProdRegResources.NoConversionFileAccess>", objectArray);
                this.manualConversion(string3, string);
                break;
            }
            case 2: {
                String string4 = Localizer.resolve("<L ProdRegResources.NoConversionRegAccess>", objectArray);
                this.manualConversion(string4, string);
                break;
            }
            case 4: {
                String string5 = Localizer.resolve("<L ProdRegResources.NoConversionBadReg>", objectArray);
                this.noConversion(string5, string);
                break;
            }
            case 5: {
                String string6 = Localizer.resolve("<L ProdRegResources.NoConversionTmpDir>", objectArray);
                this.noConversion(string6, string);
                break;
            }
            case 6: {
                String string7 = Localizer.resolve("<L ProdRegResources.NoConversionNoUnzip>", objectArray);
                this.noConversion(string7, string);
                break;
            }
            case 7: {
                String string8 = Localizer.resolve("<L ProdRegResources.NoConversionBadReg>", objectArray);
                this.noConversion(string8, string);
                break;
            }
            case 8: {
                String string9 = Localizer.resolve("<L ProdRegResources.ConversionSuccess>", objectArray);
                String string10 = Localizer.resolve("<L ProdRegResources.NeedConversionTitle>");
                String string11 = Localizer.resolve("<L ProdRegResources.OK>");
                this.vm.query(string10, string9, null, new String[]{string11});
                break;
            }
            default: {
                String string12 = Localizer.resolve("<L ProdRegResources.NoConversionUnknown>", objectArray);
                this.manualConversion(string12, string);
            }
        }
    }

    public Vector getAllComponents(int n, ProgressListener progressListener) throws RegistryNotAvailableException {
        switch (n) {
            case 1: {
                return this.getAllComponents(progressListener);
            }
            case 0: {
                return this.getSystemComponents(progressListener);
            }
        }
        throw new IllegalArgumentException("WebstartRegistry: getAllComponents: bad type:" + n);
    }

    public synchronized native Vector getAllComponents(ProgressListener var1) throws RegistryNotAvailableException;

    public synchronized native ComponentDescription getComponent(RegistryQuery var1) throws RegistryNotAvailableException;

    private synchronized native String getOldRegistryName();

    public synchronized native Vector getSystemComponents(ProgressListener var1) throws RegistryNotAvailableException;

    public void initialize(ViewManager viewManager, UIProvider uIProvider, InstallManager installManager, String string) {
        this.vm = viewManager;
        this.mgr = installManager;
        this.loadClasses();
        if (!this.initializeNoConversion(string)) {
            String string2 = this.getOldRegistryName();
            Object[] objectArray = new String[]{string2};
            String string3 = Localizer.resolve("<L ProdRegResources.NeedConversion>", objectArray);
            String string4 = Localizer.resolve("<L ProdRegResources.NeedConversionInfo>");
            String string5 = Localizer.resolve("<L ProdRegResources.NeedConversionTitle>");
            String string6 = Localizer.resolve("<L ProdRegResources.OK>");
            String string7 = Localizer.resolve("<L ProdRegResources.Cancel>");
            int n = viewManager.query(string5, string3, string4, new String[]{string6, string7});
            if (n == 0) {
                String string8 = Localizer.resolve("<L ProdRegResources.ConversionWait>");
                ProgressView progressView = uIProvider.getWaitView(string8);
                ComponentSelectableView componentSelectableView = viewManager.getTreeView();
                viewManager.setTreeView(progressView);
                this.convertRegistry(string2, progressView);
                viewManager.setTreeView(componentSelectableView);
            } else {
                string3 = Localizer.resolve("<L ProdRegResources.ConversionCancelled>");
                viewManager.query(string5, string3, null, new String[]{string6});
                return;
            }
        }
    }

    private synchronized native boolean initializeNoConversion(String var1);

    public synchronized native boolean isRegistryAvailable(int var1);

    private synchronized native void loadClasses();

    synchronized native ComponentDescription loopback(ComponentDescription var1);

    private void manualConversion(String string, String string2) {
        String string3 = Localizer.resolve("<L ProdRegResources.NeedConversionTitle>");
        String string4 = Localizer.resolve("<L ProdRegResources.OK>");
        String string5 = Localizer.resolve("<L ProdRegResources.Quit>");
        String string6 = Localizer.resolve("<L ProdRegResources.Cancel>");
        Object[] objectArray = new String[]{string2};
        int n = this.vm.query(string3, string, null, new String[]{string4, string6});
        if (n == 0) {
            if (!this.runConverter()) {
                string = Localizer.resolve("<L ProdRegResources.ManualConversionFailed>", objectArray);
                n = this.vm.query(string3, string, null, new String[]{string4, string5});
                if (n == 1) {
                    this.mgr.close(1);
                }
            }
        } else {
            string = Localizer.resolve("<L ProdRegResources.ConversionCancelled>", objectArray);
            this.vm.query(string3, string, null, new String[]{string4});
        }
    }

    private void noConversion(String string, String string2) {
        String string3 = Localizer.resolve("<L ProdRegResources.ConversionImpossibleTitle>");
        String string4 = Localizer.resolve("<L ProdRegResources.OK>");
        String string5 = Localizer.resolve("<L ProdRegResources.Quit>");
        String string6 = Localizer.resolve("<L ProdRegResources.Cancel>");
        String[] stringArray = new String[]{string2};
        int n = this.vm.query(string3, string, null, new String[]{string4, string5});
        if (n == 1) {
            this.mgr.close(1);
        }
    }

    public native boolean registerComponent(ComponentDescription var1) throws RegistryNotAvailableException;

    private boolean runConverter() {
        String string = REGCONVERT_UTIL;
        String string2 = System.getProperty("prodreg.pkgroot");
        if (string2 != null) {
            string = String.valueOf(string) + " -R " + string2;
        }
        String string3 = "bin/rootrun " + TypedSystemSubprocess.escape(' ', string);
        String string4 = Localizer.resolve("<L ProdRegResources.EnterRootPassword>");
        string3 = String.valueOf(string3) + " " + TypedSystemSubprocess.escape(' ', string4);
        String string5 = System.getProperty("prodreg.home");
        TypedSystemSubprocess typedSystemSubprocess = new TypedSystemSubprocess(string5, string3, 2);
        typedSystemSubprocess.run();
        return typedSystemSubprocess.getResult() == 0;
    }

    public synchronized native void setAlternateRoot(String var1) throws RegistryNotAvailableException;

    public synchronized native boolean unregisterComponent(ComponentDescription var1) throws RegistryNotAvailableException;
}

