/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ProdReg;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryNotAvailableException;
import com.sun.prodreg.core.RegistryQuery;
import com.sun.prodreg.event.Subprocess;
import com.sun.prodreg.event.SubprocessDoneEvent;
import com.sun.prodreg.event.SubprocessDoneListener;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.TypedSystemSubprocess;
import com.sun.prodreg.util.Utils;
import com.sun.prodreg.view.ViewManager;

public class InteractiveUninstaller
extends Subprocess
implements SubprocessDoneListener,
Runnable {
    private ComponentDescription desc;
    private ViewManager mgr;
    private ComponentDescriptionLookup cache;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int SKIP = 2;
    private boolean running = false;
    private int pkgrm_result = 1;
    private String pkgrm_message = null;
    private Registry reg;

    public InteractiveUninstaller(ComponentDescription componentDescription, ViewManager viewManager, Registry registry) {
        this.mgr = viewManager;
        this.reg = registry;
        this.desc = componentDescription;
    }

    private int ask(String string, String string2, boolean bl) {
        int n;
        String string3 = Localizer.resolve("<L ProdRegResources.IntUninstallTitle>");
        String string4 = Localizer.resolve("<L ProdRegResources.OK>");
        String string5 = Localizer.resolve("<L ProdRegResources.Cancel>");
        String[] stringArray = new String[]{string4, string5};
        if (bl) {
            String string6 = Localizer.resolve("<L ProdRegResources.Skip>");
            stringArray = new String[]{string4, string5, string6};
        }
        if ((n = this.mgr.query(string3, string, string2, stringArray)) == 0) {
            return 0;
        }
        if (n == 2) {
            return 2;
        }
        return 1;
    }

    private synchronized boolean getRunning() {
        return this.running;
    }

    private String removePackages(String string) {
        String string2 = "bin/rootrun";
        String string3 = TypedSystemSubprocess.escape(' ', "pkgrm " + string);
        String string4 = TypedSystemSubprocess.escape(' ', Localizer.resolve("<L ProdRegResources.EnterRootPassword>"));
        String string5 = String.valueOf(string2) + " " + string3 + " " + string4;
        this.setRunning(true);
        TypedSystemSubprocess typedSystemSubprocess = new TypedSystemSubprocess(System.getProperty("prodreg.home"), string5);
        typedSystemSubprocess.addSubprocessDoneListener(this);
        new Thread(typedSystemSubprocess).start();
        while (this.getRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return this.pkgrm_message;
    }

    public void run() {
        Object object;
        String string;
        Object object2;
        Object[] objectArray;
        String string2;
        Object[] objectArray2 = new Object[]{"<bold>" + Utils.getDisplayName(this.desc) + "</bold>"};
        String string3 = Localizer.resolve("<L ProdRegResources.UninstallConfirm>", objectArray2);
        int n = this.ask(string3, null, false);
        switch (n) {
            case 1: {
                String string4 = Localizer.resolve("<L ProdRegResources.UninstallCancel>", objectArray2);
                this.tell(string4, null);
                this.notifyListeners(1, "interactiveuninstaller", "message");
                return;
            }
            default: {
                throw new InternalError("Invalid response during user query");
            }
            case 0: 
        }
        boolean bl = false;
        String[] stringArray = Utils.listPackages(this.desc);
        String[] stringArray2 = Utils.getInstalledPkgs(stringArray);
        if (stringArray2 == null || stringArray2.length <= 0) {
            if (stringArray != null && stringArray.length > 0) {
                string2 = Localizer.resolve("<L ProdRegResources.NoPackages>", new String[]{Utils.arrayToString(stringArray)});
                this.tell(string2, null);
            }
        } else {
            string2 = Utils.arrayToString(stringArray);
            objectArray = new Object[]{string2};
            string3 = Localizer.resolve("<L ProdRegResources.PkgrmConfirm>", objectArray);
            n = this.ask(string3, null, true);
            switch (n) {
                case 0: {
                    object2 = this.removePackages(Utils.arrayToString(stringArray));
                    if (object2 != null) {
                        string = Localizer.resolve("<L ProdRegResources.PkgrmFailed>");
                        this.tell(string, (String)object2);
                        break;
                    }
                    string = Localizer.resolve("<L ProdRegResources.PkgrmSuccess>");
                    bl = true;
                    this.tell(string, null);
                    break;
                }
                case 1: {
                    String string5 = Localizer.resolve("<L ProdRegResources.PkgrmCancel>");
                    this.tell(string5, null);
                    this.notifyListeners(1, "interactiveuninstaller", "message");
                    return;
                }
                default: {
                    throw new InternalError("Invalid response during pkg removal");
                }
                case 2: 
            }
        }
        boolean bl2 = this.desc.getDependentComponents() != null && this.desc.getDependentComponents().size() > 0;
        objectArray = new RegistryQuery();
        objectArray.setID(this.desc.getID());
        objectArray.setUniqueName(this.desc.getUniqueName());
        objectArray.setVersion(this.desc.getVersion());
        objectArray.setLocation(this.desc.getLocation());
        try {
            boolean bl3;
            object2 = this.reg.getComponent((RegistryQuery)objectArray);
            boolean bl4 = bl3 = object2 != null;
            if (bl3) {
                if (bl2) {
                    object = new String[]{Utils.getDisplayName(this.desc)};
                    String string6 = Localizer.resolve("<L ProdRegResources.SkipUnregister>", object);
                    this.tell(string6, null);
                    n = 2;
                } else {
                    string3 = Localizer.resolve("<L ProdRegResources.UnregisterConfirm>");
                    n = this.ask(string3, null, true);
                }
            } else {
                n = 2;
                bl = true;
            }
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            object2 = new String[]{Utils.getDisplayName(this.desc)};
            string = Localizer.resolve("<L ProdRegResources.UnregisterProblem>", object2);
            n = 2;
        }
        switch (n) {
            case 1: {
                object2 = Localizer.resolve("<L ProdRegResources.UnregisterCancel>");
                this.tell((String)object2, null);
                break;
            }
            case 0: {
                String string7 = this.unregister(this.desc);
                if (string7 != null) {
                    object = Localizer.resolve("<L ProdRegResources.UnregisterFailed>");
                    this.tell((String)object, string7);
                    break;
                }
                object = Localizer.resolve("<L ProdRegResources.UnregisterSuccess>");
                this.tell((String)object, null);
                bl = true;
                break;
            }
            default: {
                throw new InternalError("Invalid response during unregistration");
            }
            case 2: 
        }
        int n2 = bl ? 0 : 1;
        this.notifyListeners(n2, "interactiveuninstaller", "message");
    }

    private synchronized void setRunning(boolean bl) {
        this.running = bl;
    }

    public void subprocessDone(SubprocessDoneEvent subprocessDoneEvent) {
        this.pkgrm_result = subprocessDoneEvent.getReturnValue();
        if (this.pkgrm_result != 0 && this.pkgrm_result != 2 && this.pkgrm_result != 10 && this.pkgrm_result != 20) {
            this.pkgrm_message = subprocessDoneEvent.getMessage();
        }
        this.setRunning(false);
    }

    private void tell(String string, String string2) {
        String string3 = Localizer.resolve("<L ProdRegResources.IntUninstallTitle>");
        String string4 = Localizer.resolve("<L ProdRegResources.OK>");
        this.mgr.query(string3, string, string2, new String[]{string4});
    }

    private String unregister(ComponentDescription componentDescription) {
        String string;
        block6: {
            string = null;
            try {
                ComponentReference[] componentReferenceArray;
                if (!this.reg.unregisterComponent(componentDescription)) {
                    if (ProdReg.debug) {
                        System.out.println("unregistration of " + componentDescription.getID() + " failed!");
                    }
                    string = Localizer.resolve("<L ProdRegResources.UnregisterFailed>");
                }
                if (string != null || (componentReferenceArray = componentDescription.getChildren()) == null) break block6;
                int n = 0;
                while (n < componentReferenceArray.length) {
                    ComponentDescription componentDescription2 = ComponentDescriptionLookup.get(componentReferenceArray[n].getID());
                    if (componentDescription2 == null || (string = this.unregister(componentDescription2)) == null) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                string = Localizer.resolve("<L ProdRegResources.UnregisterFailed>");
            }
        }
        return string;
    }
}

