/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.core.ProgressBar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class AWTProgressBar
extends Canvas
implements ProgressBar {
    private int progress = 0;
    private Color fg;
    private String message = null;
    private boolean appendProgress = true;
    private Image offscreen = null;
    private int currentHeight = 0;
    private int currentWidth = 0;

    public AWTProgressBar(Color color, Color color2, String string, boolean bl) {
        this.fg = color2;
        this.setBackground(color);
        this.setFont(new Font("Dialog", 1, 12));
        this.progress = 0;
        this.message = string;
        this.appendProgress = bl;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 20);
    }

    public int getProgress() {
        return this.progress;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.message;
        if (this.appendProgress) {
            string = String.valueOf(string) + " : " + this.progress + "%";
        }
        int n = 12;
        int n2 = 25;
        if (fontMetrics != null) {
            n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            n2 = fontMetrics.stringWidth(string);
        }
        int n3 = dimension.width / 2 - n2 / 2;
        int n4 = dimension.height / 2 + n / 2;
        int n5 = (int)Math.round((double)this.progress / 100.0 * (double)dimension.width);
        graphics.setColor(this.fg);
        graphics.fillRect(0, 0, n5, dimension.height);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.setColor(this.fg);
        graphics.setXORMode(Color.white);
        graphics.drawString(string, n3, n4);
        graphics.setPaintMode();
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setProgress(int n) {
        if (n <= 100) {
            this.progress = n;
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.currentWidth || dimension.height != this.currentHeight) {
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.currentWidth = dimension.width;
            this.currentHeight = dimension.height;
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.getForeground());
        this.paint(graphics2);
        graphics.drawImage(this.offscreen, 0, 0, this);
    }
}

