/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ErrorTable;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.common.ImportController;
import com.sun.dhcpmgr.common.Importer;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.ExportHeader;
import com.sun.dhcpmgr.ui.FieldLayout;
import com.sun.dhcpmgr.ui.ProgressManager;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ImportWizard
extends Wizard {
    private String importPath = "";
    private boolean conflictImport = false;
    private ImportController importController;
    private ExportHeader header;
    private Importer importer = new Importer(){
        ProgressManager progress;
        String[] errObjs = new String[]{ResourceStrings.getString("imp_error"), ""};

        public void displayError(String string) {
            this.errObjs[1] = string;
            this.displayError(this.errObjs);
        }

        private void displayError(Object[] objectArray) {
            ErrorDisplay errorDisplay = new ErrorDisplay(objectArray);
            if (SwingUtilities.isEventDispatchThread()) {
                errorDisplay.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(errorDisplay);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void displayErrors(String string, String string2, ActionError[] actionErrorArray) {
            ErrorTable errorTable = new ErrorTable(string2);
            errorTable.setErrors(actionErrorArray);
            JScrollPane jScrollPane = new JScrollPane(errorTable);
            Object[] objectArray = new Object[]{string, jScrollPane};
            this.displayError(objectArray);
        }

        public void initializeProgress(int n) {
            this.progress = new ProgressManager(ImportWizard.this, ResourceStrings.getString("imp_progress_title"), "", 0, n);
        }

        public void updateProgress(int n, String string) throws InterruptedException {
            this.progress.update(n, string);
        }
    };

    public ImportWizard(Frame frame) {
        super(frame, "");
        this.setTitle(ResourceStrings.getString("import_wiz_title"));
        this.addStep(new LocationStep());
        this.addStep(new ReviewStep());
        this.importController = new ImportController(this.importer, DataManager.get().getServer());
        this.showFirstStep();
    }

    public void doCancel() {
        this.importController.closeFile();
        super.doCancel();
    }

    public void doFinish() {
        final Runnable runnable = new Runnable(){

            public void run() {
                ImportWizard.this.reallyFinish();
            }
        };
        Thread thread = new Thread(){

            public void run() {
                if (importController.importData(conflictImport)) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        thread.start();
    }

    public void doHelp() {
        DhcpmgrApplet.showHelp("import_wizard");
    }

    protected void reallyFinish() {
        super.doFinish();
    }

    class LocationStep
    implements WizardStep {
        JPanel stepPanel;
        JTextField pathField;
        JCheckBox overrideBox;

        public LocationStep() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            this.stepPanel = new JPanel(gridBagLayout);
            Component component = Wizard.createTextArea(ResourceStrings.getString("imp_wiz_location_explain"), 8, 45);
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            JLabel jLabel = new JLabel(ResourceStrings.getString("imp_wiz_file_label"));
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.stepPanel.add(jLabel);
            this.pathField = new JTextField(ImportWizard.this.importPath);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.pathField, gridBagConstraints);
            this.stepPanel.add(this.pathField);
            component = Wizard.createTextArea(ResourceStrings.getString("imp_wiz_override_explain"), 4, 45);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            this.overrideBox = new JCheckBox(ResourceStrings.getString("imp_wiz_override_data"), false);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.overrideBox, gridBagConstraints);
            this.stepPanel.add(this.overrideBox);
            component = Box.createVerticalGlue();
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 3;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            this.pathField.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ LocationStep this$1;
                {
                    this.this$1 = locationStep;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    LocationStep.access$0(this.this$1).setForwardEnabled(this.this$1.pathField.getText().length() != 0);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            });
        }

        static /* synthetic */ ImportWizard access$0(LocationStep locationStep) {
            return locationStep.ImportWizard.this;
        }

        public Component getComponent() {
            return this.stepPanel;
        }

        public String getDescription() {
            return ResourceStrings.getString("imp_wiz_file_desc");
        }

        public void setActive(int n) {
            this.pathField.setText(ImportWizard.this.importPath);
            this.overrideBox.setSelected(ImportWizard.this.conflictImport);
            ImportWizard.this.setForwardEnabled(ImportWizard.this.importPath.length() != 0);
        }

        public boolean setInactive(int n) {
            ImportWizard.this.importPath = this.pathField.getText();
            ImportWizard.this.conflictImport = this.overrideBox.isSelected();
            if (n == 1) {
                ImportWizard.this.importController.setFile(ImportWizard.this.importPath);
                try {
                    ImportWizard.this.header = ImportWizard.this.importController.getHeader();
                    if (ImportWizard.this.header == null) {
                        return false;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(ImportWizard.this, ResourceStrings.getString("imp_err_file_not_found"), ResourceStrings.getString("server_error_title"), 0);
                    return false;
                }
                catch (Exception exception) {
                    String[] stringArray = new String[]{ResourceStrings.getString("imp_err_reading_header"), exception.getMessage()};
                    JOptionPane.showMessageDialog(ImportWizard.this, stringArray, ResourceStrings.getString("server_error_title"), 0);
                    return false;
                }
            }
            return true;
        }
    }

    class ReviewStep
    implements WizardStep {
        private Box stepBox;
        private JLabel fileLabel;
        private JLabel srcLabel;
        private JLabel userLabel;
        private JLabel dateLabel;
        private JLabel overrideLabel;
        private JLabel infoLabel;
        private SimpleDateFormat dateFormat = new SimpleDateFormat();
        private MessageFormat infoFormat = new MessageFormat(ResourceStrings.getString("imp_wiz_review_info"));

        public ReviewStep() {
            this.stepBox = Box.createVerticalBox();
            JComponent jComponent = Wizard.createTextArea(ResourceStrings.getString("imp_wiz_review_explain"), 6, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            JPanel jPanel = new JPanel(new FieldLayout());
            JLabel jLabel = new JLabel(ResourceStrings.getString("imp_wiz_file_label"));
            jPanel.add((Component)jLabel, "Label");
            this.fileLabel = new JLabel();
            this.fileLabel.setForeground(Color.black);
            jPanel.add((Component)this.fileLabel, "Field");
            jLabel = new JLabel(ResourceStrings.getString("imp_wiz_review_override"));
            jPanel.add((Component)jLabel, "Label");
            this.overrideLabel = new JLabel();
            this.overrideLabel.setForeground(Color.black);
            jPanel.add((Component)this.overrideLabel, "Field");
            jPanel.setAlignmentX(0.0f);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(5));
            this.infoLabel = new JLabel();
            this.infoLabel.setAlignmentX(0.0f);
            this.stepBox.add(this.infoLabel);
            jLabel = new JLabel(ResourceStrings.getString("imp_wiz_review_src"));
            jPanel = new JPanel(new FieldLayout());
            jPanel.add((Component)jLabel, "Label");
            this.srcLabel = new JLabel();
            jPanel.add((Component)this.srcLabel, "Field");
            jLabel = new JLabel(ResourceStrings.getString("imp_wiz_review_user"));
            jPanel.add((Component)jLabel, "Label");
            this.userLabel = new JLabel();
            jPanel.add((Component)this.userLabel, "Field");
            jLabel = new JLabel(ResourceStrings.getString("imp_wiz_review_date"));
            jPanel.add((Component)jLabel, "Label");
            this.dateLabel = new JLabel(this.dateFormat.format(new Date()));
            jPanel.add((Component)this.dateLabel, "Field");
            jPanel.setAlignmentX(0.0f);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalGlue());
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("imp_wiz_review_desc");
        }

        public void setActive(int n) {
            this.fileLabel.setText(ImportWizard.this.importPath);
            if (ImportWizard.this.conflictImport) {
                this.overrideLabel.setText(ResourceStrings.getString("yes"));
            } else {
                this.overrideLabel.setText(ResourceStrings.getString("no"));
            }
            Object[] objectArray = new Object[]{ImportWizard.this.importPath};
            this.infoLabel.setText(this.infoFormat.format(objectArray));
            this.srcLabel.setText(ImportWizard.this.header.getServer());
            this.userLabel.setText(ImportWizard.this.header.getUser());
            this.dateLabel.setText(this.dateFormat.format(ImportWizard.this.header.getDate()));
            ImportWizard.this.setFinishEnabled(true);
        }

        public boolean setInactive(int n) {
            return true;
        }
    }

    class ErrorDisplay
    implements Runnable {
        Object[] objs;

        public ErrorDisplay(Object[] objectArray) {
            this.objs = objectArray;
        }

        public void run() {
            JOptionPane.showMessageDialog(ImportWizard.this, this.objs, ResourceStrings.getString("server_error_title"), 0);
        }
    }
}

