/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.logviewer.client.ApplicationContext;
import com.sun.admin.logviewer.client.Content;
import com.sun.admin.logviewer.client.LogActionsListener;
import com.sun.admin.logviewer.client.LogContextHelpListener;
import com.sun.admin.logviewer.client.LogSettings;
import com.sun.admin.logviewer.client.LogVFilterPanel;
import com.sun.admin.logviewer.client.LogViewerTree;
import com.sun.admin.logviewer.client.MainMenuBar;
import com.sun.admin.logviewer.client.MainToolBar;
import com.sun.admin.logviewer.client.NavigationSelectionListener;
import com.sun.admin.logviewer.client.ServiceWrapper;
import com.sun.admin.logviewer.client.TreeNodeData;
import com.sun.admin.logviewer.common.Filterable;
import com.sun.admin.logviewer.common.LogFilter;
import com.sun.admin.logviewer.common.LogRecord;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class VLogViewer
implements Tool,
PropertyChangeListener,
VConsoleActionListener {
    public static final int PROGRESS_WAIT = 3000;
    private ServiceWrapper logViewer;
    private VConsoleProperties properties = null;
    private ApplicationContext applicationContext = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private Vector consoleListeners = new Vector();
    private Vector propertyChangeListeners = new Vector();
    private Vector navigationSelectionListeners = new Vector();
    private VDisplayModel displayModel;
    private MainMenuBar menuBar = null;
    private MainToolBar toolBar = null;
    private LogViewerTree theTree = null;
    private ResourceBundle resourceBundle = null;
    private LogVFilterPanel filterPanel = null;
    private AdminException initException = null;
    private boolean isCriticalStop = false;
    private JFrame frame = null;
    private String fileName = "";
    private String origViewSetting = "";
    private LogFilter logFilter = new LogFilter();
    private boolean bDetailsEnabled = true;
    private JFrame consoleFrame = null;

    public VLogViewer() {
        try {
            this.resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.logviewer.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
            this.resourceBundle = null;
        }
        this.menuBar = new MainMenuBar(this);
        this.toolBar = new MainToolBar(this);
        this.theTree = new LogViewerTree(this);
        this.filterPanel = new LogVFilterPanel(this);
        this.logFilter.setDirection(0);
    }

    public void aboutTool() {
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle(String.valueOf(ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"MARKETING_NAME")) + " " + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"VERSION"));
        vAboutBox.setDescription(ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"Copyright"));
        Dimension dimension = vAboutBox.getMinimumSize();
        FontMetrics fontMetrics = vAboutBox.getFontMetrics(vAboutBox.getFont());
        dimension.height += 2 * fontMetrics.getHeight();
        vAboutBox.setMinimumSize(dimension);
        VDialog vDialog = new VDialog((Frame)this.consoleFrame, true);
        vAboutBox.setContainer((VContainer)vDialog);
        ActionString actionString = new ActionString(this.resourceBundle, "HelpAbout");
        vDialog.setTitle(actionString.getString());
        vDialog.getContentPane().setLayout(new BorderLayout());
        vDialog.getContentPane().add((Component)vAboutBox, "Center");
        vDialog.pack();
        vDialog.showCenter((Component)this.consoleFrame);
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void addHelpListener(LogContextHelpListener logContextHelpListener, Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(logContextHelpListener, componentArray[n]);
                ++n;
            }
        }
        component.addFocusListener((FocusListener)((Object)logContextHelpListener));
    }

    public void addNavigationSelectionListener(NavigationSelectionListener navigationSelectionListener) {
        this.navigationSelectionListeners.addElement(navigationSelectionListener);
    }

    public void backUp(String string) {
        try {
            this.getLogViewer().clearLog(string);
            this.setFileName(this.getLogViewer().getCurrentLogFileName());
            this.getToolBar().configureForContent();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        this.getTree().getCurrentContent().refresh();
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Refresh");
            LogActionsListener logActionsListener = new LogActionsListener(this, false);
            logActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sechelpselection")) {
            Vector vector = (Vector)vConsoleEvent.getPayload();
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onSelection(vector);
        } else if (string.equals("vconsole.scopechildopened")) {
            this.getTree().getCurrentContent().onDoubleClick();
        } else if (string.equals("vconsole.delete")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Delete");
            LogActionsListener logActionsListener = new LogActionsListener(this, false);
            logActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.displayproperties")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Details");
            LogActionsListener logActionsListener = new LogActionsListener(this, false);
            logActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sortup")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        } else if (string.equals("vconsole.sortdown")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        } else if (string.equals("vconsole.filter")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Filter");
            LogActionsListener logActionsListener = new LogActionsListener(this, false);
            logActionsListener.actionPerformed(actionEvent);
        }
    }

    public void deleteFile(String string) {
        try {
            this.getLogViewer().clearLog(string);
            this.setFileName(this.getLogViewer().getCurrentLogFileName());
            this.getToolBar().configureForContent();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
    }

    public void destroy() {
        this.fireToolDestroyed();
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.consoleListeners.size()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)this.consoleListeners.elementAt(n);
            vConsoleActionListener.consoleAction(vConsoleEvent);
            ++n;
        }
    }

    private void fireNavigationSelection(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.valueChanged((VScopeNode)vConsoleEvent.getPayload());
            ++n;
        }
    }

    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        int n = 0;
        while (n < this.propertyChangeListeners.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.propertyChangeListeners.elementAt(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    private void fireToolDestroyed() {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.toolDestroyed();
            ++n;
        }
    }

    private void fireToolStopped() {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.toolStopped();
            ++n;
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public VScopeNode getCurrentNode() {
        return this.theTree.getCurrentNode();
    }

    public boolean getDetailsEnabled() {
        return this.bDetailsEnabled;
    }

    public VDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Filterable getFilter() {
        return this.logFilter;
    }

    public LogVFilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public String[] getListOfFiles() {
        String[] stringArray = null;
        try {
            stringArray = this.getLogViewer().listLogFiles();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return stringArray;
    }

    public int getLogFileSize() {
        int n = 0;
        try {
            n = (int)this.getLogViewer().getMaxLogFileSize(this.fileName);
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return n;
    }

    public LogRecord getLogRecord(long l, int n) {
        LogRecord logRecord = null;
        try {
            logRecord = this.getLogViewer().readRecord(l, n, this.getFileName());
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return logRecord;
    }

    public LogRecord getLogRecord(long l, int n, String string) {
        LogRecord logRecord = null;
        try {
            logRecord = this.getLogViewer().readRecord(l, n, string);
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return logRecord;
    }

    public ServiceWrapper getLogViewer() {
        return this.logViewer;
    }

    public MainMenuBar getMenuBar() {
        return this.menuBar;
    }

    public int getNumLogFiles() {
        int n = 0;
        try {
            n = this.getLogViewer().getNumLogFiles();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return n;
    }

    public String getPathLogFile() {
        String string = null;
        try {
            string = this.getLogViewer().getLogFileDir();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return string;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public int getRowCount() {
        long l = 0L;
        try {
            l = this.getLogViewer().getNumRecords(this.getFileName());
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
            return -1;
        }
        return (int)l;
    }

    public int getRowCount(String string) {
        long l = 0L;
        int n = 0;
        try {
            n = (int)this.getLogViewer().getNumRecords(string);
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return n;
    }

    public Vector getRowHeaders() {
        Vector vector;
        block2: {
            vector = new Vector();
            int n = this.getRowCount();
            if (n <= 0) break block2;
            try {
                vector = this.getLogViewer().getList(n, this.getFilter(), 0L, this.getFileName());
            }
            catch (AdminException adminException) {
                this.reportErrorException((Exception)((Object)adminException));
            }
        }
        return vector;
    }

    public VScopeNode getScopeNode() {
        return this.theTree.getRootNode();
    }

    public Vector getSelectedFileHeaders(String string) {
        Vector vector;
        block4: {
            vector = new Vector();
            int n = 0;
            try {
                n = (int)this.getLogViewer().getNumRecords(string);
            }
            catch (AdminException adminException) {
                this.reportErrorException((Exception)((Object)adminException));
            }
            if (n <= 0) break block4;
            try {
                vector = this.getLogViewer().getList(n, this.getFilter(), 0L, string);
            }
            catch (AdminException adminException) {
                this.reportErrorException((Exception)((Object)adminException));
            }
        }
        return vector;
    }

    public String getSwitch() {
        String string = null;
        try {
            string = this.getLogViewer().getSyslogSwitch();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return string;
    }

    public MainToolBar getToolBar() {
        return this.toolBar;
    }

    public LogViewerTree getTree() {
        return this.theTree;
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.logViewer = this.applicationContext.getServiceWrapper(toolInfrastructure);
            this.setFileName(this.logViewer.getCurrentLogFileName());
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = String.valueOf(string) + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string = String.valueOf(string) + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
            string = String.valueOf(string) + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"LoadFailure"), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"LoadFailure"), adminException.getLocalizedMessage(), (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
    }

    public boolean isWaitOn() {
        return "true".equals(this.properties.getProperty("vconsole.working"));
    }

    public ImageIcon loadImageIcon(String string) {
        String string2 = "images/" + string;
        return ConsoleUtility.loadImageIcon((String)string2, this.getClass());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        }
    }

    public void reportErrorException(Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(this.getFrame(), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"ErrorTitle"), this.unwindErrorException(exception));
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    public void setDetailsEnabled(boolean bl) {
        this.bDetailsEnabled = bl;
        this.getMenuBar().setDetailsEnabled(bl);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilter(LogFilter logFilter) {
        this.logFilter = logFilter;
    }

    public void setInfoBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            Object object;
            this.frame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
            if (this.getScopeNode() != null && this.getScopeNode().getFilterControl() == null) {
                this.getScopeNode().setFilterControl((VFilter)this.filterPanel);
            }
            int n = 0;
            while (n < this.propertyChangeListeners.size()) {
                object = (PropertyChangeListener)this.propertyChangeListeners.elementAt(n);
                vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)object);
                ++n;
            }
            object = new PropertyChangeEvent(this, "vconsole.buttondisplay", "", vConsoleProperties.getProperty("vconsole.buttondisplay"));
            this.firePropertyChanged((PropertyChangeEvent)object);
        }
    }

    public void setProps(LogSettings logSettings) throws AdminException {
        int n = 0;
        int n2 = 0;
        String string = null;
        String string2 = null;
        n = logSettings.getPanel().getFileSize();
        n2 = logSettings.getPanel().getNumFiles();
        string = logSettings.getPanel().getFileName();
        string2 = logSettings.getPanel().getSysLogValue();
        this.getLogViewer().setProperties(n, n2, string2, string);
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public void start() throws CriticalStopException {
        if (this.initException != null) {
            if (this.isCriticalStop) {
                return;
            }
            this.reportErrorException((Exception)((Object)this.initException));
            this.isCriticalStop = true;
            throw new CriticalStopException(this.initException.getLocalizedMessage());
        }
        this.bRunning = true;
        if (this.getLogViewer().hasReadAuthorization() || this.getLogViewer().hasWriteAuthorization()) {
            this.getMenuBar().configureForContent();
            this.getToolBar().configureForContent();
        }
        this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        this.origViewSetting = this.properties.getProperty("vconsole.iconstyle");
        this.properties.setProperty("vconsole.iconviewsenabled", "false");
        this.properties.setProperty("vconsole.iconstyle", "details");
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.displayModel.getSelectedNavigationNode());
        this.fireNavigationSelection(vConsoleEvent);
    }

    public void stop() throws CriticalStopException {
        this.properties.setProperty("vconsole.iconstyle", this.origViewSetting);
        this.bRunning = false;
        this.fireToolStopped();
    }

    public String unwindErrorException(Exception exception) {
        String string = "";
        while (exception != null) {
            if (string.length() > 0) {
                string = String.valueOf(string) + "\n";
            }
            if (exception instanceof AdminException) {
                AdminException adminException = (AdminException)((Object)exception);
                string = String.valueOf(string) + adminException.getLocalizedMessage();
                if (adminException.isEmbeddedException()) {
                    exception = adminException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = String.valueOf(string) + exception.getMessage();
            exception = null;
        }
        return string;
    }

    public void waitOff() {
        this.properties.setProperty("vconsole.working", "false");
    }

    public void waitOn() {
        this.properties.setProperty("vconsole.working", "true");
    }
}

