/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_PGHW_H
#define	_PGHW_H

#pragma ident	"@(#)pghw.h	1.2	07/10/05 SMI"


#ifdef	__cplusplus
extern "C" {
#endif

#if (defined(_KERNEL) || defined(_KMEMUSER))
#include <sys/cpuvar.h>
#include <sys/group.h>
#include <sys/processor.h>
#include <sys/bitmap.h>
#include <sys/atomic.h>
#include <sys/types.h>
#include <sys/kstat.h>
#include <sys/pg.h>

/*
 * Hardware that may be shared by a group of processors
 */
typedef enum pghw_type {
	PGHW_START,
	PGHW_IPIPE,
	PGHW_CACHE,
	PGHW_FPU,
	PGHW_MPIPE,
	PGHW_CHIP,
	PGHW_MEMORY,
	PGHW_NUM_COMPONENTS
} pghw_type_t;

/*
 * Anonymous instance id
 */
#define	PGHW_INSTANCE_ANON ((id_t)0xdecafbad)

/*
 * Processor Group (physical sharing relationship)
 */
typedef struct pghw {
	pg_t		pghw_pg;	/* processor group */
	pghw_type_t	pghw_hw;	/* HW sharing relationship */
	id_t		pghw_instance;	/* sharing instance identifier */
	kstat_t		*pghw_kstat;	/* physical kstats exported */
} pghw_t;

/*
 * IDs associating a CPU with various physical hardware
 */
typedef struct cpu_physid {
	id_t		cpu_chipid;	/* CPU's physical processor */
	id_t		cpu_coreid;	/* CPU's physical core */
	id_t		cpu_cacheid;	/* CPU's cache id */
} cpu_physid_t;

/*
 * Physical PG initialization / CPU service hooks
 */
void		pghw_init(pghw_t *, cpu_t *, pghw_type_t);
void		pghw_fini(pghw_t *);
void		pghw_cpu_add(pghw_t *, cpu_t *);
pghw_t		*pghw_place_cpu(cpu_t *, pghw_type_t);

/*
 * Physical ID cache creation / destruction
 */
void		pghw_physid_create(cpu_t *);
void		pghw_physid_destroy(cpu_t *);

/*
 * CPU / PG hardware related seach operations
 */
pghw_t		*pghw_find_pg(cpu_t *, pghw_type_t);
pghw_t		*pghw_find_by_instance(id_t, pghw_type_t);
group_t		*pghw_set_lookup(pghw_type_t);

int		pghw_level(pghw_type_t);

void		pghw_kstat_create(pghw_t *);
int		pghw_kstat_update(kstat_t *, int);

/* Hardware sharing relationship platform interfaces */
int		pg_plat_hw_shared(cpu_t *, pghw_type_t);
int		pg_plat_cpus_share(cpu_t *, cpu_t *, pghw_type_t);
int		pg_plat_hw_level(pghw_type_t);
id_t		pg_plat_hw_instance_id(cpu_t *, pghw_type_t);

/*
 * What comprises a "core" may vary across processor implementations,
 * and so the term itself is somewhat unstable. For this reason, there
 * is no PGHW_CORE type, but we provide an interface here to allow platforms
 * to express cpu <=> core mappings.
 */
id_t		pg_plat_get_core_id(cpu_t *);

#endif	/* !_KERNEL && !_KMEMUSER */

#ifdef	__cplusplus
}
#endif

#endif /* _PGHW_H */
