/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.type.Converter;
import sunsoft.jws.visual.rt.type.ParseException;
import sunsoft.jws.visual.rt.type.SubFieldTokenizer;

public class PointConverter
extends Converter {
    public String convertToString(Object object) {
        if (object == null) {
            return "";
        }
        Point point = (Point)object;
        return "x=" + point.x + ";y=" + point.y;
    }

    public Object convertFromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        SubFieldTokenizer subFieldTokenizer = new SubFieldTokenizer(string);
        Hashtable hashtable = subFieldTokenizer.getHashtable();
        Point point = new Point(0, 0);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("x") || string2.equals("y")) continue;
            throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.PointConverter.IllegalPoint", string2));
        }
        if (hashtable.containsKey("x")) {
            point.x = this.getIntegerFromTable(hashtable, "x");
        }
        if (hashtable.containsKey("y")) {
            point.y = this.getIntegerFromTable(hashtable, "y");
        }
        return point;
    }

    private int getIntegerFromTable(Hashtable hashtable, String string) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            try {
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(Global.fmtMsg("sunsoft.jws.visual.rt.type.PointConverter.BadFormattedValue", string2));
            }
        }
        return 0;
    }

    public String convertToCode(Object object) {
        if (object == null) {
            return "new java.awt.Point(0, 0)";
        }
        Point point = (Point)object;
        return "new java.awt.Point(" + point.x + ", " + point.y + ")";
    }
}

