/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import sunsoft.jws.visual.rt.base.Global;

public class ColorStore {
    private static ColorStore defaultColorStore;
    private Hashtable rgbkeys = new Hashtable();
    private Hashtable namekeys = new Hashtable();
    private String[] colorNameArray;

    public static ColorStore getDefaultColorStore() {
        ColorStore.initColorStore();
        return defaultColorStore;
    }

    private static void initColorStore() {
        if (defaultColorStore != null) {
            return;
        }
        defaultColorStore = new ColorStore();
        defaultColorStore.initDefaultColorList();
    }

    public String getColorName(Color color) {
        return (String)this.rgbkeys.get(color);
    }

    public Color getColor(String string) {
        if (string == null) {
            return null;
        }
        return (Color)this.namekeys.get(string.toLowerCase());
    }

    public String getClosestColorName(Color color) {
        int n = 765;
        Color color2 = null;
        if (this.rgbkeys.containsKey(color)) {
            return this.getColorName(color);
        }
        Enumeration enumeration = this.rgbkeys.keys();
        while (enumeration.hasMoreElements()) {
            Color color3 = (Color)enumeration.nextElement();
            int n2 = Math.abs(color3.getRed() - color.getRed()) + Math.abs(color3.getGreen() - color.getGreen()) + Math.abs(color3.getBlue() - color.getBlue());
            if (n2 > n) continue;
            n = n2;
            color2 = color3;
        }
        return this.getColorName(color2);
    }

    public String add(Color color, String string) {
        if (this.rgbkeys.containsKey(color)) {
            return this.getColorName(color);
        }
        this.rgbkeys.put(color, string.toLowerCase());
        this.namekeys.put(string, color);
        this.colorNameArray = null;
        return string;
    }

    public String[] getColorList() {
        if (this.colorNameArray == null) {
            this.colorNameArray = new String[this.rgbkeys.size()];
            int n = 0;
            Enumeration enumeration = this.namekeys.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                this.colorNameArray[n] = string = (String)enumeration.nextElement();
                ++n;
            }
            Global.util.qsort(this.colorNameArray);
        }
        return this.colorNameArray;
    }

    private void initDefaultColorList() {
        this.add(Color.black, "black");
        this.add(Color.blue, "blue");
        this.add(Color.cyan, "cyan");
        this.add(Color.darkGray, "darkgray");
        this.add(Color.gray, "gray");
        this.add(Color.green, "green");
        this.add(Color.lightGray, "lightgray");
        this.add(Color.magenta, "magenta");
        this.add(Color.orange, "orange");
        this.add(Color.pink, "pink");
        this.add(Color.red, "red");
        this.add(Color.white, "white");
        this.add(Color.yellow, "yellow");
        this.add(new Color(133, 133, 133), "gray52");
        this.add(new Color(122, 122, 122), "gray48");
        this.add(new Color(186, 186, 186), "gray73");
        this.add(new Color(94, 94, 94), "gray37");
        this.add(new Color(196, 196, 196), "gray77");
        this.add(new Color(84, 84, 84), "gray33");
        this.add(new Color(66, 66, 66), "gray26");
        this.add(new Color(48, 48, 48), "gray19");
        this.add(new Color(92, 92, 92), "gray36");
        this.add(new Color(74, 74, 74), "gray29");
        this.add(new Color(163, 163, 163), "gray64");
        this.add(new Color(28, 28, 28), "gray11");
        this.add(new Color(46, 46, 46), "gray18");
        this.add(new Color(173, 173, 173), "gray68");
        this.add(new Color(36, 36, 36), "gray14");
        this.add(new Color(54, 54, 54), "gray21");
        this.add(new Color(194, 194, 194), "gray76");
        this.add(new Color(150, 150, 150), "gray59");
        this.add(new Color(171, 171, 171), "gray67");
        this.add(new Color(3, 3, 3), "gray1");
        this.add(new Color(181, 181, 181), "gray71");
        this.add(new Color(20, 20, 20), "gray8");
        this.add(new Color(10, 10, 10), "gray4");
        this.add(new Color(207, 207, 207), "gray81");
        this.add(new Color(99, 99, 99), "gray39");
        this.add(new Color(237, 237, 237), "gray93");
        this.add(new Color(79, 79, 79), "gray31");
        this.add(new Color(87, 87, 87), "gray34");
        this.add(new Color(204, 204, 204), "gray80");
        this.add(new Color(214, 214, 214), "gray84");
        this.add(new Color(235, 235, 235), "gray92");
        this.add(new Color(245, 245, 245), "gray96");
        this.add(new Color(8, 8, 8), "gray3");
        this.add(new Color(71, 71, 71), "gray28");
        this.add(new Color(201, 201, 201), "gray79");
        this.add(new Color(61, 61, 61), "gray24");
        this.add(new Color(51, 51, 51), "gray20");
        this.add(new Color(33, 33, 33), "gray13");
        this.add(new Color(15, 15, 15), "gray6");
        this.add(new Color(117, 117, 117), "gray46");
        this.add(new Color(31, 31, 31), "gray12");
        this.add(new Color(13, 13, 13), "gray5");
        this.add(new Color(105, 105, 105), "gray41");
        this.add(new Color(148, 148, 148), "gray58");
        this.add(new Color(252, 252, 252), "gray99");
        this.add(new Color(115, 115, 115), "gray45");
        this.add(new Color(158, 158, 158), "gray62");
        this.add(new Color(179, 179, 179), "gray70");
        this.add(new Color(240, 240, 240), "gray94");
        this.add(new Color(189, 189, 189), "gray74");
        this.add(new Color(250, 250, 250), "gray98");
        this.add(new Color(199, 199, 199), "gray78");
        this.add(new Color(145, 145, 145), "gray57");
        this.add(new Color(70, 130, 180), "steel blue");
        this.add(new Color(233, 150, 122), "darksalmon");
        this.add(new Color(100, 149, 237), "cornflowerblue");
        this.add(new Color(30, 144, 255), "dodgerblue");
        this.add(new Color(238, 221, 130), "lightgoldenrod");
        this.add(new Color(205, 133, 63), "peru");
        this.add(new Color(154, 205, 50), "yellow green");
        this.add(new Color(175, 238, 238), "paleturquoise");
        this.add(new Color(0, 100, 0), "darkgreen");
        this.add(new Color(160, 82, 45), "sienna");
        this.add(new Color(143, 188, 143), "darkseagreen");
        this.add(new Color(255, 228, 196), "bisque");
        this.add(new Color(147, 112, 219), "mediumpurple");
        this.add(new Color(148, 0, 211), "dark violet");
        this.add(new Color(124, 252, 0), "lawn green");
        this.add(new Color(119, 136, 153), "lightslategray");
        this.add(new Color(230, 230, 250), "lavender");
        this.add(new Color(248, 248, 255), "ghostwhite");
        this.add(new Color(176, 224, 230), "powderblue");
        this.add(new Color(218, 165, 32), "goldenrod");
        this.add(new Color(255, 228, 181), "moccasin");
        this.add(new Color(255, 228, 225), "mistyrose");
        this.add(new Color(255, 255, 224), "light yellow");
        this.add(new Color(255, 99, 71), "tomato");
        this.add(new Color(245, 255, 250), "mintcream");
        this.add(new Color(138, 43, 226), "blueviolet");
        this.add(new Color(32, 178, 170), "light sea green");
        this.add(new Color(255, 240, 245), "lavender blush");
        this.add(new Color(127, 255, 212), "aquamarine");
        this.add(new Color(165, 42, 42), "brown");
        this.add(new Color(219, 112, 147), "pale violet red");
        this.add(new Color(240, 255, 255), "azure");
        this.add(new Color(107, 142, 35), "olivedrab");
        this.add(new Color(47, 79, 79), "darkslategray");
        this.add(new Color(139, 69, 19), "saddle brown");
        this.add(new Color(160, 32, 240), "purple");
        this.add(new Color(186, 85, 211), "medium orchid");
        this.add(new Color(240, 255, 240), "honeydew");
        this.add(new Color(176, 196, 222), "lightsteelblue");
        this.add(new Color(64, 224, 208), "turquoise");
        this.add(new Color(255, 127, 80), "coral");
        this.add(new Color(184, 134, 11), "darkgoldenrod");
        this.add(new Color(60, 179, 113), "mediumseagreen");
        this.add(new Color(210, 180, 140), "tan");
        this.add(new Color(255, 222, 173), "navajo white");
        this.add(new Color(46, 139, 87), "sea green");
        this.add(new Color(123, 104, 238), "mediumslateblue");
        this.add(new Color(250, 250, 210), "light goldenrod yellow");
        this.add(new Color(135, 206, 235), "sky blue");
        this.add(new Color(132, 112, 255), "lightslateblue");
        this.add(new Color(250, 240, 230), "linen");
        this.add(new Color(218, 112, 214), "orchid");
        this.add(new Color(0, 0, 128), "navy blue");
        this.add(new Color(253, 245, 230), "old lace");
        this.add(new Color(240, 248, 255), "aliceblue");
        this.add(new Color(72, 209, 204), "mediumturquoise");
        this.add(new Color(255, 140, 0), "dark orange");
        this.add(new Color(72, 61, 139), "dark slate blue");
        this.add(new Color(255, 160, 122), "light salmon");
        this.add(new Color(221, 160, 221), "plum");
        this.add(new Color(238, 130, 238), "violet");
        this.add(new Color(34, 139, 34), "forest green");
        this.add(new Color(0, 255, 127), "springgreen");
        this.add(new Color(85, 107, 47), "darkolivegreen");
        this.add(new Color(238, 232, 170), "pale goldenrod");
        this.add(new Color(245, 245, 220), "beige");
        this.add(new Color(255, 250, 240), "floralwhite");
        this.add(new Color(255, 218, 185), "peach puff");
        this.add(new Color(50, 205, 50), "limegreen");
        this.add(new Color(152, 251, 152), "palegreen");
        this.add(new Color(240, 230, 140), "khaki");
        this.add(new Color(188, 143, 143), "rosybrown");
        this.add(new Color(244, 164, 96), "sandybrown");
        this.add(new Color(189, 183, 107), "darkkhaki");
        this.add(new Color(25, 25, 112), "midnight blue");
        this.add(new Color(255, 235, 205), "blanched almond");
        this.add(new Color(224, 255, 255), "light cyan");
        this.add(new Color(255, 182, 193), "lightpink");
        this.add(new Color(95, 158, 160), "cadetblue");
        this.add(new Color(106, 90, 205), "slate blue");
        this.add(new Color(245, 222, 179), "wheat");
        this.add(new Color(255, 69, 0), "orangered");
        this.add(new Color(127, 255, 0), "chartreuse");
        this.add(new Color(255, 255, 255), "white");
        this.add(new Color(65, 105, 225), "royalblue");
        this.add(new Color(173, 216, 230), "light blue");
        this.add(new Color(255, 250, 250), "snow");
        this.add(new Color(255, 245, 238), "seashell");
        this.add(new Color(250, 128, 114), "salmon");
        this.add(new Color(255, 255, 240), "ivory");
        this.add(new Color(255, 239, 213), "papaya whip");
        this.add(new Color(153, 50, 204), "dark orchid");
        this.add(new Color(208, 32, 144), "violet red");
        this.add(new Color(255, 248, 220), "cornsilk");
        this.add(new Color(255, 105, 180), "hotpink");
        this.add(new Color(176, 48, 96), "maroon");
        this.add(new Color(178, 34, 34), "firebrick");
        this.add(new Color(240, 128, 128), "lightcoral");
        this.add(new Color(220, 220, 220), "gainsboro");
        this.add(new Color(216, 191, 216), "thistle");
        this.add(new Color(135, 206, 250), "light sky blue");
        this.add(new Color(210, 105, 30), "chocolate");
        this.add(new Color(173, 255, 47), "green yellow");
        this.add(new Color(112, 128, 144), "slate gray");
        this.add(new Color(0, 191, 255), "deepskyblue");
        this.add(new Color(255, 250, 205), "lemon chiffon");
        this.add(new Color(0, 206, 209), "dark turquoise");
        this.add(new Color(222, 184, 135), "burlywood");
        this.add(new Color(199, 21, 133), "mediumvioletred");
        this.add(new Color(250, 235, 215), "antique white");
        this.add(new Color(255, 215, 0), "gold");
        this.add(new Color(255, 20, 147), "deep pink");
        this.add(new Color(205, 92, 92), "indianred");
        this.add(new Color(0, 250, 154), "medium spring green");
    }
}

