/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import java.awt.Scrollbar;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.WinScrollbar;
import sunsoft.jws.visual.rt.base.Global;

public class VJScrollbar
extends Panel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private boolean win = Global.isWindows();
    private WinScrollbar winScrollbar;
    private Scrollbar scrollbar;

    public VJScrollbar() {
        this(1);
    }

    public VJScrollbar(int n) {
        GBLayout gBLayout = new GBLayout();
        this.setLayout(gBLayout);
        GBConstraints gBConstraints = new GBConstraints();
        gBConstraints.gridx = 0;
        gBConstraints.gridy = 0;
        gBConstraints.weightx = 1.0;
        gBConstraints.weighty = 1.0;
        gBConstraints.fill = 1;
        if (this.win) {
            this.winScrollbar = new WinScrollbar(n);
            super.addImpl(this.winScrollbar, null, -1);
            gBLayout.setConstraints((Component)this.winScrollbar, gBConstraints);
        } else {
            this.scrollbar = new Scrollbar(n);
            super.addImpl(this.scrollbar, null, -1);
            gBLayout.setConstraints((Component)this.scrollbar, gBConstraints);
        }
    }

    public VJScrollbar(int n, int n2, int n3, int n4, int n5) {
        this(n);
        this.setValues(n2, n3, n4, n5);
    }

    protected void addImpl(Component component, Object object, int n) {
        throw new Error(Global.getMsg("sunsoft.jws.visual.rt.awt.VJScrollbar.CantAdd"));
    }

    public void remove(Component component) {
        throw new Error(Global.getMsg("sunsoft.jws.visual.rt.awt.VJScrollbar.CantRemove"));
    }

    public int getOrientation() {
        if (this.win) {
            return this.winScrollbar.getOrientation();
        }
        return this.scrollbar.getOrientation();
    }

    public int getValue() {
        if (this.win) {
            return this.winScrollbar.getValue();
        }
        return this.scrollbar.getValue();
    }

    public void setValue(int n) {
        if (this.win) {
            this.winScrollbar.setValue(n);
        } else {
            this.scrollbar.setValue(n);
        }
    }

    public int getMinimum() {
        if (this.win) {
            return this.winScrollbar.getMinimum();
        }
        return this.scrollbar.getMinimum();
    }

    public int getMaximum() {
        if (this.win) {
            return this.winScrollbar.getMaximum();
        }
        return this.scrollbar.getMaximum();
    }

    public int getVisible() {
        if (this.win) {
            return this.winScrollbar.getVisible();
        }
        return this.scrollbar.getVisible();
    }

    public void setLineIncrement(int n) {
        if (n < 1) {
            n = 1;
        }
        if (this.win) {
            this.winScrollbar.setLineIncrement(n);
        } else {
            this.scrollbar.setLineIncrement(n);
        }
    }

    public int getLineIncrement() {
        if (this.win) {
            return this.winScrollbar.getLineIncrement();
        }
        return this.scrollbar.getLineIncrement();
    }

    public void setPageIncrement(int n) {
        if (n < 1) {
            n = 1;
        }
        if (this.win) {
            this.winScrollbar.setPageIncrement(n);
        } else {
            this.scrollbar.setPageIncrement(n);
        }
    }

    public int getPageIncrement() {
        if (this.win) {
            return this.winScrollbar.getPageIncrement();
        }
        return this.scrollbar.getPageIncrement();
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (this.win) {
            this.winScrollbar.setValues(n, n2, n3, n4);
        } else {
            this.scrollbar.setValues(n, n2, n3, n4);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (this.win) {
                    if (event.target != this.winScrollbar) break;
                    event.target = this;
                    break;
                }
                if (event.target != this.scrollbar) break;
                event.target = this;
                break;
            }
            default: {
                return true;
            }
        }
        return super.handleEvent(event);
    }
}

