/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Insets;
import sunsoft.jws.visual.rt.awt.GBConstraints;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.Scrollable;
import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.awt.VJScrollbar;
import sunsoft.jws.visual.rt.base.Global;

public class ScrollPanel
extends VJPanel {
    protected VJScrollbar vbar;
    protected VJScrollbar hbar;
    private Component comp;
    private boolean vshow;
    private boolean hshow;
    private GBLayout gridbag;
    private boolean hasFocus;
    private int scrollAreaWidth = 0;
    private int scrollAreaHeight = 0;
    private Insets scrollAreaInsets;

    public ScrollPanel() {
        super(8);
        this.setBorderInsets(new Insets(0, 0, 0, 0));
        GBConstraints gBConstraints = new GBConstraints();
        this.gridbag = new GBLayout();
        this.setLayout(this.gridbag);
        this.hbar = new VJScrollbar(0);
        this.vbar = new VJScrollbar(1);
        gBConstraints.gridx = 1;
        gBConstraints.gridy = 0;
        gBConstraints.shrinkx = false;
        gBConstraints.shrinky = true;
        gBConstraints.fill = 3;
        super.addImpl(this.vbar, null, -1);
        this.gridbag.setConstraints((Component)this.vbar, gBConstraints);
        gBConstraints.gridx = 0;
        gBConstraints.gridy = 1;
        gBConstraints.shrinkx = true;
        gBConstraints.shrinky = false;
        gBConstraints.fill = 2;
        super.addImpl(this.hbar, null, -1);
        this.gridbag.setConstraints((Component)this.hbar, gBConstraints);
        this.vshow = true;
        this.hbar.hide();
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.doAdd(component);
    }

    private void doAdd(Component component) {
        if (!(component instanceof Scrollable)) {
            throw new Error(Global.getMsg("sunsoft.jws.visual.rt.awt.ScrollPanel.OnlyOneInstance"));
        }
        if (this.comp != null) {
            this.remove(this.comp);
        }
        this.comp = component;
        GBConstraints gBConstraints = new GBConstraints();
        gBConstraints.gridx = 0;
        gBConstraints.gridy = 0;
        gBConstraints.weightx = 1.0;
        gBConstraints.weighty = 1.0;
        gBConstraints.shrinkx = true;
        gBConstraints.shrinky = true;
        gBConstraints.fill = 1;
        gBConstraints.insets = this.scrollAreaInsets;
        this.gridbag.setConstraints(component, gBConstraints);
    }

    public int getScrollAreaWidth() {
        return this.scrollAreaWidth;
    }

    public void setScrollAreaWidth(int n) {
        this.scrollAreaWidth = n;
    }

    public int getScrollAreaHeight() {
        return this.scrollAreaHeight;
    }

    public void setScrollAreaHeight(int n) {
        this.scrollAreaHeight = n;
    }

    public Insets getScrollAreaInsets() {
        return this.scrollAreaInsets;
    }

    public void setScrollAreaInsets(Insets insets) {
        this.scrollAreaInsets = insets;
        if (this.comp != null) {
            GBConstraints gBConstraints = this.gridbag.getConstraints(this.comp);
            gBConstraints.insets = insets;
            this.gridbag.setConstraints(this.comp, gBConstraints);
        }
    }

    public int getVisibleIndex() {
        if (!this.vshow) {
            return 0;
        }
        int n = ((Scrollable)((Object)this.comp)).lineHeight();
        int n2 = this.vbar.getValue();
        return (n2 + n - 1) / n;
    }

    public void makeVisible(int n) {
        int n2;
        if (!this.vshow) {
            return;
        }
        if (n == -1) {
            return;
        }
        Scrollable scrollable = (Scrollable)((Object)this.comp);
        Dimension dimension = scrollable.viewSize(this.comp.size());
        int n3 = scrollable.lineHeight();
        int n4 = n3 * n;
        if (n4 < (n2 = this.vbar.getValue())) {
            this.vbar.setValue(n4);
            scrollable.scrollY(n4);
        } else if (n4 + n3 > n2 + dimension.height) {
            if ((n4 -= dimension.height - n3) < 0) {
                n4 = 0;
            }
            this.vbar.setValue(n4);
            scrollable.scrollY(n4);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1004) {
            this.hasFocus = true;
            return super.handleEvent(event);
        }
        if (event.id == 1005) {
            this.hasFocus = false;
            return super.handleEvent(event);
        }
        if (event.target == this.hbar) {
            ((Scrollable)((Object)this.comp)).scrollX(this.hbar.getValue());
        } else if (event.target == this.vbar) {
            ((Scrollable)((Object)this.comp)).scrollY(this.vbar.getValue());
        } else {
            return super.handleEvent(event);
        }
        return true;
    }

    private Dimension viewSize() {
        Dimension dimension = this.size();
        dimension = new Dimension(dimension.width, dimension.height);
        Insets insets = this.insets();
        Insets insets2 = this.getScrollAreaInsets();
        if (insets2 == null) {
            insets2 = new Insets(0, 0, 0, 0);
        }
        dimension.width -= insets.left + insets.right + insets2.left + insets2.right;
        dimension.height -= insets.top + insets.bottom + insets2.top + insets2.bottom;
        return ((Scrollable)((Object)this.comp)).viewSize(dimension);
    }

    public Dimension minimumSize() {
        Dimension dimension;
        Dimension dimension2 = this.hbar.minimumSize();
        Dimension dimension3 = this.vbar.minimumSize();
        if (this.comp != null) {
            dimension = this.comp.minimumSize();
            dimension = new Dimension(dimension.width, dimension.height);
        } else {
            dimension = new Dimension(0, 0);
        }
        return this.calcSize(dimension, dimension2, dimension3);
    }

    public Dimension preferredSize() {
        Dimension dimension;
        Dimension dimension2 = this.hbar.preferredSize();
        Dimension dimension3 = this.vbar.preferredSize();
        if (this.comp != null) {
            dimension = this.comp.preferredSize();
            dimension = new Dimension(dimension.width, dimension.height);
        } else {
            dimension = new Dimension(0, 0);
        }
        return this.calcSize(dimension, dimension2, dimension3);
    }

    private Dimension calcSize(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        Insets insets = this.insets();
        Insets insets2 = this.getScrollAreaInsets();
        if (insets2 == null) {
            insets2 = new Insets(0, 0, 0, 0);
        }
        if (this.scrollAreaWidth != 0) {
            dimension.width = this.scrollAreaWidth;
        }
        if (this.scrollAreaHeight != 0) {
            dimension.height = this.scrollAreaHeight;
        }
        int n = insets.left + insets.right + insets2.left + insets2.right;
        dimension.width += dimension3.width + n;
        dimension.width = Math.max(dimension.width, dimension2.width + n);
        int n2 = insets.top + insets.bottom + insets2.top + insets2.bottom;
        dimension.height += dimension2.height + n2;
        dimension.height = Math.max(dimension.height, dimension3.height + n2);
        return dimension;
    }

    public void layout() {
        boolean bl = this.hasFocus;
        Dimension dimension = this.viewSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            super.layout();
            return;
        }
        Dimension dimension2 = ((Scrollable)((Object)this.comp)).scrollSize();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (dimension.width < dimension2.width) {
            bl2 = true;
        }
        if (dimension.height < dimension2.height) {
            bl3 = true;
        }
        if (!(!bl2 && !bl3 || bl2 && bl3)) {
            if (bl3) {
                Dimension dimension3 = this.vbar.minimumSize();
                if (dimension.width < dimension2.width + dimension3.width) {
                    bl2 = true;
                }
            } else if (bl2) {
                Dimension dimension4 = this.hbar.minimumSize();
                if (dimension.height < dimension2.height + dimension4.height) {
                    bl3 = true;
                }
            }
        }
        if (bl2) {
            if (!this.hshow) {
                this.hbar.show();
                this.hshow = true;
                bl4 = true;
            }
        } else if (this.hshow) {
            this.hbar.hide();
            this.hshow = false;
            bl4 = true;
            if (this.hbar.getValue() != 0) {
                this.hbar.setValue(0);
            }
            ((Scrollable)((Object)this.comp)).scrollX(0);
        }
        if (bl3) {
            if (!this.vshow) {
                this.vbar.show();
                this.vshow = true;
                bl4 = true;
            }
        } else if (this.vshow) {
            this.vbar.hide();
            this.vshow = false;
            bl4 = true;
            if (this.vbar.getValue() != 0) {
                this.vbar.setValue(0);
            }
            ((Scrollable)((Object)this.comp)).scrollY(0);
        }
        if (this.hshow) {
            this.updateHScrollbar();
        }
        if (this.vshow) {
            this.updateVScrollbar();
        }
        if (bl4) {
            this.validate();
            if (bl && Global.isMotif()) {
                this.comp.requestFocus();
            }
        } else {
            super.layout();
        }
    }

    public void updateWindow() {
        this.invalidate();
        this.validate();
    }

    protected void updateHScrollbar() {
        Dimension dimension = this.viewSize();
        Dimension dimension2 = ((Scrollable)((Object)this.comp)).scrollSize();
        if (this.vshow) {
            Dimension dimension3 = this.vbar.minimumSize();
            dimension.width -= dimension3.width;
        }
        if (dimension.width < 1) {
            return;
        }
        int n = dimension2.width;
        this.hbar.setValues(this.hbar.getValue(), dimension.width, 0, n);
        Scrollable scrollable = (Scrollable)((Object)this.comp);
        int n2 = Math.max(10, dimension.width / 6);
        int n3 = Math.max(n2, dimension.width - n2);
        n3 = Math.min(dimension2.width - dimension.width, n3);
        this.hbar.setLineIncrement(n2);
        this.hbar.setPageIncrement(n3);
        scrollable.scrollX(this.hbar.getValue());
    }

    protected void updateVScrollbar() {
        Dimension dimension = this.viewSize();
        Dimension dimension2 = ((Scrollable)((Object)this.comp)).scrollSize();
        if (this.hshow) {
            Dimension dimension3 = this.hbar.minimumSize();
            dimension.height -= dimension3.height;
        }
        if (dimension.height < 1) {
            return;
        }
        int n = dimension2.height;
        this.vbar.setValues(this.vbar.getValue(), dimension.height, 0, n);
        Scrollable scrollable = (Scrollable)((Object)this.comp);
        int n2 = scrollable.lineHeight();
        int n3 = Math.max(n2, dimension.height / n2 * n2 - n2);
        n3 = Math.min(dimension2.height - dimension.height, n3);
        this.vbar.setLineIncrement(n2);
        this.vbar.setPageIncrement(n3);
        scrollable.scrollY(this.vbar.getValue());
    }
}

