/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import sunsoft.jws.visual.rt.awt.ImageLabel;
import sunsoft.jws.visual.rt.base.DesignerAccess;

public class ImageButton
extends ImageLabel {
    private int lineWidth = 2;
    private int pressMovement = 1;
    protected boolean depressed = false;

    public ImageButton(Image image) {
        this(image, 20, 20);
    }

    public ImageButton(Image image, int n, int n2) {
        super(image, n, n2);
        this.padWidth = this.lineWidth + 2;
    }

    public void setPadWidth(int n) {
        super.setPadWidth(n + this.lineWidth);
    }

    public int getPadWidth() {
        return super.getPadWidth() - this.lineWidth;
    }

    public void setLineWidth(int n) {
        int n2 = this.getPadWidth();
        this.lineWidth = n;
        this.setPadWidth(n2);
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setPressMovement(int n) {
        if (n != this.pressMovement) {
            Graphics graphics;
            this.pressMovement = n;
            if (this.depressed && (graphics = this.getGraphics()) != null) {
                Dimension dimension = this.size();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                this.repaint();
            }
        }
    }

    public int getPressMovement() {
        return this.pressMovement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Color color = this.getBackground();
        if (this.imgWidth >= 0 && this.imgHeight >= 0) {
            Object object = DesignerAccess.mutex;
            synchronized (object) {
                int n;
                int n2;
                Dimension dimension = this.size();
                Image image = this.isEnabled() ? this.upImg : this.disImg;
                int n3 = (dimension.width - this.imgWidth) / 2;
                int n4 = (dimension.height - this.imgHeight) / 2;
                int n5 = n2 = this.depressed ? this.pressMovement : 0;
                if (this.pressMovement != 0) {
                    graphics.setColor(color);
                    n = this.pressMovement < 0 ? -1 : 1;
                    for (int i = 0; i < this.pressMovement * n; ++i) {
                        graphics.drawRect(n3 + i * n + (n < 0 ? -1 : 0), n4 + i * n + (n < 0 ? -1 : 0), this.imgWidth, this.imgHeight);
                    }
                }
                if (this.upImg != null) {
                    if (color instanceof SystemColor) {
                        color = new Color(color.getRGB());
                    }
                    graphics.drawImage(image, n3 + n2, n4 + n2, color, this);
                }
                graphics.setColor(color);
                for (n = 0; n < this.lineWidth; ++n) {
                    graphics.draw3DRect(n, n, dimension.width - n * 2 - 1, dimension.height - n * 2 - 1, !this.depressed);
                }
            }
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.depressed = true;
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.depressed != this.inside(n, n2)) {
            this.depressed = !this.depressed;
            this.repaint();
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.depressed) {
            this.action();
            this.depressed = false;
            this.repaint();
        }
        return true;
    }

    public void action() {
        this.postEvent(new Event(this, 1001, null));
    }
}

