/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.Global;

public class CardPanel
extends VJPanel {
    public static final int FETCHCARD = 68496;
    public static final int CURRENTCARD = 68497;
    protected Vector tabs;
    private Label cardLabel;
    private CardLayout cardLayout = new CardLayout();
    private String currentCard;
    private Hashtable cards;

    public CardPanel() {
        this.setLayout(this.cardLayout);
        this.tabs = new Vector();
        this.cards = new Hashtable();
        this.cardLabel = this.newCardLabel();
        this.add((Component)this.cardLabel, "foobar");
    }

    protected Label newCardLabel() {
        return new Label(Global.getMsg("sunsoft.jws.visual.rt.awt.CardPanel.Card__Panel"));
    }

    public Component add(String string, Component component) {
        boolean bl = this.currentCard != null && this.cards.get(this.currentCard) == component;
        super.add(string, component);
        if (bl) {
            component.show();
            this.currentCard = string;
        }
        return component;
    }

    public void addTab(String string) {
        this.tabs.addElement(string);
    }

    public void addTab(String string, int n) {
        this.tabs.insertElementAt(string, n);
    }

    public String getTab(int n) {
        int n2 = this.tabs.size();
        if (n >= 0 && n < n2) {
            return (String)this.tabs.elementAt(n);
        }
        return null;
    }

    public int getTabIndex(String string) {
        return this.tabs.indexOf(string);
    }

    public void removeTab(String string) {
        this.tabs.removeElement(string);
        this.removeCard(string);
    }

    public void renameTab(String string, String string2) {
        int n = this.tabs.indexOf(string);
        if (n != -1) {
            this.tabs.removeElementAt(n);
            this.tabs.insertElementAt(string2, n);
            this.renameCard(string, string2);
        }
    }

    public void removeAllTabs() {
        this.tabs.removeAllElements();
        this.removeAllCards();
    }

    public Enumeration tabs() {
        return this.tabs.elements();
    }

    public Component addCard(String string, Component component) {
        if (this.cardLabel.getParent() == this) {
            this.remove(this.cardLabel);
        }
        if (!this.tabs.contains(string)) {
            throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.awt.CardPanel.FMT.0", "\r\n", Global.getMsg("sunsoft.jws.visual.rt.awt.CardPanel.________There__is__no__tab__.0"), string, "\".\r\n", Global.getMsg("sunsoft.jws.visual.rt.awt.CardPanel.________You__must__call__ad.1")));
        }
        this.cards.put(string, component);
        if (this.currentCard == null) {
            this.currentCard = string;
            this.postEvent(new Event(this, 68497, string));
        }
        return this.add(string, component);
    }

    public Component getCard(String string) {
        return (Component)this.cards.get(string);
    }

    public String getCardName(Component component) {
        Enumeration enumeration = this.cards.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.cards.get(string) != component) continue;
            return string;
        }
        return null;
    }

    private void renameCard(String string, String string2) {
        Component component = (Component)this.cards.get(string);
        if (component != null) {
            this.cards.remove(string);
            this.cards.put(string2, component);
            this.remove(component);
            this.add(string2, component);
            if (string.equals(this.currentCard)) {
                this.currentCard = string2;
                component.show();
            }
        }
    }

    private void removeCard(String string) {
        Component component;
        if (string.equals(this.currentCard)) {
            this.currentCard = null;
        }
        if ((component = (Component)this.cards.get(string)) != null) {
            this.cards.remove(string);
            this.remove(component);
        }
        if (this.cardLabel.getParent() != this && this.countComponents() == 0) {
            this.add((Component)this.cardLabel, "foobar");
        }
    }

    private void removeAllCards() {
        this.cards.clear();
        if (this.cardLabel.getParent() != this) {
            this.add((Component)this.cardLabel, "foobar");
        }
    }

    public String getCurrentCard() {
        return this.currentCard;
    }

    public void show(String string) {
        if (this.cards.get(string) == null) {
            this.postEvent(new Event(this, 68496, string));
        }
        if (this.cards.get(string) != null) {
            this.currentCard = string;
            this.cardLayout.show(this, string);
            this.postEvent(new Event(this, 68497, string));
        }
    }

    public void first() {
        if (this.tabs.size() > 0) {
            this.show((String)this.tabs.elementAt(0));
        }
    }

    public void next() {
        int n = this.frontIndex();
        if (this.tabs.size() > n + 1) {
            this.show((String)this.tabs.elementAt(n + 1));
        }
    }

    void previous() {
        int n = this.frontIndex();
        if (this.tabs.size() > 0 && n - 1 >= 0) {
            this.show((String)this.tabs.elementAt(n - 1));
        }
    }

    public void last() {
        int n = this.tabs.size() - 1;
        if (n >= 0) {
            this.show((String)this.tabs.elementAt(n));
        }
    }

    private int frontIndex() {
        if (this.currentCard == null) {
            return -1;
        }
        return this.tabs.indexOf(this.currentCard);
    }
}

