/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import sunsoft.jws.visual.rt.awt.CLComponent;
import sunsoft.jws.visual.rt.type.IntHolder;

public class CLIconLabel
extends CLComponent {
    private static final int ICON_XPAD = 2;
    private static final int ICON_WIDTH = 16;
    private static final int TOTAL_ICON_WIDTH = 20;
    private static final int ICON_YPAD = 0;
    private static final int ICON_HEIGHT = 16;
    private static final int TOTAL_ICON_HEIGHT = 16;
    private static final int TEXT_PAD = 4;
    private Image icon;
    private boolean editable = true;

    public CLIconLabel(String string, Image image) {
        super(string);
        this.icon = image;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image image) {
        this.setIcon(image, true);
    }

    public void setIcon(Image image, boolean bl) {
        this.icon = image;
        if (this.canvas != null && bl) {
            this.canvas.updateView();
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.canvas == null) {
            return;
        }
        IntHolder intHolder = new IntHolder();
        String string = this.getOffsetAndText(n3, n6, intHolder);
        if (this.icon != null && n3 >= 20) {
            graphics.drawImage(this.icon, n + intHolder.value + 2, n2 + 0, this.canvas);
            intHolder.value += 20;
        } else {
            intHolder.value += 4;
        }
        if (string != null) {
            graphics.drawString(string, n + intHolder.value, n2 + n5);
        }
    }

    private String getOffsetAndText(int n, int n2, IntHolder intHolder) {
        int n3;
        FontMetrics fontMetrics = this.canvas.getFontMetrics();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        String string = null;
        if (this.icon != null) {
            n4 = 20;
            n5 = 2;
        } else if (this.text != null) {
            n4 = 4;
        }
        if (this.text != null) {
            n7 = 4;
            n3 = n - n4 - n7;
            string = this.canvas.chopText(this.text, n3);
            n6 = fontMetrics.stringWidth(string);
        }
        n3 = n4 + n6 + n7;
        switch (n2) {
            case 0: {
                intHolder.value = 0;
                break;
            }
            case 1: {
                intHolder.value = (n - n3) / 2;
                break;
            }
            case 2: {
                intHolder.value = n - n3;
            }
        }
        if (intHolder.value < 0) {
            intHolder.value = 0;
        }
        return string;
    }

    public int textX() {
        if (this.canvas == null) {
            return -1;
        }
        IntHolder intHolder = new IntHolder();
        this.getOffsetAndText(this.canvas.columnWidth(this.column), this.canvas.getFormat(this.column), intHolder);
        if (this.icon != null) {
            intHolder.value += 20;
        } else if (this.text != null) {
            intHolder.value += 4;
        }
        return intHolder.value;
    }

    public int textY() {
        if (this.canvas == null) {
            return -1;
        }
        return this.canvas.rowAscent;
    }

    public Dimension size() {
        if (this.canvas == null) {
            return null;
        }
        FontMetrics fontMetrics = this.canvas.getFontMetrics();
        Dimension dimension = new Dimension(0, 0);
        if (this.icon != null) {
            dimension.width += 20;
        } else if (this.text != null) {
            dimension.width += 4;
        }
        if (this.text != null) {
            dimension.width += fontMetrics.stringWidth(this.text) + 4;
        }
        dimension.height = this.canvas.rowHeight;
        return dimension;
    }
}

