/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_RANDOM_H
#define	_SYS_RANDOM_H

#pragma ident	"@(#)random.h	1.2	02/03/04 SMI"

#include <sys/types.h>
#include <sys/ioccom.h>
#include <sys/kstat.h>
#include <sys/atomic.h>

#ifdef	__cplusplus
extern "C" {
#endif

#define	RND_STATS_VER		1

/* kstats. */
typedef struct rnd_stats {
	uint32_t	rs_ver;		/* Current version number */
	uint32_t	rs_entEst;	/* Entropy estimate in bits */
	uint64_t	rs_rndOut;	/* Bytes generated for /dev/random */
	uint64_t	rs_urndOut;	/* Bytes generated for /dev/urandom */
	uint64_t	rs_entIn;	/* Entropy bits added to pool */
	uint64_t	rs_entOut;	/* Entropy bits extracted from pool */
	uint64_t	rs_bytesIn;	/* Total data bytes added to pool */
	uint64_t	rs_bytesOut;	/* Total data bytes extracted from */
					/* the pool */
} rnd_stats_t;

#ifdef	_KERNEL

#define	BUMP_RND_STATS(x, v)	atomic_add_64(&(rnd_stats).x, v)

extern int random_add_entropy(uint8_t *, size_t, uint16_t);
extern int random_get_bytes(uint8_t *, size_t);
extern int random_get_pseudo_bytes(uint8_t *, size_t);

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_RANDOM_H */
