/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class Utilities {
    public static final int INVALID_EXIT_CODE = -1;
    public static final String LOCAL_PROPERTIES = new String("local.properties");
    private static long lLocalModified = -1L;
    private static Properties localProperties = null;
    private static Properties oldLocalProperties = null;
    private static File localFile = new File(LOCAL_PROPERTIES);

    public static String getProperty(String keyString, String defaultValue) {
        Trace.traceAt(900, "In Utilities.getProperty (key, default).");
        String valueString = System.getProperty(keyString);
        if (valueString == null) {
            Utilities.readPropertiesFile();
            valueString = System.getProperty(keyString, defaultValue);
        }
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.getProperty (key, default).  Return:  ").append(valueString).append(".")));
        return valueString;
    }

    public static String getProperty(String keyString) {
        Trace.traceAt(900, "In Utilities.getProperty.");
        String valueString = System.getProperty(keyString);
        if (valueString == null) {
            Utilities.readPropertiesFile();
            valueString = System.getProperty(keyString);
            if (valueString == null) {
                Trace.warn("Unable to Read Properties File for Key: ".concat(String.valueOf(keyString)));
            }
        }
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.getProperty.  Return:  ").append(valueString).append(".")));
        return valueString;
    }

    public static void setProperty(String keyString, String valueString) {
        Trace.traceAt(900, "In Utilities.setLocalProperty.");
        try {
            if (localProperties != null) {
                ((Hashtable)localProperties).put(keyString, valueString);
                Utilities.writePropertiesFile();
            } else {
                Utilities.readPropertiesFile();
                ((Hashtable)localProperties).put(keyString, valueString);
                Utilities.writePropertiesFile();
            }
        }
        catch (Exception exception) {
            Trace.warn("Unable to update Local Properties File ");
            Trace.warn("Exception:  ".concat(String.valueOf(exception.toString())));
        }
        Trace.traceAt(900, "Out Utilities.setLocalProperty.");
    }

    private static void readPropertiesFile() {
        Trace.traceAt(900, "In Utilities.readLocalPropertiesFile.");
        try {
            if (Utilities.hasPropertiesFileChanged()) {
                oldLocalProperties = localProperties;
                localProperties = new Properties(System.getProperties());
                localProperties.load(new BufferedInputStream(new FileInputStream(LOCAL_PROPERTIES)));
                System.setProperties(localProperties);
            }
        }
        catch (Exception exception) {
            Trace.warn("Failed to Read Local Properties File.");
            Trace.warn("Exception:  ".concat(String.valueOf(exception.toString())));
        }
        Trace.traceAt(900, "Out Utilities.readLocalPropertiesFile.");
    }

    private static void writePropertiesFile() {
        Trace.traceAt(900, "In Utilities.writeLocalPropertiesFile.");
        try {
            localProperties.store(new FileOutputStream(LOCAL_PROPERTIES), "Properties File");
        }
        catch (Exception exception) {
            Trace.warn("Failed to write Local Properties File.");
            Trace.warn("Exception:  ".concat(String.valueOf(exception.toString())));
        }
        Trace.traceAt(900, "Out Utilities.writeLocalPropertiesFile.");
    }

    private static boolean hasPropertiesFileChanged() {
        boolean bHasLocalPropertiesFileChanged = false;
        Trace.traceAt(900, "In Utilities.hasLocalPropertiesFileChanged.");
        long lLocalCheckModified = localFile.lastModified();
        bHasLocalPropertiesFileChanged = lLocalModified != lLocalCheckModified;
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.hasLocalPropertiesFileChanged.  Return:  ").append(bHasLocalPropertiesFileChanged).append(".")));
        return bHasLocalPropertiesFileChanged;
    }

    private static boolean hasSectionChanged(String sectionNameString) {
        String oldSectionValueString = null;
        String sectionValueString = null;
        boolean bLocalSectionChanged = false;
        Trace.traceAt(900, "In Utilities.hasLocalSectionChanged.");
        sectionValueString = System.getProperty(sectionNameString);
        oldSectionValueString = oldLocalProperties.getProperty(sectionNameString);
        if (oldLocalProperties != null && !sectionValueString.equalsIgnoreCase(oldSectionValueString)) {
            bLocalSectionChanged = false;
            Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.hasLocalSectionChanged.  Return:  ").append(bLocalSectionChanged).append(".")));
            return bLocalSectionChanged;
        }
        bLocalSectionChanged = true;
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.hasLocalSectionChanged.  Return:  ").append(bLocalSectionChanged).append(".")));
        return bLocalSectionChanged;
    }

    public static int run(String commandLineString) {
        Runtime rt = Runtime.getRuntime();
        Process process = null;
        int iExit = -1;
        Trace.traceAt(900, "In Utilities.run.");
        try {
            Trace.traceAt(900, String.valueOf(new StringBuffer("Starting Command Line:  ").append(commandLineString).append(".")));
            process = rt.exec(commandLineString);
            try {
                iExit = process.exitValue();
            }
            catch (Exception exc) {
                Trace.warn(String.valueOf(new StringBuffer("Unable to get exit code from running process Exception:  ").append(exc.toString()).append(".")));
                iExit = 0;
            }
        }
        catch (Exception e) {
            Trace.warn(String.valueOf(new StringBuffer("Unable to execute command line:  ").append(commandLineString).append(" Exeception:  ").append(e.toString()).append(".")));
        }
        Trace.traceAt(900, "Out Utilities.run.");
        return iExit;
    }

    public static String removePathSeperator(String pathString) {
        Trace.traceAt(900, "In Utilities.removePathSeperator.");
        StringBuffer buffer = new StringBuffer("");
        String delims = new String("\\\\");
        StringTokenizer tokenizer = new StringTokenizer(pathString, delims);
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            if (tokenizer.countTokens() < 1) continue;
            buffer.append("?");
        }
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.removePathSeperator.  Returns:  ").append(buffer.toString()).append(".")));
        return buffer.toString();
    }

    public static String addPathSeperator(String pathString) {
        Trace.traceAt(900, "In Utilities.addPathSeperator.");
        StringBuffer buffer = new StringBuffer("");
        String delims = new String("?");
        StringTokenizer tokenizer = new StringTokenizer(pathString, delims);
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            if (tokenizer.countTokens() < 1) continue;
            buffer.append("\\");
        }
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out Utilities.addPathSeperator.  Returns:  ").append(buffer.toString()).append(".")));
        return buffer.toString();
    }
}

