/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.QConstants;
import com.qlogic.util.EntryManager;
import com.qlogic.util.HostEntry;
import com.qlogic.util.Trace;
import java.io.IOException;
import java.util.StringTokenizer;

public class HostManager
extends EntryManager {
    public static final int TOKEN_COUNT = 1;
    private static HostManager m_Instance = new HostManager();

    private HostManager() {
    }

    public static HostManager instance() {
        return m_Instance;
    }

    public synchronized boolean exists(String hostNameString) {
        HostEntry[] hosts;
        boolean bExists = false;
        Trace.traceAt(400, "HostManager.addEntry()");
        if (this.m_enabled && this.m_open && (hosts = this.getEntries()) != null) {
            for (int i = 0; i < hosts.length; ++i) {
                HostEntry hostentry = hosts[i];
                if (!hostentry.getHost().equalsIgnoreCase(hostNameString)) continue;
                bExists = true;
                break;
            }
        }
        return bExists;
    }

    public synchronized void addEntry(String hostNameString) {
        Trace.traceAt(400, "HostManager.addEntry()");
        if (this.m_enabled && this.m_open) {
            try {
                boolean bExists = false;
                HostEntry[] hosts = this.getEntries();
                if (hosts != null) {
                    for (int i = 0; i < hosts.length; ++i) {
                        HostEntry hostentry = hosts[i];
                        if (!hostentry.getHost().equalsIgnoreCase(hostNameString)) continue;
                        bExists = true;
                        break;
                    }
                }
                if (!bExists) {
                    hostNameString = hostNameString.toLowerCase();
                    this.m_file.write(hostNameString.getBytes());
                    this.m_file.write(System.getProperty("line.separator").getBytes());
                }
            }
            catch (IOException ex) {
                Trace.warn(String.valueOf(String.valueOf("Add of Entry failed.  Exception ").concat(String.valueOf(ex.toString()))).concat(String.valueOf(".")));
                ex.printStackTrace();
            }
        }
    }

    public synchronized HostEntry[] getEntries() {
        String lineString = null;
        String host = null;
        String delims = QConstants.getString("tab_delims");
        this.entryVector.removeAllElements();
        if (this.m_enabled && this.m_open) {
            block7: {
                try {
                    if (this.m_file.length() != (long)0) {
                        this.m_file.seek(0L);
                        while ((lineString = this.m_file.readLine()) != null) {
                            StringTokenizer tokenizer = new StringTokenizer(lineString, delims);
                            if (tokenizer.countTokens() == 1) {
                                while (tokenizer.hasMoreTokens()) {
                                    host = tokenizer.nextToken().trim();
                                    this.entryVector.add(new HostEntry(host));
                                }
                                continue;
                            }
                            Trace.traceAt(900, "HostManager.getEntries (): Invalid entry encountered and ignored.");
                        }
                        break block7;
                    }
                    HostEntry[] tokenizer = null;
                    return tokenizer;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Trace.traceAt(900, String.valueOf(String.valueOf("Returning ").concat(String.valueOf(this.entryVector.size()))).concat(String.valueOf(" Events.")));
            Object[] entries = new HostEntry[this.entryVector.size()];
            this.entryVector.copyInto(entries);
            return entries;
        }
        return null;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In HostManager.finalize()");
        Trace.traceAt(600, "This should not be called when the application is running.");
        m_Instance = null;
        super.finalize();
        Trace.traceAt(600, "Out HostManager.finalize()");
    }
}

