/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.QConstants;
import com.qlogic.util.EntryManager;
import com.qlogic.util.EventEntry;
import com.qlogic.util.EventLogListener;
import com.qlogic.util.EventLogNotifyRunnable;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class EventManager
extends EntryManager {
    public static final int TOKEN_COUNT = 4;
    private static EventManager m_instance = new EventManager();
    private Vector m_Listeners = new Vector();

    private EventManager() {
    }

    public static EventManager instance() {
        Trace.traceAt(400, "In EventManager.instance");
        Trace.traceAt(400, String.valueOf(String.valueOf("Out EventManager.instance.  Returns:  ").concat(String.valueOf(m_instance))).concat(String.valueOf(".")));
        return m_instance;
    }

    public void addEventLogListener(EventLogListener listener) {
        this.m_Listeners.addElement(listener);
    }

    public void removeEventLogListener(EventLogListener listener) {
        this.m_Listeners.removeElement(listener);
    }

    private void notifyListeners(EventEntry event) {
        Object[] listeners;
        Vector vector = this.m_Listeners;
        synchronized (vector) {
            try {
                listeners = new EventLogListener[this.m_Listeners.size()];
                this.m_Listeners.copyInto(listeners);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        if (listeners.length > 0) {
            EventLogNotifyRunnable runnable = new EventLogNotifyRunnable(event, (EventLogListener[])listeners);
            SwingUtilities.invokeLater(runnable);
        }
    }

    public synchronized void addEntry(Date timeStamp, int type, int severity, String description) {
        Trace.traceAt(400, "In EventManager.addEntry");
        if (this.m_Listeners.size() > 0) {
            EventEntry entry = new EventEntry(type, severity, timeStamp, description);
            this.notifyListeners(entry);
        }
        if (this.m_enabled && this.m_open) {
            try {
                boolean bLogWarnMessages;
                int iEventLimit = new Integer(Utilities.getProperty(QConstants.EVENT_LOG_SIZE_KEY));
                int iEventCount = 0;
                int iEventDiff = 0;
                EventEntry[] events = this.getEntries();
                iEventCount = events == null ? 0 : events.length;
                boolean bShouldWrite = true;
                if (severity == 0) {
                    boolean bLogInfoMessages = new Boolean(Utilities.getProperty(QConstants.LOG_INFORMATIONAL_KEY));
                    if (!bLogInfoMessages) {
                        bShouldWrite = false;
                    }
                } else if (severity == 1 && !(bLogWarnMessages = new Boolean(Utilities.getProperty(QConstants.LOG_WARNING_KEY)).booleanValue())) {
                    bShouldWrite = false;
                }
                if (iEventCount > iEventLimit) {
                    iEventDiff = iEventCount - iEventLimit;
                    if (bShouldWrite) {
                        ++iEventDiff;
                    }
                    this.truncate();
                    for (int i = iEventDiff; i < iEventCount; ++i) {
                        String date = QConstants.DATE_FORMAT.format(events[i].getTimeStamp());
                        this.m_file.write(date.getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(events[i].getApplicationType()).getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(events[i].getDescription().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(events[i].getSeverity()).getBytes());
                        this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                    }
                }
                if (bShouldWrite) {
                    String date = QConstants.DATE_FORMAT.format(timeStamp);
                    this.m_file.write(date.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(type).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(description.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(severity).getBytes());
                    this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                }
            }
            catch (IOException ex) {
                Trace.warn(String.valueOf(String.valueOf("Add of Entry failed.  Exception ").concat(String.valueOf(ex.toString()))).concat(String.valueOf(".")));
                ex.printStackTrace();
            }
        }
        Trace.traceAt(400, "Out EventManager.addEntry");
    }

    public synchronized EventEntry[] getEntries() {
        Trace.traceAt(900, "In EventManager.getEntries()");
        String lineString = null;
        int severity = 3;
        int type = 4;
        Date date = null;
        String description = null;
        Object junk = null;
        String delims = "\t\n\r,";
        boolean valid = true;
        this.entryVector.removeAllElements();
        if (this.m_enabled && this.m_open) {
            block13: {
                try {
                    if (this.m_file.length() != (long)0) {
                        this.m_file.seek(0L);
                        while ((lineString = this.m_file.readLine()) != null) {
                            StringTokenizer tokenizer = new StringTokenizer(lineString, delims);
                            valid = true;
                            if (tokenizer.countTokens() == 4) {
                                while (tokenizer.hasMoreTokens()) {
                                    try {
                                        date = QConstants.DATE_FORMAT.parse(tokenizer.nextToken().trim());
                                    }
                                    catch (ParseException pe) {
                                        valid = false;
                                        Trace.warn(String.valueOf("Failed to parse Event date: ").concat(String.valueOf(pe.toString())));
                                    }
                                    try {
                                        type = Integer.parseInt(tokenizer.nextToken().trim());
                                    }
                                    catch (NumberFormatException nfe1) {
                                        valid = false;
                                        Trace.warn(String.valueOf("Failed to parse Event application type: ").concat(String.valueOf(nfe1.toString())));
                                    }
                                    description = tokenizer.nextToken().trim();
                                    try {
                                        severity = Integer.parseInt(tokenizer.nextToken().trim());
                                    }
                                    catch (NumberFormatException nfe2) {
                                        valid = false;
                                        Trace.warn(String.valueOf("Failed to parse Event severity: ").concat(String.valueOf(nfe2.toString())));
                                    }
                                    if (!valid) continue;
                                    this.entryVector.add(new EventEntry(type, severity, date, description));
                                }
                                continue;
                            }
                            Trace.traceAt(900, "EventManager.getEntries (): Invalid entry encountered and ignored.");
                        }
                        break block13;
                    }
                    EventEntry[] tokenizer = null;
                    return tokenizer;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Trace.traceAt(900, String.valueOf(String.valueOf("Returning ").concat(String.valueOf(this.entryVector.size()))).concat(String.valueOf(" Events.")));
            Object[] entries = new EventEntry[this.entryVector.size()];
            this.entryVector.copyInto(entries);
            Trace.traceAt(900, String.valueOf(String.valueOf("Out EventManager.getEntries().  Returns:  ").concat(String.valueOf(this.entryVector.toArray()))).concat(String.valueOf(".")));
            return entries;
        }
        Trace.traceAt(900, String.valueOf(String.valueOf("Out EventManager.getEntries().  Returns:  ").concat(String.valueOf(null))).concat(String.valueOf(".")));
        return null;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In EventManager.finalize()");
        Trace.traceAt(600, "This should not be called when the application is running.");
        m_instance = null;
        super.finalize();
        Trace.traceAt(600, "Out EventManager.finalize()");
    }
}

