/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class TableTabAction
extends AbstractAction {
    private boolean m_MoveRight = true;

    public TableTabAction(boolean moveRight) {
        this.m_MoveRight = moveRight;
    }

    public void actionPerformed(ActionEvent e) {
        JTable table = (JTable)e.getSource();
        ListSelectionModel rsm = table.getSelectionModel();
        int anchorRow = rsm.getAnchorSelectionIndex();
        ListSelectionModel csm = table.getColumnModel().getSelectionModel();
        int anchorColumn = csm.getAnchorSelectionIndex();
        if (this.m_MoveRight) {
            this.doRight(anchorRow, anchorColumn, table);
        } else {
            this.doLeft(anchorRow, anchorColumn, table);
        }
    }

    protected void doRight(int anchorRow, int anchorCol, JTable table) {
        int col = anchorCol;
        int row = anchorRow;
        do {
            if (col < table.getColumnCount() - 1) {
                ++col;
                continue;
            }
            if (row < table.getRowCount() - 1) {
                col = 0;
                ++row;
                continue;
            }
            FocusManager.getCurrentManager().focusNextComponent(table);
            return;
        } while (table.getValueAt(row, col) == null);
        table.changeSelection(row, col, false, false);
    }

    protected void doLeft(int anchorRow, int anchorCol, JTable table) {
        int col = anchorCol;
        int row = anchorRow;
        do {
            if (col > 0 && col < table.getColumnCount()) {
                --col;
                continue;
            }
            if (row > 0 && row < table.getRowCount()) {
                col = table.getColumnCount() - 1;
                --row;
                continue;
            }
            FocusManager.getCurrentManager().focusPreviousComponent(table);
            return;
        } while (table.getValueAt(row, col) == null);
        table.changeSelection(row, col, false, false);
    }
}

