/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class SortableComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private Object[] values = new Object[0];
    private Object selectedObject = null;

    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.values.length;
    }

    public Object getElementAt(int index) {
        Object item = null;
        if (index >= 0 && index < this.values.length) {
            item = this.values[index];
        }
        return item;
    }

    public int getIndexOf(Object anObject) {
        int index = -1;
        if (anObject != null) {
            for (int i = 0; i < this.values.length && index < 0; ++i) {
                if (!anObject.equals(this.values[i])) continue;
                index = i;
            }
        }
        return index;
    }

    public void addElement(Object anObject) {
        if (anObject == null) {
            return;
        }
        Object[] temp = new Object[this.values.length + 1];
        System.arraycopy(this.values, 0, temp, 0, this.values.length);
        temp[this.values.length] = anObject;
        this.values = temp;
        if (this.values.length == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
        this.fireIntervalAdded(this, this.values.length - 1, this.values.length - 1);
    }

    public void insertElementAt(Object anObject, int index) {
        if (index < 0 || index < this.values.length) {
            // empty if block
        }
        Object[] temp = new Object[this.values.length + 1];
        System.arraycopy(this.values, 0, temp, 0, index);
        temp[index] = anObject;
        System.arraycopy(this.values, index, temp, index + 1, temp.length);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElementAt(int index) {
        if (index < 0 || index >= this.values.length || this.values.length < 1) {
            return;
        }
        Object removed = this.values[index];
        Object[] temp = new Object[this.values.length - 1];
        if (index > 0) {
            System.arraycopy(this.values, 0, temp, 0, index);
        }
        if (index + 1 < this.values.length) {
            // empty if block
        }
        System.arraycopy(this.values, index + 1, temp, index, temp.length);
        this.values = temp;
        if (removed.equals(this.selectedObject)) {
            this.selectedObject = this.values.length > 0 ? this.values[0] : null;
        }
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElement(Object anObject) {
        int index = this.getIndexOf(anObject);
        if (index >= 0) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.values.length > 0) {
            int firstIndex = 0;
            int lastIndex = this.values.length - 1;
            this.values = new Object[0];
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    public void sort() {
        Arrays.sort(this.values);
        this.fireContentsChanged(this, 0, this.values.length);
    }

    public void sort(Comparator c) {
        Arrays.sort(this.values, c);
        this.fireContentsChanged(this, 0, this.values.length);
    }
}

