/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import java.util.Date;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SortModelAdapter
extends AbstractTableModel
implements TableModelListener {
    private TableModel m_TableModel = null;
    private int[] m_Indices = null;
    private int m_SortColumn = -1;
    private boolean m_SortAscend;

    public SortModelAdapter(TableModel model) {
        this.m_TableModel = model;
        if (this.m_TableModel != null) {
            this.m_TableModel.addTableModelListener(this);
        }
    }

    protected void finalize() throws Throwable {
        if (this.m_TableModel != null) {
            this.m_TableModel.removeTableModelListener(this);
            this.m_TableModel = null;
        }
        super.finalize();
    }

    public void setValueAt(Object value, int row, int col) {
        if (this.m_TableModel != null) {
            this.m_TableModel.setValueAt(value, this.mapRow(row), col);
        }
    }

    public Class getColumnClass(int col) {
        if (this.m_TableModel != null) {
            return this.m_TableModel.getColumnClass(col);
        }
        return Class.forName("java.lang.String");
    }

    public int getColumnCount() {
        return this.m_TableModel != null ? this.m_TableModel.getColumnCount() : 0;
    }

    public String getColumnName(int col) {
        if (this.m_TableModel != null) {
            return this.m_TableModel.getColumnName(col);
        }
        return "";
    }

    public int getRowCount() {
        return this.m_TableModel != null ? this.m_TableModel.getRowCount() : 0;
    }

    public Object getValueAt(int row, int col) {
        if (this.m_TableModel != null) {
            return this.m_TableModel.getValueAt(this.mapRow(row), col);
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return this.m_TableModel != null && this.m_TableModel.isCellEditable(this.mapRow(row), col);
    }

    public void sort(int col, boolean ascend) {
        if (col < 0 || col >= this.getColumnCount()) {
            return;
        }
        this.m_SortColumn = col;
        this.m_SortAscend = ascend;
        this.checkIndices();
        for (int i = 0; i < this.getRowCount() - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.m_SortAscend) {
                    if (this.compare(this.m_SortColumn, j, k) >= 0) continue;
                    k = j;
                    continue;
                }
                if (this.compare(this.m_SortColumn, j, k) <= 0) continue;
                k = j;
            }
            int tmp = this.m_Indices[i];
            this.m_Indices[i] = this.m_Indices[k];
            this.m_Indices[k] = tmp;
        }
        this.fireTableDataChanged();
    }

    private int compare(int col, int row1, int row2) {
        Object obj1 = this.getValueAt(row1, col);
        Object obj2 = this.getValueAt(row2, col);
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        Class c = this.getColumnClass(col);
        if (c.getSuperclass() == Class.forName("java.lang.Number")) {
            return this.compare((Number)obj1, (Number)obj2);
        }
        if (c == Class.forName("java.util.Date")) {
            return this.compare((Date)obj1, (Date)obj2);
        }
        if (c == Class.forName("java.lang.Boolean")) {
            return this.compare((Boolean)obj1, (Boolean)obj2);
        }
        return obj1.toString().compareTo(obj2.toString());
    }

    private int compare(Number n1, Number n2) {
        if (n1.doubleValue() > n2.doubleValue()) {
            return 1;
        }
        return -1;
    }

    private int compare(Boolean b1, Boolean b2) {
        if (b1.booleanValue()) {
            return 1;
        }
        return -1;
    }

    private int compare(Date d1, Date d2) {
        if (d1.getTime() > d2.getTime()) {
            return 1;
        }
        return -1;
    }

    private void checkIndices() {
        int count = this.getRowCount();
        if (this.m_Indices == null || this.m_Indices.length != count) {
            this.m_Indices = new int[count];
            for (int i = 0; i < count; ++i) {
                this.m_Indices[i] = i;
            }
        }
    }

    private int mapRow(int row) {
        int mappedRow = row;
        if (this.m_Indices != null) {
            mappedRow = this.m_Indices[row];
        }
        return mappedRow;
    }

    public void tableChanged(TableModelEvent tme) {
        this.sort(this.m_SortColumn, this.m_SortAscend);
        this.fireTableChanged(tme);
        this.checkIndices();
    }
}

