/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.util.SplashInfo;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SplashPanel
extends JPanel {
    private String m_VersionText = null;
    private int m_VersionX = 0;
    private int m_VersionY = 0;
    private Icon m_Icon = null;
    private boolean m_PaintVersion = true;

    public SplashPanel(SplashInfo info, Icon icon) {
        if (info != null) {
            this.m_VersionText = info.getVersionText();
            this.m_VersionX = info.getVersionXLocation();
            this.m_VersionY = info.getVersionYLocation();
            this.m_PaintVersion = info.paintSplash();
            this.setBackground(info.getBackgroundColor());
            this.setForeground(info.getTextColor());
        }
        this.m_Icon = icon;
    }

    private Insets getBorderInsets() {
        Border border = this.getBorder();
        Insets insets = null;
        if (border != null) {
            insets = border.getBorderInsets(this);
        }
        return insets;
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        super.paint(g);
        if (this.m_Icon != null) {
            int x = 0;
            int y = 0;
            Insets insets = this.getBorderInsets();
            if (insets != null) {
                // empty if block
            }
            this.m_Icon.paintIcon(this, g, x += insets.left, y += insets.top);
        }
        g.setColor(this.getForeground());
        if (this.m_VersionText != null && this.m_PaintVersion) {
            g.drawString(this.m_VersionText, this.m_VersionX, this.m_VersionY);
        }
    }

    public Dimension getPreferredSize() {
        Insets insets;
        Dimension dims = new Dimension(0, 0);
        if (this.m_Icon != null) {
            dims.width = this.m_Icon.getIconWidth();
            dims.height = this.m_Icon.getIconHeight();
        }
        if ((insets = this.getBorderInsets()) != null) {
            dims.width += insets.left + insets.right;
            dims.height += insets.top + insets.bottom + 1;
        }
        return dims;
    }
}

