/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.ui.tools.TreeControl;
import com.qlogic.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends JFrame
implements ChangeListener,
WindowListener {
    public static final int TREE_PANE_WIDTH = 175;
    public static final int TREE_PANE_HEIGHT = 100;
    private static MainFrame INSTANCE = null;
    private JPanel m_ContentPanel = new JPanel(new BorderLayout());
    private JSplitPane m_SplitPane = new JSplitPane();
    private JTabbedPane m_Tabs = new JTabbedPane();
    private JToolBar m_ToolBar = null;
    private JComponent m_StatusBar = null;
    private TreeControl[] m_Controls = null;

    private MainFrame() {
        this.m_SplitPane.setRightComponent(new Panel());
        this.m_SplitPane.setLeftComponent(this.m_Tabs);
        this.m_ContentPanel.add((Component)this.m_SplitPane, "Center");
        this.getContentPane().add((Component)this.m_ContentPanel, "Center");
        ((Component)this).setSize(800, 575);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public static MainFrame instance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new MainFrame();
            }
            catch (InternalError er) {
                System.exit(1);
            }
        }
        return INSTANCE;
    }

    public void addControls(TreeControl[] controls) {
        this.m_Controls = controls;
        for (int i = 0; i < this.m_Controls.length; ++i) {
            this.m_Controls[i].setTarget(this.m_SplitPane);
            JScrollPane pane = new JScrollPane(this.m_Controls[i].getTree());
            pane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
            pane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 1));
            pane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 2));
            pane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            pane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 1));
            pane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 2));
            pane.setPreferredSize(new Dimension(175, 100));
            this.m_Tabs.add((Component)pane, this.m_Controls[i].getTreeName());
        }
        this.updateDisplay(this.m_Tabs.getSelectedIndex());
        this.m_Tabs.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        this.updateDisplay(this.m_Tabs.getSelectedIndex());
    }

    private void updateDisplay(int index) {
        if (index >= 0) {
            this.setJMenuBar(this.m_Controls[index].getMenuBar());
            if (this.m_ToolBar != null) {
                Window window = SwingUtilities.windowForComponent(this.m_ToolBar);
                if (window == this) {
                    this.getContentPane().remove(this.m_ToolBar);
                    this.m_ToolBar.setOrientation(0);
                } else if (window != null) {
                    window.dispose();
                }
            }
            if (this.m_StatusBar != null) {
                this.m_ContentPanel.remove(this.m_StatusBar);
            }
            this.m_ToolBar = this.m_Controls[index].getToolBar();
            this.m_StatusBar = this.m_Controls[index].getStatusBar();
            this.getContentPane().add((Component)this.m_ToolBar, "North");
            this.m_ContentPanel.add((Component)this.m_StatusBar, "South");
            this.m_Controls[index].updateTarget();
            this.setTitle(this.m_Controls[index].getApplicationTitle());
            this.m_StatusBar.updateUI();
            this.validate();
        }
    }

    public void requestShutdown() {
        boolean proceed = true;
        int i = 0;
        if (this.m_Controls != null) {
            for (i = 0; i < this.m_Controls.length && proceed; ++i) {
                if (this.m_Controls[i].isShutdownReady()) continue;
                proceed = false;
                break;
            }
            if (proceed) {
                ((Component)this).setVisible(false);
                for (i = 0; i < this.m_Controls.length; ++i) {
                    this.m_Controls[i].shutdown();
                }
                Trace.warn("Exiting Application");
                System.exit(0);
            } else {
                Trace.warn(String.valueOf(new StringBuffer("Unable to shutdown at this time, Control:  ").append(i).append(" is not ready!")));
            }
        } else {
            Trace.warn("No Control(s) to shutdown!");
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.requestShutdown();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

