/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.util.AlarmEntry;
import com.qlogic.util.TypeConstants;
import javax.swing.table.AbstractTableModel;

public class AlarmTableModel
extends AbstractTableModel {
    public static final int TIME_STAMP = 0;
    public static final int HOST_NAME = 1;
    public static final int ADAPTER_ID = 2;
    public static final int APPLICATION_TYPE = 3;
    public static final int DESCRIPTION = 4;
    private AlarmEntry[] m_Alarms = null;
    private static final String[] HEADERS = new String[]{QConstants.getString("alarm_hdr_time"), QConstants.getString("alarm_hdr_name"), QConstants.getString("alarm_hdr_id"), QConstants.getString("alarm_hdr_app"), QConstants.getString("alarm_hdr_desc")};

    public AlarmTableModel(AlarmEntry[] alarms) {
        this.m_Alarms = alarms;
    }

    public int getColumnCount() {
        return HEADERS.length;
    }

    public void addAlarm(AlarmEntry alarm) {
        AlarmEntry[] alarms;
        int insertRow;
        AlarmEntry[] oldAlarms = this.m_Alarms;
        if (oldAlarms == null) {
            insertRow = 0;
            alarms = new AlarmEntry[]{alarm};
        } else {
            insertRow = this.m_Alarms.length;
            alarms = new AlarmEntry[this.m_Alarms.length + 1];
            System.arraycopy(this.m_Alarms, 0, alarms, 1, this.m_Alarms.length);
            alarms[0] = alarm;
        }
        this.m_Alarms = alarms;
        this.fireTableRowsInserted(insertRow, insertRow);
    }

    public void setData(AlarmEntry[] alarms) {
        this.m_Alarms = alarms;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.m_Alarms == null) {
            return 0;
        }
        return this.m_Alarms.length;
    }

    public String getColumnName(int col) {
        return HEADERS[col];
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return Class.forName("java.util.Date");
        }
        return Class.forName("java.lang.String");
    }

    public Object getValueAt(int row, int col) {
        if (this.m_Alarms == null) {
            return null;
        }
        AlarmEntry alarm = this.m_Alarms[row];
        switch (col) {
            case 0: {
                return alarm.getTimeStamp();
            }
            case 1: {
                return alarm.getHostName();
            }
            case 2: {
                return alarm.getAdapterID();
            }
            case 3: {
                return TypeConstants.getTypeString(alarm.getApplicationType());
            }
            case 4: {
                return alarm;
            }
        }
        return null;
    }
}

