/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.SkinConstants;
import com.qlogic.ui.AlarmRenderer;
import com.qlogic.ui.AlarmTableModel;
import com.qlogic.ui.tools.AlarmsPrintable;
import com.qlogic.ui.tools.DetailsDialog;
import com.qlogic.ui.tools.SortControl;
import com.qlogic.ui.tools.SortHeaderRenderer;
import com.qlogic.ui.tools.SortModelAdapter;
import com.qlogic.util.AlarmEntry;
import com.qlogic.util.AlarmFilter;
import com.qlogic.util.AlarmListener;
import com.qlogic.util.AlarmManager;
import com.qlogic.util.QPageable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AlarmDialog
extends JDialog
implements ActionListener,
WindowListener,
AlarmListener,
MouseListener {
    private AlarmTableModel m_AlarmModel = null;
    private AlarmFilter m_PreFilter = null;
    private JButton m_ClearButton = new JButton(QConstants.getString("Clear"));
    private JButton m_OKButton = new JButton(QConstants.getString("OK"));
    private JButton m_PrintButton = new JButton("Print");
    private JTable m_AlarmTable = new JTable();

    public AlarmDialog(Frame frame, AlarmFilter preFilter) {
        super(frame, QConstants.getString("Alarm_Log"), true);
        int width;
        this.m_PreFilter = preFilter;
        JPanel basePanel = new JPanel(new GridBagLayout());
        JPanel tablePanel = new JPanel(new GridLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 4, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.m_AlarmTable.setShowHorizontalLines(false);
        this.m_AlarmTable.setShowVerticalLines(false);
        this.m_AlarmModel = new AlarmTableModel(null);
        this.updateTable();
        SortModelAdapter sma = new SortModelAdapter(this.m_AlarmModel);
        SortControl sc = new SortControl();
        sc.setSortableModel(sma);
        this.m_AlarmTable.setModel(sma);
        sc.install(this.m_AlarmTable);
        AlarmRenderer renderer = new AlarmRenderer();
        TableColumnModel columnModel = this.m_AlarmTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(175);
        column.setMinWidth(100);
        column.setWidth(175);
        column.setCellRenderer(renderer);
        column = columnModel.getColumn(1);
        column.setPreferredWidth(100);
        column.setMinWidth(50);
        column.setWidth(100);
        column.setCellRenderer(renderer);
        column = columnModel.getColumn(2);
        column.setPreferredWidth(75);
        column.setMinWidth(50);
        column.setWidth(75);
        column.setCellRenderer(renderer);
        column = columnModel.getColumn(3);
        column.setPreferredWidth(100);
        column.setMinWidth(50);
        column.setWidth(100);
        column.setCellRenderer(renderer);
        column = columnModel.getColumn(4);
        column.setPreferredWidth(200);
        column.setMinWidth(100);
        column.setWidth(200);
        column.setCellRenderer(renderer);
        FontMetrics metrics = this.getFontMetrics(sc.getRenderer().getFont());
        SortHeaderRenderer headerRenderer = sc.getRenderer();
        headerRenderer.setSortIcons(SkinConstants.SORT_UP_IMAGE, SkinConstants.SORT_DOWN_IMAGE);
        Insets margin = headerRenderer.getMargin();
        Insets insets = headerRenderer.getInsets();
        int pad = headerRenderer.getMaxIconWidth();
        pad += margin.left + margin.right;
        pad += insets.left + insets.right;
        pad += 4;
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            String header = (String)columnModel.getColumn(i).getIdentifier();
            if (metrics == null || header == null) continue;
            width = metrics.stringWidth(header) + pad;
            column = columnModel.getColumn(i);
            column.setPreferredWidth(Math.max(column.getPreferredWidth(), width));
            column.setWidth(Math.max(column.getWidth(), width));
        }
        Date longDate = (Date)QConstants.getObject("long_date");
        String longestDate = QConstants.DATE_FORMAT.format(longDate);
        width = metrics.stringWidth(longestDate);
        column = columnModel.getColumn(0);
        column.setPreferredWidth(Math.max(column.getPreferredWidth(), width));
        column.setWidth(Math.max(column.getWidth(), width));
        Dimension size = new Dimension(columnModel.getTotalColumnWidth(), 400);
        this.m_AlarmTable.setPreferredScrollableViewportSize(size);
        basePanel.add((Component)tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        tablePanel.add(scrollPane);
        scrollPane.getViewport().add(this.m_AlarmTable);
        scrollPane.getViewport().setBackground(this.m_AlarmTable.getBackground());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 0, 10, 0);
        basePanel.add((Component)this.createKeyPanel(), gbc);
        basePanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 0, 4, 8), 0, 0));
        buttonPanel.add(this.m_OKButton);
        buttonPanel.add(this.m_ClearButton);
        buttonPanel.add(this.m_PrintButton);
        this.getContentPane().add(basePanel);
        this.setDefaultCloseOperation(0);
        this.m_AlarmTable.addMouseListener(this);
        AlarmManager.instance().addAlarmListener(this);
        this.m_ClearButton.addActionListener(this);
        this.m_OKButton.addActionListener(this);
        this.m_PrintButton.addActionListener(this);
        this.addWindowListener(this);
        this.pack();
    }

    private JPanel createKeyPanel() {
        JPanel keyPanel = new JPanel(new GridLayout(1, 4, 8, 0));
        JLabel goodLabel = new JLabel(QConstants.getString("info_alarm"), 0);
        JLabel badLabel = new JLabel(QConstants.getString("bad_alarm"), 0);
        JLabel unknownLabel = new JLabel(QConstants.getString("unknown_alarm"), 0);
        JLabel warningLabel = new JLabel(QConstants.getString("warning_alarm"), 0);
        goodLabel.setOpaque(true);
        badLabel.setOpaque(true);
        unknownLabel.setOpaque(true);
        warningLabel.setOpaque(true);
        LineBorder border = new LineBorder(Color.black);
        goodLabel.setBorder(border);
        badLabel.setBorder(border);
        unknownLabel.setBorder(border);
        warningLabel.setBorder(border);
        goodLabel.setForeground(AlarmRenderer.INFO_FORE);
        goodLabel.setBackground(AlarmRenderer.INFO_BACK);
        badLabel.setForeground(AlarmRenderer.BAD_FORE);
        badLabel.setBackground(AlarmRenderer.BAD_BACK);
        warningLabel.setForeground(AlarmRenderer.WARN_FORE);
        warningLabel.setBackground(AlarmRenderer.WARN_BACK);
        unknownLabel.setForeground(AlarmRenderer.UKWN_FORE);
        unknownLabel.setBackground(AlarmRenderer.UKWN_BACK);
        keyPanel.add(goodLabel);
        keyPanel.add(unknownLabel);
        keyPanel.add(warningLabel);
        keyPanel.add(badLabel);
        return keyPanel;
    }

    public void clearTable() {
        int result = JOptionPane.showConfirmDialog(this, QConstants.getString("clear_alarms_msg"), QConstants.getString("clear_alarms_title"), 2);
        if (result != 0) {
            return;
        }
        AlarmManager alarmManager = AlarmManager.instance();
        if (this.m_PreFilter != null) {
            alarmManager.removeFilteredEntries(this.m_PreFilter);
        } else {
            alarmManager.truncate();
        }
        this.m_AlarmModel.setData(null);
    }

    public void okPressed() {
        AlarmManager.instance().removeAlarmListener(this);
        this.dispose();
    }

    public void printPressed() {
        AlarmEntry[] entries = AlarmManager.instance().getEntries();
        AlarmsPrintable p = new AlarmsPrintable(entries);
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat format = new PageFormat();
        Paper paper = new Paper();
        double margin = 16.0;
        paper.setImageableArea(margin, margin, paper.getWidth() - margin * (double)2, paper.getHeight() - margin * (double)2);
        format.setPaper(paper);
        QPageable pageable = new QPageable(p, format);
        pj.setPageable(pageable);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException ex) {
                System.out.println(ex);
            }
        }
    }

    private void updateTable() {
        AlarmEntry[] entries = AlarmManager.instance().getEntries();
        if (this.m_PreFilter != null) {
            entries = this.m_PreFilter.filterAlarms(entries);
            this.m_AlarmModel.setData(entries);
        } else {
            this.m_AlarmModel.setData(entries);
        }
    }

    public void alarmDetected(AlarmEntry alarm) {
        if (this.m_PreFilter.alarmMatchesFilter(alarm)) {
            this.m_AlarmModel.addAlarm(alarm);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_ClearButton) {
            this.clearTable();
        } else if (obj == this.m_OKButton) {
            this.okPressed();
        } else if (obj == this.m_PrintButton) {
            this.printPressed();
        }
    }

    public void mouseClicked(MouseEvent e) {
        block4: {
            int result;
            Point p;
            int row;
            if (e.getClickCount() <= 1 || (row = this.m_AlarmTable.rowAtPoint(p = e.getPoint())) <= -1) break block4;
            SortModelAdapter sortModel = (SortModelAdapter)this.m_AlarmTable.getModel();
            DetailsDialog dd = new DetailsDialog(this, QConstants.getString("alarm_details"));
            dd.setLocationRelativeTo(this);
            this.updateDetailsDialog(dd, sortModel, row);
            this.updateDetailsDialog(dd, sortModel, row);
            while ((result = dd.display()) != 0) {
                int confirm;
                if (result == 1) {
                    if (row < this.m_AlarmTable.getRowCount() - 1) {
                        this.m_AlarmTable.changeSelection(++row, this.m_AlarmTable.getSelectedColumn(), false, false);
                        this.updateDetailsDialog(dd, sortModel, row);
                        continue;
                    }
                    confirm = JOptionPane.showConfirmDialog(this, "You are at the end.  Do you wish to move to the beginning?", "Event log", 0);
                    if (confirm != 0) continue;
                    row = 0;
                    this.m_AlarmTable.changeSelection(row, this.m_AlarmTable.getSelectedColumn(), false, false);
                    this.updateDetailsDialog(dd, sortModel, row);
                    continue;
                }
                if (row > 0) {
                    this.m_AlarmTable.changeSelection(--row, this.m_AlarmTable.getSelectedColumn(), false, false);
                    this.updateDetailsDialog(dd, sortModel, row);
                    continue;
                }
                confirm = JOptionPane.showConfirmDialog(this, "You are at the beginning.  Do you wish to move to the end?", "Event log", 0);
                if (confirm != 0) continue;
                row = this.m_AlarmTable.getRowCount() - 1;
                this.m_AlarmTable.changeSelection(row, this.m_AlarmTable.getSelectedColumn(), false, false);
                this.updateDetailsDialog(dd, sortModel, row);
            }
            dd.dispose();
        }
    }

    private void updateDetailsDialog(DetailsDialog dd, SortModelAdapter sortModel, int row) {
        dd.setText("");
        dd.append(sortModel.getColumnName(0));
        dd.append(": ");
        dd.append(sortModel.getValueAt(row, 0).toString());
        dd.append("\n");
        dd.append(sortModel.getColumnName(1));
        dd.append(": ");
        dd.append(sortModel.getValueAt(row, 1).toString());
        dd.append("\n");
        dd.append(sortModel.getColumnName(2));
        dd.append(": ");
        dd.append(sortModel.getValueAt(row, 2).toString());
        dd.append("\n\n");
        dd.append(sortModel.getColumnName(4));
        dd.append("\n");
        dd.append(sortModel.getValueAt(row, 4).toString());
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.okPressed();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

