/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic;

import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.awt.Color;
import java.awt.Point;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SkinConstants {
    private static final String DEFAULT_PATH = "skins/qlogic/";
    private static final String SKINS_PATH_KEY = "skins.path";
    private static final String TEXT_KEY = "skin";
    private static final String SKINS_PATH = Utilities.getProperty("skins.path", "skins/qlogic/");
    private static final ResourceBundle TEXT_BUNDLE = SkinConstants.getTextBundle();
    public static final Color DEFAULT_COLOR = Color.white;
    public static final String DEFAULT_LOCATION = "Center";
    public static final String TREE_IMAGE_PATH = String.valueOf(SKINS_PATH).concat(String.valueOf("tree_simplify.gif"));
    public static final Icon ABOUT_IMAGE = SkinConstants.getIcon("about.gif");
    public static final Icon ABOUT_DEVICE_IMAGE = SkinConstants.getIcon("about_device.gif");
    public static final Icon ABOUT_DIALOG_IMAGE = SkinConstants.getIcon("about_dialog.gif");
    public static final Icon ABOUT_LUN_IMAGE = SkinConstants.getIcon("about_lun.gif");
    public static final Icon ADAOTER_BAD_IMAGE = SkinConstants.getIcon("adapter_bad.gif");
    public static final Icon ADAPTER_GOOD_IMAGE = SkinConstants.getIcon("adapter_good.gif");
    public static final Icon ADAPTER_INFO_IMAGE = SkinConstants.getIcon("adapter_info.gif");
    public static final Icon ADAPTER_LOOP_DOWN_IMAGE = SkinConstants.getIcon("adapter_loop_down.gif");
    public static final Icon ADAPTER_TOGGLE_IMAGE = SkinConstants.getIcon("adapter_toggle.gif");
    public static final Icon ADAPTER_UNKNOWN_IMAGE = SkinConstants.getIcon("adapter_unknown.gif");
    public static final Icon ADAPTER_WARN_IMAGE = SkinConstants.getIcon("adapter_warn.gif");
    public static final Icon ALARM_IMAGE = SkinConstants.getIcon("alarm.gif");
    public static final Icon ALARM_DISABLE_IMAGE = SkinConstants.getIcon("alarm_disable.gif");
    public static final Icon ALTERNATE_IMAGE = SkinConstants.getIcon("alternate.gif");
    public static final Icon APPLICATION_IMAGE = SkinConstants.getIcon("Application.gif");
    public static final Icon ARROW_IMAGE = SkinConstants.getIcon("arrow.gif");
    public static final Icon CD_IMAGE = SkinConstants.getIcon("cd.gif");
    public static final Icon CDROM_DEVICE_IMAGE = SkinConstants.getIcon("cdrom_device.gif");
    public static final Icon CDROM_DEVICE_UNKNOWN_IMAGE = SkinConstants.getIcon("cdrom_device_unknown.gif");
    public static final Icon CDROM_IMAGE = SkinConstants.getIcon("cd_rom.gif");
    public static final Icon CHIP_IMAGE = SkinConstants.getIcon("chip.gif");
    public static final Icon CLOCK_IMAGE = SkinConstants.getIcon("clock.gif");
    public static final Icon CONFIG_IMAGE = SkinConstants.getIcon("config.gif");
    public static final Icon CONFIG_DISABLE_IMAGE = SkinConstants.getIcon("config_disable.gif");
    public static final Icon REFRESH_IMAGE = SkinConstants.getIcon("refresh.gif");
    public static final Icon REFRESH_DISABLE_IMAGE = SkinConstants.getIcon("refresh_disabled.gif");
    public static final Icon CONNECT_IMAGE = SkinConstants.getIcon("connect.GIF");
    public static final Icon CONNECTED_IMAGE = SkinConstants.getIcon("connected.gif");
    public static final Icon CONNECTED_DISABLE_IMAGE = SkinConstants.getIcon("connected_disable.gif");
    public static final Icon CORNER_IMAGE = SkinConstants.getIcon("corner.gif");
    public static final Icon CURRENT_ALTERNATE_IMAGE = SkinConstants.getIcon("current_alternate.gif");
    public static final Icon CURRENT_PREFERRED_IMAGE = SkinConstants.getIcon("current_preferred.gif");
    public static final Icon DEVICE_IMAGE = SkinConstants.getIcon("device.gif");
    public static final Icon DEVICE_INFO_IMAGE = SkinConstants.getIcon("deviceinfo.gif");
    public static final Icon DEVICE_LIST_IMAGE = SkinConstants.getIcon("device_list.gif");
    public static final Icon DEV_REP_WIZARD_IMAGE = SkinConstants.getIcon("DevRepWizard.gif");
    public static final Icon DIAG_ERR_IMAGE = SkinConstants.getIcon("diag_error.gif");
    public static final Icon DIAG_INFO_IMAGE = SkinConstants.getIcon("diag_info.gif");
    public static final Icon DIAG_SUCCESS_IMAGE = SkinConstants.getIcon("diag_success.gif");
    public static final Icon DIAG_WARN_IMAGE = SkinConstants.getIcon("diag_warn.gif");
    public static final Icon DIAG_WARN_LG_IMAGE = SkinConstants.getIcon("diag_warn_large.gif");
    public static final Icon DISK_DEVICE_IMAGE = SkinConstants.getIcon("disk_device.gif");
    public static final Icon DISK_DEVICE_INACTIVE_IMAGE = SkinConstants.getIcon("disk_device_inactive.gif");
    public static final Icon DISK_DEVICE_UNK_IMAGE = SkinConstants.getIcon("disk_device_unknown.gif");
    public static final Icon DRIVE_INFO_IMAGE = SkinConstants.getIcon("driveinfo.gif");
    public static final Icon EARTH_IMAGE = SkinConstants.getIcon("earth.gif");
    public static final Icon EAST_ARROW_IMAGE = SkinConstants.getIcon("EastArrow.gif");
    public static final Icon EMPG_IMAGE = SkinConstants.getIcon("empg.gif");
    public static final Icon EMPG_CHIPS_IMAGE = SkinConstants.getIcon("empgchips.gif");
    public static final Icon ERROR_IMAGE = SkinConstants.getIcon("error.gif");
    public static final Icon EVENT_IMAGE = SkinConstants.getIcon("event.gif");
    public static final Icon EVENT_LOG_IMAGE = SkinConstants.getIcon("event_log_button.gif");
    public static final Icon EVENT_LOG_DISABLE_IMAGE = SkinConstants.getIcon("event_log_button_disable.gif");
    public static final Icon EYE_IMAGE = SkinConstants.getIcon("eye.gif");
    public static final Icon FAILOVER_IMAGE = SkinConstants.getIcon("failover.gif");
    public static final Icon FIBRE_ADAPTER_IMAGE = SkinConstants.getIcon("fibreadapter.gif");
    public static final Icon FIBRE_CONFIG_IMAGE = SkinConstants.getIcon("fibreconfig.gif");
    public static final Icon FIBRE_LUN_CONFIG_IMAGE = SkinConstants.getIcon("fibrelunconfig.gif");
    public static final Icon HIDDEN_IMAGE = SkinConstants.getIcon("hidden.gif");
    public static final Icon HOST_IMAGE = SkinConstants.getIcon("host.gif");
    public static final Icon HOST_PING_IMAGE = SkinConstants.getIcon("host_ping.gif");
    public static final Icon HOSTS_IMAGE = SkinConstants.getIcon("hosts.gif");
    public static final Icon HOST_UNK_IMAGE = SkinConstants.getIcon("host_unknown.gif");
    public static final Icon INFO_IMAGE = SkinConstants.getIcon("info.gif");
    public static final Icon JWIZARD_IMAGE = SkinConstants.getIcon("JWizard.GIF");
    public static final Icon LINK_STATUS_IMAGE = SkinConstants.getIcon("link_status.gif");
    public static final Icon LOGO_SMALL_IMAGE = SkinConstants.getIcon("logo_small.gif");
    public static final Icon LUN_IMAGE = SkinConstants.getIcon("lun.gif");
    public static final Icon LUN_UNK_IMAGE = SkinConstants.getIcon("lun_unknown.gif");
    public static final Icon MANAGED_IMAGE = SkinConstants.getIcon("managed.gif");
    public static final Icon OPEN_FILE_IMAGE = SkinConstants.getIcon("openFile.gif");
    public static final Icon PATH_INFO_IMAGE = SkinConstants.getIcon("pathinfo.gif");
    public static final Icon PORTMAP_IMAGE = SkinConstants.getIcon("portmap.gif");
    public static final Icon PPG_IMAGE = SkinConstants.getIcon("ppg.gif");
    public static final Icon PPG_CHIPS_IMAGE = SkinConstants.getIcon("ppgchips.gif");
    public static final Icon PREFERRED_IMAGE = SkinConstants.getIcon("preferred.gif");
    public static final Icon BIG_LOGO_IMAGE = SkinConstants.getIcon("bigLogo.gif");
    public static final Icon SAFTE_DEVICE_IMAGE = SkinConstants.getIcon("safte_device.gif");
    public static final Icon SAFTE_DEVICE_UNK_IMAGE = SkinConstants.getIcon("safte_device_unknown.gif");
    public static final Icon SORT_DOWN_IMAGE = SkinConstants.getIcon("sortdown.gif");
    public static final Icon SORT_UP_IMAGE = SkinConstants.getIcon("sortup.gif");
    public static final Icon SPLASH_IMAGE = SkinConstants.getIcon("splash.gif");
    public static final Icon STOP_IMAGE = SkinConstants.getIcon("stop.gif");
    public static final Icon TAPE_INFO_IMAGE = SkinConstants.getIcon("tapeinfo.gif");
    public static final Icon TAPE_DEVICE_IMAGE = SkinConstants.getIcon("tape_device.gif");
    public static final Icon TAPE_DEVICE_UNK_IMAGE = SkinConstants.getIcon("tape_device_unknown.gif");
    public static final Icon TOPO_ADAPTER_IMAGE = SkinConstants.getIcon("topo_adapter.gif");
    public static final Icon TOPO_DEVICE_IMAGE = SkinConstants.getIcon("topo_device.gif");
    public static final Icon UNINSTALL_IMAGE = SkinConstants.getIcon("Uninstall.gif");
    public static final Icon UTILITIES_IMAGE = SkinConstants.getIcon("utilities.gif");
    public static final Icon VIRTUAL_IMAGE = SkinConstants.getIcon("virtual.gif");
    public static final Icon WARN_IMAGE = SkinConstants.getIcon("warn.gif");
    public static final Icon WARNING_IMAGE = SkinConstants.getIcon("warning.gif");
    public static final Icon WEST_ARROW_IMAGE = SkinConstants.getIcon("WestArrow.gif");

    private static final ResourceBundle getTextBundle() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(String.valueOf(SKINS_PATH).concat(String.valueOf(TEXT_KEY)));
        }
        catch (MissingResourceException mre) {
            bundle = null;
            Trace.warn("Failed to load text resource bundle: skin");
        }
        return bundle;
    }

    public static Icon getIcon(String fileName) {
        ImageIcon icon = null;
        Object url = null;
        if (fileName != null && (icon = new ImageIcon(String.valueOf(SKINS_PATH).concat(String.valueOf(fileName)))) == null) {
            icon = new ImageIcon(new byte[0]);
            Trace.warn(String.valueOf(String.valueOf("Failed to load image: ").concat(String.valueOf(SKINS_PATH))).concat(String.valueOf(fileName)));
        }
        return icon;
    }

    public static String getString(String key) {
        String result;
        if (TEXT_BUNDLE != null) {
            try {
                result = TEXT_BUNDLE.getString(key);
            }
            catch (MissingResourceException mre) {
                result = "";
                Trace.warn(String.valueOf("Failed to read text value: ").concat(String.valueOf(key)));
            }
        } else {
            result = "";
        }
        return result;
    }

    public static Color getColor(String key, Color defaultColor) {
        Color color;
        block3: {
            color = DEFAULT_COLOR;
            if (TEXT_BUNDLE == null) break block3;
            try {
                Integer value = Integer.decode(TEXT_BUNDLE.getString(key));
                color = new Color(value);
            }
            catch (MissingResourceException mre) {
                Trace.warn(String.valueOf("Failed to load color for key: ").concat(String.valueOf(key)));
            }
            catch (NumberFormatException nfe) {
                Trace.warn(String.valueOf("Bad format for color key: ").concat(String.valueOf(key)));
            }
        }
        return color;
    }

    public static Point getPoint(String xKey, String yKey, int defaultX, int defaultY) {
        int x = defaultX;
        int y = defaultY;
        if (TEXT_BUNDLE != null) {
            try {
                x = Integer.parseInt(TEXT_BUNDLE.getString(xKey));
                y = Integer.parseInt(TEXT_BUNDLE.getString(yKey));
            }
            catch (MissingResourceException mre) {
                Trace.warn(String.valueOf(String.valueOf(String.valueOf("Missing values for keys: ").concat(String.valueOf(xKey))).concat(String.valueOf(" "))).concat(String.valueOf(yKey)));
            }
            catch (NumberFormatException nfe) {
                Trace.warn(String.valueOf(String.valueOf(String.valueOf("Bad format for values of keys: ").concat(String.valueOf(xKey))).concat(String.valueOf(" "))).concat(String.valueOf(yKey)));
            }
        }
        return new Point(x, y);
    }

    public static int getInt(String key, int defaultValue) {
        int value = defaultValue;
        if (TEXT_BUNDLE != null) {
            try {
                value = Integer.parseInt(TEXT_BUNDLE.getString(key));
            }
            catch (MissingResourceException mre) {
                Trace.warn(String.valueOf("Missing value for key: ").concat(String.valueOf(key)));
            }
            catch (NumberFormatException nfe) {
                Trace.warn(String.valueOf("Bad format for value of key: ").concat(String.valueOf(key)));
            }
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (TEXT_BUNDLE != null) {
            try {
                value = Boolean.valueOf(TEXT_BUNDLE.getString(key));
            }
            catch (MissingResourceException mre) {
                Trace.warn(String.valueOf("Missing value for key: ").concat(String.valueOf(key)));
            }
            catch (NumberFormatException nfe) {
                Trace.warn(String.valueOf("Bad format for value of key: ").concat(String.valueOf(key)));
            }
        }
        return value;
    }
}

