/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic;

import com.qlogic.QConstants;
import com.qlogic.ui.MainFrame;
import com.qlogic.ui.SplashWindow;
import com.qlogic.ui.tools.TreeControl;
import com.qlogic.util.AlarmManager;
import com.qlogic.util.CommandInterpreter;
import com.qlogic.util.EventManager;
import com.qlogic.util.HostManager;
import com.qlogic.util.SingleInstance;
import com.qlogic.util.SingleInstanceCheck;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Application {
    public static final int SINGLE_INSTANCE_CHECK_FAILURE = 999;
    public static final int DEFAULT_PORT = 32022;
    private static final String COUNT_KEY = "control.count";
    private static final String CONTROL_STRING = "control";
    private static final String NAME_STRING = ".name";
    private static final String METHOD_STRING = ".method";
    private static final String LOG_PATH_KEY = "log.file.path";
    private static final String APP_NAME = "QLogic Management Suite";
    private static String[] m_CommandLine = null;

    private static void init(TreeControl[] controls) {
        String logPath = Utilities.getProperty(LOG_PATH_KEY);
        if (logPath == null) {
            logPath = "";
        } else if (!logPath.endsWith("/")) {
            logPath = String.valueOf(logPath).concat("/");
        }
        if (!EventManager.instance().open(String.valueOf(logPath).concat(String.valueOf(QConstants.EVENT_LOG_FILENAME_PATH)))) {
            JOptionPane.showMessageDialog(MainFrame.instance(), "Unable to open Event log.  Check\nfile or directory permissions.", "Event Log", 0);
        }
        if (!AlarmManager.instance().open(String.valueOf(logPath).concat(String.valueOf(QConstants.ALARM_LOG_FILENAME_PATH)))) {
            JOptionPane.showMessageDialog(MainFrame.instance(), "Unable to open Alarm log.  Check\nfile or directory permissions.", "Alarm Log", 0);
        }
        if (!HostManager.instance().open(String.valueOf(logPath).concat(String.valueOf(QConstants.HOST_LOG_FILENAME_PATH)))) {
            JOptionPane.showMessageDialog(MainFrame.instance(), "Unable to open Host file.  Check\nfile or directory permissions.", "Host Log", 0);
        }
        MainFrame.instance().addControls(controls);
    }

    private static TreeControl[] loadTreeControls() {
        int controlCount;
        Vector<Object> vecControls = new Vector<Object>();
        boolean loadedMethod = false;
        String name = null;
        String meth = null;
        String countStr = Utilities.getProperty(COUNT_KEY);
        try {
            controlCount = Integer.parseInt(countStr);
        }
        catch (NumberFormatException nfe) {
            controlCount = 1;
        }
        for (int count = 0; count < controlCount; ++count) {
            name = Utilities.getProperty(String.valueOf(new StringBuffer(CONTROL_STRING).append(count).append(NAME_STRING)));
            meth = Utilities.getProperty(String.valueOf(new StringBuffer(CONTROL_STRING).append(count).append(METHOD_STRING)));
            if (name == null) break;
            try {
                loadedMethod = false;
                Class<?> c = Class.forName(name);
                Object obj = null;
                if (c != null) {
                    if (meth != null) {
                        try {
                            Method m = c.getMethod(meth, null);
                            obj = m.invoke(c, null);
                            loadedMethod = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!loadedMethod) {
                        obj = c.newInstance();
                    }
                }
                if (obj == null || !(obj instanceof TreeControl)) continue;
                vecControls.addElement(obj);
                continue;
            }
            catch (Exception c) {
                // empty catch block
            }
        }
        Object[] controls = new TreeControl[vecControls.size()];
        vecControls.copyInto(controls);
        if (controls.length < 1) {
            Trace.warn("Failed to load any TreeControls!");
        }
        Trace.traceAt(900, "Application: TreeControls loaded: ".concat(String.valueOf(controls.length)));
        return controls;
    }

    public static String[] getCommandLine() {
        return m_CommandLine;
    }

    public static void main(String[] args) {
        int port;
        Trace.begin(true);
        SplashWindow splashWindow = null;
        String showSplash = Utilities.getProperty("splash.show", "true");
        if (showSplash.equalsIgnoreCase("true")) {
            splashWindow = SplashWindow.instance();
        }
        m_CommandLine = args;
        TreeControl[] controls = Application.loadTreeControls();
        Vector<CommandInterpreter> vecInterpreters = new Vector<CommandInterpreter>(controls.length);
        for (int i = 0; i < controls.length; ++i) {
            CommandInterpreter interpreter = controls[i].getCommandInterpreter();
            if (interpreter == null) continue;
            vecInterpreters.addElement(interpreter);
        }
        Object[] interpreters = new CommandInterpreter[vecInterpreters.size()];
        vecInterpreters.copyInto(interpreters);
        try {
            port = Integer.parseInt(Utilities.getProperty("node.instance.portnumber"));
        }
        catch (NumberFormatException nfe) {
            Trace.warn("Application: Read port property failed, using default: 32022");
            port = 32022;
        }
        if (Utilities.getProperty("node.single.instance.enable") == null || Utilities.getProperty("node.single.instance.enable").equalsIgnoreCase("true")) {
            try {
                SingleInstance service = new SingleInstance(APP_NAME, port, (CommandInterpreter[])interpreters);
                service.setDaemon(true);
                service.start();
            }
            catch (IOException ioe) {
                if (!SingleInstanceCheck.isSingleInstance(APP_NAME, port, args)) {
                    Trace.warn("Application: Instance check failed.  Please use current instance.");
                    System.exit(999);
                }
                Trace.traceAt(900, "Application: is single instance, continuing with load...");
            }
        }
        for (int i = 0; i < controls.length; ++i) {
            controls[i].startup();
        }
        MainFrame mainFrame = MainFrame.instance();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = mainFrame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)mainFrame).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        Application.init(controls);
        if (splashWindow != null) {
            splashWindow.close();
        }
        ((Component)mainFrame).setVisible(true);
        System.runFinalization();
    }
}

