/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.zoning;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningFileException;
import com.qlogic.util.JDocument;
import com.qlogic.util.JElement;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ZoningFile {
    public static final int DEFAULT_VERSION = 1;
    Zones zones;

    public ZoningFile(Zones zones) {
        this.zones = zones;
    }

    public void parse(String string) throws IOException, ZoningFileException {
        org.w3c.dom.Document document;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(string);
        }
        catch (SAXException sAXException) {
            throw new IOException("failed parsing \"" + string + "\"");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("failed parsing \"" + string + "\"");
        }
        catch (IOException iOException) {
            throw new IOException("failed parsing \"" + string + "\"");
        }
        object = document.getDocumentElement();
        if (object == null || !object.getNodeName().equals("ZoningConfiguration")) {
            throw new IOException("failed parsing <ZoningConfiguration> tag");
        }
        this.zones.setLimitsEnforced(false);
        try {
            ZoningFile.parseZoningConfigTag((org.w3c.dom.Element)object, this.zones);
        }
        catch (ZoningFileException zoningFileException) {
            this.zones.setLimitsEnforced(true);
            throw zoningFileException;
        }
        this.zones.setLimitsEnforced(true);
    }

    public static void parseZoningConfigTag(org.w3c.dom.Element element, Zones zones) throws IOException, ZoningFileException {
        zones.clearZones();
        Node node = element.getFirstChild();
        while (node != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            org.w3c.dom.Element element2;
            String string = node.getNodeName();
            if (string.equals("Version")) {
                element2 = (org.w3c.dom.Element)node;
                object5 = DeviceUtilities.getData(element2);
                int n = -1;
                try {
                    n = Integer.parseInt((String)object5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("failed parsing <Version> tag");
                }
                if (n != 1) {
                    throw new IOException("unrecognized version (" + n + ")");
                }
            } else if (string.equals("Zone")) {
                element2 = (org.w3c.dom.Element)node;
                if (!element2.hasAttribute("name")) {
                    throw new IOException("failed parsing <Zone> tag " + element2);
                }
                object5 = zones.createZone(element2.getAttribute("name"));
                if (object5 == null) {
                    throw new ZoningFileException("unable to create zone " + element2.getAttribute("name"));
                }
                if (element2.hasAttribute("type")) {
                    ((Zone)object5).setZoneType(Integer.parseInt(element2.getAttribute("type")));
                }
                Vector<ZoneAlias> vector = new Vector<ZoneAlias>();
                object4 = element2.getFirstChild();
                while (object4 != null) {
                    object3 = object4.getNodeName();
                    if (((String)object3).equals("ZoneMember")) {
                        object2 = (org.w3c.dom.Element)object4;
                        object = DeviceUtilities.getData((org.w3c.dom.Element)object2);
                        ZoneMember zoneMember = object2.hasAttribute("Alias") ? zones.findZoneAlias((String)object) : zones.createZoneMember((String)object);
                        if (zoneMember == null) {
                            throw new ZoningFileException("unable to create zone member " + (String)object);
                        }
                        vector.add((ZoneAlias)zoneMember);
                    }
                    object4 = object4.getNextSibling();
                }
                if (vector.size() > 0) {
                    ((Zone)object5).addMembers(vector);
                }
            } else if (string.equals("ZoneSet")) {
                element2 = (org.w3c.dom.Element)node;
                if (!element2.hasAttribute("name")) {
                    throw new IOException("failed parsing <ZoneSet> tag " + element2);
                }
                object5 = zones.createZoneSet(element2.getAttribute("name"));
                if (object5 == null) {
                    throw new ZoningFileException("unable to create zone set " + element2.getAttribute("name"));
                }
                if (element2.hasAttribute("active") && element2.getAttribute("active").equals(new String("T"))) {
                    zones.setActiveZoneSet((ZoneSet)object5);
                }
                Node node2 = element2.getFirstChild();
                while (node2 != null) {
                    object4 = node2.getNodeName();
                    if (((String)object4).equals("ZoneSetMember")) {
                        object3 = (org.w3c.dom.Element)node2;
                        object2 = DeviceUtilities.getData((org.w3c.dom.Element)object3);
                        object = zones.findZone((String)object2);
                        if (object == null) {
                            throw new ZoningFileException("unable to create zone member " + (String)object2);
                        }
                        ((ZoneSet)object5).addZone((Zone)object);
                    }
                    node2 = node2.getNextSibling();
                }
            } else if (string.equals("ZoneAlias")) {
                element2 = (org.w3c.dom.Element)node;
                if (element2.getAttribute("name") == null) {
                    throw new IOException("failed parsing <ZoneSet> tag");
                }
                object5 = zones.createZoneAlias(element2.getAttribute("name"));
                if (object5 == null) {
                    throw new ZoningFileException("unable to create alias " + element2.getAttribute("name"));
                }
                Vector<Object> vector = new Vector<Object>();
                object4 = element2.getFirstChild();
                while (object4 != null) {
                    object3 = object4.getNodeName();
                    if (((String)object3).equals("ZoneAliasMember")) {
                        object2 = DeviceUtilities.getData((org.w3c.dom.Element)object4);
                        object = zones.createZoneMember((String)object2);
                        if (object == null) {
                            throw new ZoningFileException("unable to create member " + (String)object2);
                        }
                        vector.add(object);
                    }
                    object4 = object4.getNextSibling();
                }
                if (vector.size() > 0) {
                    ((Zone)object5).addMembers(vector);
                }
            }
            node = node.getNextSibling();
        }
    }

    public void save(String string) throws IOException {
        JDocument jDocument = new JDocument();
        jDocument.setRootElement(ZoningFile.getZoningConfigTag(this.zones));
        XMLOutputter xMLOutputter = new XMLOutputter();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        xMLOutputter.output((Document)jDocument, (OutputStream)fileOutputStream);
    }

    public static JElement getZoningConfigTag(Zones zones) {
        JElement jElement;
        Object object;
        Object object2;
        Object object3;
        JElement jElement2 = new JElement("ZoningConfiguration");
        JElement jElement3 = new JElement("Version");
        jElement3.addContent(Integer.toString(1));
        jElement2.addContent(jElement3);
        ZoneAlias zoneAlias = zones.getFirstZoneAlias();
        while (zoneAlias != null) {
            object3 = new JElement("ZoneAlias");
            object3.setAttribute("name", zoneAlias.getName());
            object2 = zoneAlias.getFirstMember();
            while (object2 != null) {
                object = new JElement("ZoneAliasMember");
                object.addContent(object2.getMemberStorageString());
                object3.addContent((Element)object);
                object2 = zoneAlias.getNextMember((ZoneMember)object2);
            }
            jElement2.addContent((Element)object3);
            zoneAlias = zones.getNextZoneAlias(zoneAlias);
        }
        object3 = zones.getFirstZone();
        while (object3 != null) {
            object2 = new JElement("Zone");
            object2.setAttribute("name", ((Zone)object3).getName());
            object2.setAttribute("type", Integer.toString(((Zone)object3).getZoneType()));
            object = ((Zone)object3).getFirstMember();
            while (object != null) {
                jElement = new JElement("ZoneMember");
                if (object instanceof ZoneAlias) {
                    jElement.setAttribute("Alias", object.getMemberStorageString());
                }
                jElement.addContent(object.getMemberStorageString());
                object2.addContent((Element)jElement);
                object = ((Zone)object3).getNextMember((ZoneMember)object);
            }
            jElement2.addContent((Element)object2);
            object3 = zones.getNextZone((Zone)object3);
        }
        object2 = zones.getFirstZoneSet();
        while (object2 != null) {
            object = new JElement("ZoneSet");
            object.setAttribute("name", ((ZoneSet)object2).getName());
            object.setAttribute("active", ((ZoneSet)object2).getActive() ? "T" : "F");
            object3 = ((ZoneSet)object2).getFirstZone();
            while (object3 != null) {
                jElement = new JElement("ZoneSetMember");
                jElement.addContent(((Zone)object3).getName());
                object.addContent((Element)jElement);
                object3 = ((ZoneSet)object2).getNextZone((Zone)object3);
            }
            jElement2.addContent((Element)object);
            object2 = zones.getNextZoneSet((ZoneSet)object2);
        }
        return jElement2;
    }
}

