/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.zoning;

import com.qlogic.device.fcfabric.DeviceUtilities;

public class ZoningConfig {
    public static final String[] mergeModeLongStrings = new String[]{DeviceUtilities.getResource("ZoningConfig.sw2"), DeviceUtilities.getResource("ZoningConfig.non-sw2")};
    public static final String[] defaultVisibilityStrings = new String[]{DeviceUtilities.getResource("ZoningConfig.all"), DeviceUtilities.getResource("ZoningConfig.none")};
    public static final int MERGE_MODE_SW2 = 0;
    public static final int MERGE_MODE_BROCADE = 1;
    public static final int MERGE_MODE_UNKNOWN = -1;
    public static final int VISIBILITY_DEFAULT_ALL = 0;
    public static final int VISIBILITY_DEFAULT_NONE = 1;
    public static final int VISIBILITY_DEFAULT_UNKNOWN = -1;
    private boolean autoSave = false;
    private int mergeMode = -1;
    private int defaultVisibility = -1;
    private boolean nonSw2Legacy = false;

    public ZoningConfig() {
    }

    public ZoningConfig(ZoningConfig zoningConfig) {
        this.autoSave = zoningConfig.getAutoSave();
        this.mergeMode = zoningConfig.getMergeMode();
        this.defaultVisibility = zoningConfig.getDefaultVisibility();
        this.nonSw2Legacy = zoningConfig.getNonSw2Legacy();
    }

    public boolean getNonSw2Legacy() {
        return this.nonSw2Legacy;
    }

    public void setNonSw2Legacy(boolean bl) {
        this.nonSw2Legacy = bl;
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public static String getAutoSaveString(boolean bl) {
        if (bl) {
            return DeviceUtilities.getResource("ZoningConfig.true");
        }
        return DeviceUtilities.getResource("ZoningConfig.false");
    }

    public int getMergeMode() {
        return this.mergeMode;
    }

    public int getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public void setAutoSave(boolean bl) {
        this.autoSave = bl;
    }

    public void setMergeMode(int n) {
        this.mergeMode = n;
    }

    public String getMergeModeLongString() {
        if (this.mergeMode < 0) {
            return "Unknown";
        }
        return mergeModeLongStrings[this.mergeMode];
    }

    public void setDefaultVisibility(int n) {
        this.defaultVisibility = n;
    }

    public String getDefaultVisibilityString() {
        if (this.defaultVisibility < 0) {
            return "Unknown";
        }
        return defaultVisibilityStrings[this.defaultVisibility];
    }
}

