/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.util.messages.TCPAgent;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMessageParallelQueue;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNotifySml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import com.qlogic.device.fcfabric.util.messages.UtilResponseThread;
import java.util.HashMap;
import java.util.Set;

public class UtilThread
extends Thread {
    private static int count = 0;
    private static int instanceNumber = 0;
    private TCPAgent tcpAgent;
    private UtilMessageParallelQueue utilQueue;
    UtilResponseThread responseThread;
    private UtilAgent agent;
    volatile boolean shouldRun = true;
    long sendAfterTime = System.currentTimeMillis();

    public UtilThread(UtilAgent utilAgent, TCPAgent tCPAgent, UtilMessageParallelQueue utilMessageParallelQueue) {
        this.setName("UtilThread-" + instanceNumber++);
        this.agent = utilAgent;
        this.tcpAgent = tCPAgent;
        this.utilQueue = utilMessageParallelQueue;
        this.responseThread = new UtilResponseThread(this.agent);
        this.responseThread.start();
    }

    public void die() {
        this.shouldRun = false;
        this.responseThread.die();
    }

    public void setEntryKey(Object object) {
        this.utilQueue.setEntryKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        UtilMsgVersionReq utilMsgVersionReq = new UtilMsgVersionReq(null, null);
        HashMap hashMap = new HashMap();
        this.agent.connect();
        while (this.shouldRun) {
            try {
                UtilMessageParallelQueue utilMessageParallelQueue = this.utilQueue;
                synchronized (utilMessageParallelQueue) {
                    if (this.utilQueue.getNumberInQueue() == 0) {
                        try {
                            this.utilQueue.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if (!this.shouldRun) {
                            break;
                        }
                    }
                }
                if (!this.agent.isConnected()) {
                    this.agent.connect();
                }
                if (this.utilQueue.getNumberInQueue() == 0) {
                    while (true) {
                        UtilMsgSml utilMsgSml = new UtilMsgSml(null, null);
                        utilMsgSml.setNotifyCommand();
                        if (this.tcpAgent.receiveMessage(utilMsgSml, 1) != 0 || utilMsgSml.getRecvCommandCode() != 1026) break;
                        this.handleNotifyPacket(utilMsgSml);
                    }
                }
                hashMap = this.utilQueue.dequeueMessages(hashMap);
                while (!hashMap.isEmpty()) {
                    boolean bl = true;
                    int n = 0;
                    while (bl) {
                        int n2 = hashMap.size();
                        this.sendMessagesThatNeedToBeSent(hashMap);
                        ++n2;
                        int n3 = 1;
                        if (hashMap.size() > 0) {
                            n3 = this.tcpAgent.receiveMessage(utilMsgVersionReq, 100);
                        }
                        switch (n3) {
                            case 0: {
                                this.agent.setComAgentStatus(1);
                                n = 0;
                                UtilMessage utilMessage = this.findMessageInSendListAndProcess(hashMap, utilMsgVersionReq);
                                break;
                            }
                            case 2: {
                                if (++n <= 10) break;
                                bl = false;
                                break;
                            }
                            case 3: {
                                this.agent.setComAgentStatus(2);
                                n = 0;
                                bl = false;
                                break;
                            }
                            case 1: {
                                n = 0;
                                bl = false;
                            }
                        }
                        hashMap = this.utilQueue.dequeueMessages(hashMap);
                        if (hashMap.size() != 0) continue;
                        bl = false;
                    }
                    if (n <= 10) continue;
                    this.flushList(hashMap);
                    this.flushTheQueue();
                }
            }
            catch (Throwable throwable) {
                String string = FabricUtilities.stackTraceToString(throwable.getStackTrace());
                FabricUtilities.logMessage(this.toString() + " :" + throwable.toString() + "\n" + string);
            }
        }
    }

    private UtilMessage findMessageInSendListAndProcess(HashMap hashMap, UtilMessage utilMessage) {
        long l = System.currentTimeMillis();
        if (utilMessage.getRecvCommandCode() == 1026) {
            this.handleNotifyPacket(utilMessage);
            return null;
        }
        int n = utilMessage.getRecvSeqNumber();
        Set set = hashMap.keySet();
        Object[] objectArray = set.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            UtilMessage utilMessage2 = (UtilMessage)hashMap.get(object);
            if (utilMessage2.getSequenceNumber() == n) {
                utilMessage2.setReceivePacket(utilMessage.getReceivePacket());
                utilMessage2.setStatus(103);
                try {
                    utilMessage2.unpack();
                }
                catch (Exception exception) {
                    FabricUtilities.logMessage("Exception unpacking msg e=" + exception + " msg=" + utilMessage2.getDataTransfered());
                    utilMessage2.setStatus(105);
                }
                this.agent.incMessagesReturned(l - utilMessage2.getTimeSent());
                if (utilMessage2.getSendAgain() && utilMessage2.getStatus() == 103) {
                    utilMessage2.setTimeSent(-1L);
                    this.sendMessage(hashMap, utilMessage2);
                    return null;
                }
                hashMap.remove(object);
                this.responseThread.callResponse(utilMessage2);
                return utilMessage2;
            }
            ++n2;
        }
        return null;
    }

    private boolean sendMessagesThatNeedToBeSent(HashMap hashMap) {
        long l = System.currentTimeMillis();
        if (this.sendAfterTime > l) {
            return false;
        }
        Set set = hashMap.keySet();
        Object[] objectArray = set.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            UtilMessage utilMessage = (UtilMessage)hashMap.get(object);
            if (utilMessage != null) {
                if (utilMessage.getTimeSent() < 0L) {
                    if (this.sendMessage(hashMap, utilMessage) == 5) {
                        this.agent.setComAgentStatus(2);
                        this.flushList(hashMap);
                        this.flushTheQueue();
                    }
                } else if (utilMessage.getDestination().isTimedOut(utilMessage)) {
                    hashMap.remove(object);
                    this.flushMessage(utilMessage);
                    this.agent.incMessagesTimedOut();
                }
            }
            ++n;
        }
        return true;
    }

    private int sendMessage(HashMap hashMap, UtilMessage utilMessage) {
        int n = this.tcpAgent.sendMessage(utilMessage);
        if (n != 4) {
            this.flushMessage(utilMessage);
            this.agent.incMessagesDiscards();
            hashMap.remove(utilMessage.getKey());
        } else {
            if (utilMessage.getWaitAfterSend() > 0) {
                this.sendAfterTime = System.currentTimeMillis() + (long)utilMessage.getWaitAfterSend();
            }
            this.agent.incMessagesSent();
            utilMessage.setTimeSent(System.currentTimeMillis());
        }
        if (!utilMessage.getExpectReply()) {
            hashMap.remove(utilMessage);
        }
        return n;
    }

    void flushTheQueue() {
        HashMap hashMap = new HashMap();
        while (this.utilQueue.getNumberInQueue() > 0) {
            hashMap = this.utilQueue.dequeueMessages(hashMap);
            this.flushList(hashMap);
        }
    }

    private void flushList(HashMap hashMap) {
        Set set = hashMap.keySet();
        Object[] objectArray = set.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.flushMessage((UtilMessage)hashMap.get(object));
            this.agent.incMessagesDiscards();
            hashMap.remove(object);
            ++n;
        }
    }

    private void flushMessage(UtilMessage utilMessage) {
        if (utilMessage.getStatus() < 103) {
            utilMessage.setStatus(107);
        }
        this.responseThread.callResponse(utilMessage);
    }

    private void handleNotifyPacket(UtilMessage utilMessage) {
        this.agent.incNotifications();
        UtilMsgNotifySml utilMsgNotifySml = new UtilMsgNotifySml(null, null);
        utilMsgNotifySml.setNotifyCommand();
        utilMsgNotifySml.setReceivePacket(utilMessage.getReceivePacket());
        try {
            if (utilMsgNotifySml.unpack()) {
                this.responseThread.callResponse(utilMsgNotifySml);
            }
        }
        catch (Exception exception) {
            FabricUtilities.logMessage("Exception unpacking notify e=" + exception + " notify=" + utilMsgNotifySml.getDataTransfered());
        }
    }

    private void ackNotify(UtilMsgNotifySml utilMsgNotifySml) {
        String string = utilMsgNotifySml.getResponse(0).getResponse();
        utilMsgNotifySml.setTag(string);
        this.tcpAgent.sendMessage(utilMsgNotifySml);
        utilMsgNotifySml.setNotifyCommand();
        utilMsgNotifySml.setStatus(103);
    }

    public Thread getRepsonseThread() {
        return this.responseThread;
    }
}

