/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMessageQueue;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNotifySml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class UtilResponseThread
extends Thread {
    private static int instanceNumber = 0;
    UtilMessageQueue responseQueue = new UtilMessageQueue();
    UtilAgent agent;
    volatile boolean shouldRun = true;

    public UtilResponseThread(UtilAgent utilAgent) {
        this.setName("UtilResponseThread-" + instanceNumber++);
        this.agent = utilAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        this.shouldRun = false;
        UtilResponseThread utilResponseThread = this;
        synchronized (utilResponseThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.shouldRun) {
            Object object;
            try {
                UtilMessage utilMessage = this.responseQueue.dequeueMessage();
                if (utilMessage != null) {
                    object = utilMessage.getListener();
                    if (object != null) {
                        object.receiveMessage(utilMessage);
                        continue;
                    }
                    if (!(utilMessage instanceof UtilMsgNotifySml)) continue;
                    this.agent.fireComAgentEvent(2, utilMessage);
                    continue;
                }
                object = this;
                synchronized (object) {
                    if (this.responseQueue.getNumberInQueue() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            System.out.println("Repsonse thread interrupted.");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                object = FabricUtilities.stackTraceToString(throwable.getStackTrace());
                FabricUtilities.logMessage(this.toString() + " :" + throwable.toString() + "\n" + (String)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callResponse(UtilMessage utilMessage) {
        Object object;
        boolean bl = false;
        if (utilMessage.getStatus() == 104) {
            switch (utilMessage.getErrorCode()) {
                case 0: 
                case 5: 
                case 12: 
                case 14: {
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (utilMessage.getStatus() == 105) {
            if (utilMessage instanceof UtilMsgSml) {
                object = (UtilMsgSml)utilMessage;
                int n = 0;
                while (n < ((UtilMsgSml)object).getNumberOfResponses()) {
                    if (((UtilMsgSml)object).getResponse(n).getErrorCode() != 24 && ((UtilMsgSml)object).getResponse(n).getErrorCode() != 0) {
                        bl = true;
                    }
                    ++n;
                }
            } else {
                bl = true;
            }
        }
        if (utilMessage instanceof UtilMsgSml && ((UtilMsgSml)(object = (UtilMsgSml)utilMessage)).getIsSetCommand() && !((UtilMsgSml)object).AllResponsesOk()) {
            bl = true;
        }
        if (bl && utilMessage.getStatus() != 107) {
            FabricUtilities.logMessage(utilMessage.getDataTransfered());
        }
        object = this;
        synchronized (object) {
            this.responseQueue.queueMessage(utilMessage, false);
            this.notify();
        }
    }
}

