/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgTrapConfig
extends UtilMessage {
    public static final int NUMBER_OF_TRAPS = 32;
    private static final int TC_COMMAND = 50;
    private static final int TC_SET_COMMAND = 4;
    private static final int TC_REQ_COMMAND = 1;
    private static final int TC_SAVE_COMMAND = 5;
    private static final int TC_EXT_COMMAND_OFFSET = 0;
    private static final int TC_NUMBER_OF_TRAPS_OFFSET = 4;
    private static final int TC_TRAPS_ENABLED_OFFSET = 8;
    private static final int TC_UTIL_VERSION_NUMBER_OFFSET = 9;
    private static final int TC_SAMPLE_INTERVAL_OFFSET = 12;
    private static final int TC_FCADDRESS_OFFSET = 16;
    private static final int TC_RISING_THRESHOLD_OFFSET = 20;
    private static final int TC_FALLING_THRESHOLD_OFFSET = 148;
    private static final int TC_ENABLE_ARRAY_OFFSET = 276;
    private static final int TC_REQ_DATA_LENGTH = 4;
    private static final int TC_REQ_RESP_DATA_LENGTH = 308;
    private static final int TC_SAVE_DATA_LENGTH = 4;
    private static final int TC_SET_DATA_LENGTH = 308;
    int numberOfTraps;
    boolean trapsEnabled;
    int sampleInterval;
    int fcAddress;
    int[] risingThresholds;
    int[] fallingThresholds;
    byte[] enableArray;
    int extCommand;

    public UtilMsgTrapConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl, int n, int n2, int[] nArray, int[] nArray2, byte[] byArray) {
        super(utilDestination, 50, utilEventListener, 308);
        this.extCommand = 4;
        this.numberOfTraps = nArray.length;
        this.trapsEnabled = bl;
        this.sampleInterval = n;
        this.fcAddress = n2;
        this.risingThresholds = nArray;
        this.fallingThresholds = nArray2;
        this.enableArray = byArray;
    }

    public UtilMsgTrapConfig(UtilDestination utilDestination, UtilEventListener utilEventListener, boolean bl) {
        super(utilDestination, 50, utilEventListener, bl ? 4 : 4);
        this.extCommand = bl ? 1 : 5;
    }

    public boolean setSetCommand() {
        this.extCommand = 4;
        this.setDataLength(308);
        return true;
    }

    public boolean setGetCommand() {
        this.extCommand = 1;
        this.setDataLength(4);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.extCommand == 4;
    }

    public boolean getIsSaveCommand() {
        return this.extCommand == 5;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeInt(this.extCommand, this.dataBuffer, n + 0);
        if (this.extCommand == 4) {
            this.dataBuffer[(n -= 4) + 8] = this.trapsEnabled ? (byte)1 : 0;
            this.dataBuffer[n + 9] = 1;
            UtilMessage.encodeInt(this.sampleInterval, this.dataBuffer, n + 12);
            UtilMessage.encodeInt(this.fcAddress, this.dataBuffer, n + 16);
            UtilMessage.encodeIntArray(this.risingThresholds, this.dataBuffer, n + 20);
            UtilMessage.encodeIntArray(this.fallingThresholds, this.dataBuffer, n + 148);
            UtilMessage.byteCopy(this.dataBuffer, n + 276, this.enableArray, 0, 32);
        }
        this.encodeAndCalcCheckSum();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        if (this.extCommand != 1) return true;
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (byArray.length < 308) {
                this.setStatus(105);
                return false;
            }
            if (UtilMessage.decodeInt(byArray, 0) != this.extCommand) {
                this.setStatus(105);
                return false;
            }
        } else {
            this.setStatus(105);
            return false;
        }
        this.numberOfTraps = byArray[4];
        this.trapsEnabled = byArray[8] != 0;
        this.sampleInterval = UtilMessage.decodeInt(byArray, 12);
        this.fcAddress = UtilMessage.decodeInt(byArray, 16);
        this.risingThresholds = new int[this.numberOfTraps];
        UtilMessage.decodeIntArray(this.risingThresholds, byArray, 20);
        this.fallingThresholds = new int[this.numberOfTraps];
        UtilMessage.decodeIntArray(this.fallingThresholds, byArray, 148);
        this.enableArray = new byte[this.numberOfTraps];
        UtilMessage.byteCopy(this.enableArray, 0, byArray, 276, 32);
        return true;
    }

    public int getNumberOfTraps() {
        return this.numberOfTraps;
    }

    public boolean getTrapsEnabled() {
        return this.trapsEnabled;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public int[] getRisingThresholds() {
        return this.risingThresholds;
    }

    public int[] getFallingThresholds() {
        return this.fallingThresholds;
    }

    public byte[] getEnableArray() {
        return this.enableArray;
    }

    public String toString() {
        return super.toString() + new String("Trace config\n");
    }
}

