/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;

public class UtilMsgTraceControl
extends UtilMessage {
    private static final int TR_SET_COMMAND = 10;
    private static final int TR_REQ_COMMAND = 11;
    private static final int TR_FLAG_OFFSET = 0;
    private static final int TR_REQ_DATA_LENGTH = 0;
    private static final int TR_REQ_RESP_DATA_LENGTH = 4;
    private static final int TR_SET_DATA_LENGTH = 4;
    int flag;

    public UtilMsgTraceControl(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        super(utilDestination, 10, utilEventListener, 4);
        this.flag = n;
    }

    public UtilMsgTraceControl(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 11, utilEventListener, 0);
    }

    public boolean setSetCommand() {
        this.command = 10;
        this.setDataLength(4);
        return true;
    }

    public boolean setGetCommand() {
        this.command = 11;
        this.setDataLength(0);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.command == 10;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        if (this.command == 10) {
            int n = this.getSendPayloadDataOffset();
            UtilMessage.encodeInt(this.flag, this.dataBuffer, n + 0);
            this.encodeAndCalcCheckSum();
        }
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        if (this.command == 11) {
            byte[] byArray = this.getResponsePayloadData();
            if (byArray != null) {
                if (byArray.length < 4) {
                    this.setStatus(105);
                    return false;
                }
                this.flag = UtilMessage.decodeInt(byArray, 0);
            } else {
                this.setStatus(105);
                return false;
            }
        }
        return true;
    }

    public int getFlag() {
        return this.flag;
    }

    public String toString() {
        return super.toString() + new String("Trace control\n");
    }
}

