/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgSwitchConfigurationParameters
extends UtilMsgConfig {
    byte numberOfPorts;
    byte lockChassisNumber;
    byte chassisNumber;
    byte stageType;
    byte fabricId;
    byte adminChassisMode;
    int mfsTimeout;
    int rtTimeoutValue;
    int raTimeoutValue;
    int edTimeoutValue;
    byte[] portAdminState;
    byte[] alDisabled;
    byte[] mfsMode;
    private static final int SC_NUMBER_OF_PORTS_OFFSET = 0;
    private static final int SC_LOCK_CHASSIS_NUMBER_OFFSET = 1;
    private static final int SC_CHASSIS_NUMBER_OFFSET = 2;
    private static final int SC_STAGE_TYPE_OFFSET = 3;
    private static final int SC_FABRIC_ID_OFFSET = 4;
    private static final int SC_ADMIN_CHASSIS_MODE_OFFSET = 5;
    private static final int SC_MFS_TIMEOUT_OFFSET = 6;
    private static final int SC_RT_TIMEOUT_VALUE_OFFSET = 8;
    private static final int SC_RA_TIMEOUT_VALUE_OFFSET = 12;
    private static final int SC_ED_TIMEOUT_VALUE_OFFSET = 16;
    private static final int SC_PORT_STATES_OFFSET = 20;
    private static final int SC_DATA_LENGTH = 0;
    public static final int SC_EXT_COMMAND_GET_ACTIVE = 1;
    public static final int SC_EXT_COMMAND_GET_PENDING = 2;
    public static final int SC_EXT_COMMAND_GET_SAVED = 3;
    public static final int SC_EXT_COMMAND_SET_ACTIVE = 4;
    public static final int SC_EXT_COMMAND_SET_PENDING = 5;
    public static final int SC_EXT_COMMAND_SAVE_ACTIVE = 6;
    public static final int SC_EXT_COMMAND_SAVE_PENDING = 7;
    public static final int SC_EXT_COMMAND_RECONFIG = 9;

    public UtilMsgSwitchConfigurationParameters() {
        super(null, null, 0, -1);
        this.setNumberOfPorts((byte)0);
    }

    public UtilMsgSwitchConfigurationParameters(byte by) {
        super(null, null, 0, -1);
        this.setNumberOfPorts(by);
    }

    public UtilMsgSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 0, -1);
    }

    public UtilMsgSwitchConfigurationParameters(UtilDestination utilDestination, UtilEventListener utilEventListener, byte by) {
        super(utilDestination, utilEventListener, 0, -1);
        this.setNumberOfPorts(by);
    }

    public boolean setActive() {
        switch (this.extCommand) {
            default: {
                this.extCommand = 1;
                return true;
            }
            case 4: 
            case 5: 
        }
        this.extCommand = 4;
        return true;
    }

    public boolean setPending() {
        switch (this.extCommand) {
            default: {
                this.extCommand = 2;
                return true;
            }
            case 4: 
            case 5: 
        }
        this.extCommand = 5;
        return true;
    }

    public void setSaved() {
        this.extCommand = 3;
    }

    public void setSavePending() {
        this.extCommand = 7;
    }

    public void setSaveActive() {
        this.extCommand = 6;
    }

    public void setReconfig() {
        this.extCommand = 9;
    }

    public boolean setSetCommand() {
        switch (this.extCommand) {
            case 3: {
                return false;
            }
            case 1: 
            case 4: {
                this.extCommand = 4;
                return true;
            }
            case 2: 
            case 5: {
                this.extCommand = 5;
                return true;
            }
            case 7: {
                return true;
            }
            case 6: {
                return true;
            }
            case 9: {
                return true;
            }
        }
        this.extCommand = 4;
        return true;
    }

    public boolean setGetCommand() {
        switch (this.extCommand) {
            case 3: {
                return true;
            }
            case 1: 
            case 4: {
                this.extCommand = 1;
                return true;
            }
            case 2: 
            case 5: {
                this.extCommand = 2;
                return true;
            }
        }
        this.extCommand = 1;
        return true;
    }

    public boolean getIsSetCommand() {
        switch (this.extCommand) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean pack() {
        boolean bl = false;
        if (this.extCommand == 0) {
            return false;
        }
        if (this.extCommand == 6 || this.extCommand == 7 || this.extCommand == 9) {
            this.setDataLength(0);
            bl = true;
        } else if (this.getIsSetCommand()) {
            this.setDataLength(20 + 3 * this.numberOfPorts);
        } else {
            this.setDataLength(0);
        }
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        if (this.getIsSetCommand() && !bl) {
            this.dataBuffer[n + 0] = this.numberOfPorts;
            this.dataBuffer[n + 1] = this.lockChassisNumber;
            this.dataBuffer[n + 2] = this.chassisNumber;
            this.dataBuffer[n + 3] = this.stageType;
            this.dataBuffer[n + 4] = this.fabricId;
            this.dataBuffer[n + 5] = this.adminChassisMode;
            UtilMessage.encodeInt(this.rtTimeoutValue, this.dataBuffer, n + 8);
            UtilMessage.encodeInt(this.raTimeoutValue, this.dataBuffer, n + 12);
            UtilMessage.encodeInt(this.edTimeoutValue, this.dataBuffer, n + 16);
            int n2 = 0;
            while (n2 < this.numberOfPorts) {
                this.dataBuffer[n + 20 + n2] = this.portAdminState[n2];
                this.dataBuffer[n + 20 + this.numberOfPorts + n2] = this.alDisabled[n2];
                this.dataBuffer[n + 20 + this.numberOfPorts * 2 + n2] = this.mfsMode[n2];
                ++n2;
            }
        }
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null) {
            if (!this.getIsSetCommand()) {
                if (byArray.length > 20) {
                    if (byArray[0] <= 0) {
                        this.setStatus(105);
                        return false;
                    }
                    this.setNumberOfPorts(byArray[0]);
                    this.lockChassisNumber = byArray[1];
                    this.chassisNumber = byArray[2];
                    this.stageType = byArray[3];
                    this.fabricId = byArray[4];
                    this.adminChassisMode = byArray[5];
                    this.rtTimeoutValue = UtilMessage.decodeInt(byArray, 8);
                    this.raTimeoutValue = UtilMessage.decodeInt(byArray, 12);
                    this.edTimeoutValue = UtilMessage.decodeInt(byArray, 16);
                    this.mfsTimeout = UtilMessage.decodeShort(byArray, 6);
                    if (byArray.length != 20 + 3 * this.numberOfPorts) {
                        this.setStatus(105);
                        return false;
                    }
                    int n = 0;
                    while (n < this.numberOfPorts) {
                        this.portAdminState[n] = byArray[20 + n];
                        this.alDisabled[n] = byArray[20 + this.numberOfPorts + n];
                        this.mfsMode[n] = byArray[20 + this.numberOfPorts * 2 + n];
                        ++n;
                    }
                    return true;
                }
            } else if (byArray.length == 4) {
                int n = UtilMessage.decodeInt(byArray, 0);
                if (this.extCommand != n) {
                    this.setStatus(105);
                    return false;
                }
                return true;
            }
        }
        if (!this.getIsSetCommand()) {
            this.setStatus(105);
            return false;
        }
        return true;
    }

    public byte getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public void setNumberOfPorts(byte by) {
        this.numberOfPorts = by;
        this.portAdminState = new byte[this.numberOfPorts];
        this.alDisabled = new byte[this.numberOfPorts];
        this.mfsMode = new byte[this.numberOfPorts];
    }

    public byte getLockChassisNumber() {
        return this.lockChassisNumber;
    }

    public byte getChassisNumber() {
        return this.chassisNumber;
    }

    public byte getStageType() {
        return this.stageType;
    }

    public byte getFabricId() {
        return this.fabricId;
    }

    public byte getAdminChassisMode() {
        return this.adminChassisMode;
    }

    public int getMfsTimeout() {
        return this.mfsTimeout;
    }

    public int getRtTimeoutValue() {
        return this.rtTimeoutValue;
    }

    public int getRaTimeoutValue() {
        return this.raTimeoutValue;
    }

    public int getEdTimeoutValue() {
        return this.edTimeoutValue;
    }

    public byte getPortAdminState(int n) {
        if (n >= 0 && n < this.portAdminState.length) {
            return this.portAdminState[n];
        }
        return -1;
    }

    public byte getAlDisabled(int n) {
        if (n >= 0 && n < this.alDisabled.length) {
            return this.alDisabled[n];
        }
        return -1;
    }

    public byte getMfsMode(int n) {
        if (n >= 0 && n < this.mfsMode.length) {
            return this.mfsMode[n];
        }
        return -1;
    }

    public void setLockChassisNumber(byte by) {
        this.lockChassisNumber = by;
    }

    public void setChassisNumber(byte by) {
        this.chassisNumber = by;
    }

    public void setStageType(byte by) {
        this.stageType = by;
    }

    public void setFabricId(byte by) {
        this.fabricId = by;
    }

    public void setAdminChassisMode(byte by) {
        this.adminChassisMode = by;
    }

    public void setMfsTimeout(int n) {
        this.mfsTimeout = n;
    }

    public void setRtTimeoutValue(int n) {
        this.rtTimeoutValue = n;
    }

    public void setRaTimeoutValue(int n) {
        this.raTimeoutValue = n;
    }

    public void setEdTimeoutValue(int n) {
        this.edTimeoutValue = n;
    }

    public void setPortAdminState(int n, byte by) {
        if (n >= 0 && n < this.portAdminState.length) {
            this.portAdminState[n] = by;
        }
    }

    public void setAlDisabled(int n, byte by) {
        if (n >= 0 && n < this.alDisabled.length) {
            this.alDisabled[n] = by;
        }
    }

    public void setMfsMode(int n, byte by) {
        if (n >= 0 && n < this.mfsMode.length) {
            this.mfsMode[n] = by;
        }
    }

    private String extStr() {
        switch (this.extCommand) {
            case 3: {
                return new String("Get Saved");
            }
            case 4: {
                return new String("Set Active");
            }
            case 1: {
                return new String("Get Active");
            }
            case 2: {
                return new String("Get Pending");
            }
            case 5: {
                return new String("Set Pending");
            }
            case 6: {
                return new String("Save Active");
            }
            case 7: {
                return new String("Save Pending");
            }
            case 9: {
                return new String("Reconfig");
            }
        }
        return new String("Invalid ext command");
    }

    public String toString() {
        String string = super.toString() + new String("SWITCH CONFIGURATION PARAMETERS " + this.extStr() + "\n" + "numberOfPorts = " + this.numberOfPorts + "\n" + "lockChassisNumber = " + this.lockChassisNumber + "\n" + "chassisNumber = " + this.chassisNumber + "\n" + "stageType = " + this.stageType + "\n" + "fabricId = " + this.fabricId + "\n" + "adminChassisMode = " + this.adminChassisMode + "\n" + "mfsTimeout = " + this.mfsTimeout + "\n" + "rtTimeoutValue = " + this.rtTimeoutValue + "\n" + "raTimeoutValue = " + this.raTimeoutValue + "\n" + "edTimeoutValue = " + this.edTimeoutValue + "\n");
        int n = 0;
        while (n < this.numberOfPorts) {
            string = string + new String("Port " + n + "\n" + "portAdminState = " + this.portAdminState[n] + "\n" + "alDisabled = " + this.alDisabled[n] + "\n" + "mfsMode = " + this.mfsMode[n] + "\n");
            ++n;
        }
        return string;
    }
}

