/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgOLT;

public class UtilMsgOLTStart
extends UtilMsgOLT {
    private static final int PORT_NUM_OFFSET = 0;
    private static final int SPECIAL_LEN_OFFSET = 1;
    private static final int SPECIAL_PATTERN_OFFSET = 2;
    private static final int STOP_ON_ERROR_OFFSET = 3;
    private static final int LEN_OFFSET = 4;
    private static final int PATTERN_OFFSET = 8;
    private static final int TEST_COUNT_OFFSET = 12;
    private static final int DATA_OFFSET = 4;
    private static final int DATA_LENGTH = 16;
    private static final int EXT_COMMAND = 13;
    private int portNumber;
    private int specialLength = 1;
    private int specialPattern = 1;
    private int stopOnError = 1;
    private int length = 2048;
    private int pattern = 255;
    private int testCount = 100;

    public UtilMsgOLTStart(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 16, 13);
    }

    public UtilMsgOLTStart() {
        super(null, null, 16, 13);
    }

    public boolean setSetCommand() {
        return true;
    }

    public boolean setGetCommand() {
        return false;
    }

    public boolean getIsSetCommand() {
        return true;
    }

    public boolean pack() {
        if (this.extCommand == 0) {
            this.extCommand = 13;
        }
        this.setDataLength(16);
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = (byte)this.portNumber;
        this.dataBuffer[n + 1] = (byte)this.specialLength;
        this.dataBuffer[n + 2] = (byte)this.specialPattern;
        this.dataBuffer[n + 3] = (byte)this.stopOnError;
        UtilMessage.encodeInt(this.length, this.dataBuffer, n + 4);
        UtilMessage.encodeInt(this.pattern, this.dataBuffer, n + 8);
        UtilMessage.encodeInt(this.testCount, this.dataBuffer, n + 12);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        return super.unpack();
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    public void setStopOnError(boolean bl) {
        this.stopOnError = bl ? 1 : 0;
    }

    public boolean getStopOnError() {
        return this.stopOnError == 1;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public void setTestCount(int n) {
        this.testCount = n;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public void setPattern(int n) {
        this.pattern = n;
    }

    public int getPattern() {
        return this.pattern;
    }

    public String toString() {
        String string = super.toString() + new String("OLT START ARB LOOP TEST: portNumber=" + Integer.toString(this.portNumber));
        return string;
    }
}

