/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class UtilMsgNotifySml
extends UtilMsgSml {
    public static final String[] notifySmlCommands = new String[]{"Notify.Fabric.OperChange", "Notify.Topology.OperChange", "Notify.Zoning.Change", "Notify.NameServer.OperChange", "Notify.Eport.OperChange", "Notify.Switch.ConfigChange", "Notify.Switch.OperChange", "Notify.Chassis.OperChange", "Notify.Blade.OperChange", "Notify.UserPort.OperChange", "Notify.UserPort.ConfigChange", "Notify.System.ConfigChange", "Notify.Snmp.ConfigChange", "Notify.Zoning.MergeAlarm", "Notify.Eport.ConvergeAlarm", "Notify.Switch.AccessAlarm", "Notify.Switch.ResetAlarm", "Notify.Switch.AdminAlarm", "Notify.Chassis.PsBadAlarm", "Notify.Chassis.PsOkAlarm", "Notify.Chassis.FanBadAlarm", "Notify.Chassis.FanOkAlarm", "Notify.Blade.OverheatAlarm", "Notify.Blade.OverwarmAlarm", "Notify.Blade.TempOkAlarm", "Notify.UserPort.LoginAlarm", "Notify.UserPort.LogoutAlarm", "Notify.UserPort.CRCAlarm", "Notify.UserPort.LOSAlarm", "Notify.UserPort.DecodeAlarm", "Notify.UserPort.FramingAlarm", "Notify.UserPort.SmoothingAlarm", "Notify.UserPort.LIPFailAlarm", "Notify.UserPort.LIPAttemptAlarm", "Notify.UserPort.NotMasterAlarm", "Notify.UserPort.RespTimeoutAlarm", "Notify.UserPort.LIFAlarm", "Notify.UserPort.OutParityAlarm", "Notify.Switch.GenericAlarm", "Notify.Switch.StateChange", "Notify.UserPort.StateChange", "Notify.UserPort.LoopbackDone", "Notify.Zoning.ConfigChange", "Notify.Zoning.MergedAuto", "Notify.Zoning.MergedManual", "Notify.Switch.DownloadComplete", "Notify.System.IPAddressChange", "Notify.Blade.TestDone", "Notify.Blade.StateChange", "Notify.UserPort.BytePerf", "Notify.UserPort.TxBytePerf", "Notify.UserPort.RxBytePerf", "Notify.UserPort.FramePerf", "Notify.UserPort.TxFramePerf", "Notify.UserPort.RxFramePerf", "Notify.UserPort.Errors", "Notify.UserPort.CounterClear", "Notify.Threshold.ConfigChange", "Notify.Switch.UnpackComplete", "Notify.Switch.Ping", "Notify.Switch.AccountChange", "Notify.NameServerAll.OperChange"};
    public static final int SML_NOTIFY_TAG_FABRIC_CHANGE = 0;
    public static final int SML_NOTIFY_TAG_TOPOLOGY_CHANGE = 1;
    public static final int SML_NOTIFY_TAG_ZONING_CHANGE = 2;
    public static final int SML_NOTIFY_TAG_NAME_SERVER_CHANGE = 3;
    public static final int SML_NOTIFY_TAG_EPORT_TOPO_CHANGE = 4;
    public static final int SML_NOTIFY_TAG_SWITCH_CONFIG_CHANGE = 5;
    public static final int SML_NOTIFY_TAG_SWITCH_OPER_CHANGE = 6;
    public static final int SML_NOTIFY_TAG_CHASSIS_OPER_CHANGE = 7;
    public static final int SML_NOTIFY_TAG_BLADE_OPER_CHANGE = 8;
    public static final int SML_NOTIFY_TAG_PORT_OPER_CHANGE = 9;
    public static final int SML_NOTIFY_TAG_PORT_CONFIG_CHANGE = 10;
    public static final int SML_NOTIFY_TAG_SYSTEM_CONFIG_CHANGE = 11;
    public static final int SML_NOTIFY_TAG_SNMP_CONFIG_CHANGE = 12;
    public static final int SML_NOTIFY_TAG_ALARM_ZONING_MERGE = 13;
    public static final int SML_NOTIFY_TAG_ALARM_EPORT_CONVERGE = 14;
    public static final int SML_NOTIFY_TAG_ALARM_UNAUTH_ACCESS = 15;
    public static final int SML_NOTIFY_TAG_ALARM_SWITCH_RESET = 16;
    public static final int SML_NOTIFY_TAG_ALARM_ADMIN_TIMEOUT = 17;
    public static final int SML_NOTIFY_TAG_ALARM_POWER_SUPPLY_BAD = 18;
    public static final int SML_NOTIFY_TAG_ALARM_POWER_SUPPLY_OK = 19;
    public static final int SML_NOTIFY_TAG_ALARM_FAN_BAD = 20;
    public static final int SML_NOTIFY_TAG_ALARM_FAN_OK = 21;
    public static final int SML_NOTIFY_TAG_ALARM_OVERHEAT = 22;
    public static final int SML_NOTIFY_TAG_ALARM_OVERWARM = 23;
    public static final int SML_NOTIFY_TAG_ALARM_NORMAL_TEMP = 24;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_LOGIN = 25;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_LOGOUT = 26;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_CRC_ERROR = 27;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_LOSS_OF_SYNC = 28;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_DECODE_ERROR = 29;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_FRAMING_ERROR = 30;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_SMOOTING = 31;
    public static final int SML_NOTIFY_TAG_ALARM_FL_LIP_FAILURE = 32;
    public static final int SML_NOTIFY_TAG_ALARM_FL_LIP_ATTEMPT = 33;
    public static final int SML_NOTIFY_TAG_ALARM_FL_NOT_MASTER = 34;
    public static final int SML_NOTIFY_TAG_ALARM_NL_PORT_TIMEOUT = 35;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_LIF_ERROR = 36;
    public static final int SML_NOTIFY_TAG_ALARM_PORT_OUT_PARITY_ERROR = 37;
    public static final int SML_NOTIFY_TAG_ALARM_GENERAL_ALARM = 38;
    public static final int SML_NOTIFY_TAG_SWITCH_STATE_CHANGE = 39;
    public static final int SML_NOTIFY_TAG_PORT_STATE_CHANGE = 40;
    public static final int SML_NOTIFY_TAG_PORT_LOOPBACK_DONE = 41;
    public static final int SML_NOTIFY_TAG_ZONING_CONFIG_CHANGE = 42;
    public static final int SML_NOTIFY_TAG_ZONING_MERGE_AUTO = 43;
    public static final int SML_NOTIFY_TAG_ZONING_MERGE_MANUAL = 44;
    public static final int SML_NOTIFY_TAG_DOWNLOAD_COMPLETE = 45;
    public static final int SML_NOTIFY_TAG_IP_ADDR_CHANGE = 46;
    public static final int SML_NOTIFY_TAG_TEST_BLADE_DONE = 47;
    public static final int SML_NOTIFY_TAG_BLADE_STATE_CHANGE = 48;
    public static final int SML_NOTIFY_TAG_TOTAL_BYTE_PERF = 49;
    public static final int SML_NOTIFY_TAG_TX_BYTE_PERF = 50;
    public static final int SML_NOTIFY_TAG_RX_BYTE_PERF = 51;
    public static final int SML_NOTIFY_TAG_TOTAL_FRAME_PERF = 52;
    public static final int SML_NOTIFY_TAG_TX_FRAME_PERF = 53;
    public static final int SML_NOTIFY_TAG_RX_FRAME_PERF = 54;
    public static final int SML_NOTIFY_TAG_TOTAL_ERRORS_PERF = 55;
    public static final int SML_NOTIFY_TAG_PORT_STATS_CLEARED = 56;
    public static final int SML_NOTIFY_TAG_THRESHOLDS_CHANGED = 57;
    public static final int SML_NOTIFY_TAG_IMAGE_UNPACK_COMPLETE = 58;
    public static final int SML_NOTIFY_TAG_PING = 59;
    public static final int SML_NOTIFY_TAG_ACCOUNT_CHANGE = 60;
    public static final int SML_NOTIFY_TAG_NAME_SERVER_ALL_CHANGE = 61;
    String tag;

    public UtilMsgNotifySml(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener);
    }

    public boolean isReceivedAlarm(int n) {
        return n >= 13 && n <= 38;
    }

    public boolean pack() {
        String string = null;
        int n = this.tag.indexOf("(");
        int n2 = this.tag.indexOf(")");
        String string2 = this.tag.substring(n + 1, n2);
        int n3 = 0;
        while (n3 < notifySmlCommands.length) {
            if (string2.equals(UtilMsgNotifySml.removePeriods(notifySmlCommands[n3]))) {
                string = notifySmlCommands[n3];
                break;
            }
            ++n3;
        }
        if (string == null) {
            return false;
        }
        this.addSmlCommand(string + "." + this.tag + ".Ack.True.Reg.True");
        this.setDestination(new NotifyDestination(this.getResponseFcAddress()));
        this.setSetCommand();
        return super.pack();
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public static String removePeriods(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (stringBuffer.charAt(n) == '.') {
                stringBuffer.deleteCharAt(n);
            }
            --n;
        }
        return stringBuffer.toString();
    }

    class NotifyDestination
    implements UtilDestination {
        int retAddr;

        NotifyDestination(int n) {
            this.retAddr = n;
        }

        public boolean isTimedOut(UtilMessage utilMessage) {
            return System.currentTimeMillis() - utilMessage.getTimeSent() > (long)utilMessage.getTimeoutValue();
        }

        public int getFcAddress() {
            return this.retAddr;
        }

        public boolean isReachable() {
            return true;
        }

        public boolean useVersion_0() {
            return false;
        }
    }
}

