/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNameServer;
import java.net.InetAddress;

public class UtilMsgNameServerGetAllNextPartTwo
extends UtilMsgNameServer {
    int fcAddress;
    long nodeWorldWideName;
    String nodeName;
    int[] processAssociator = new int[2];
    InetAddress[] ipAddress;
    int classOfService;
    int[] fc4Types = new int[8];
    public static final int NS_GAN_REQ_LENGTH = 4;
    public static final int NS_GAN_REQ_CODE = 2;
    public static final int NS_GAN_NODE_WWN_OFFSET = 12;
    public static final int NS_GAN_NODE_LENGTH_OFFSET = 20;
    public static final int NS_GAN_NODE_ARRAY_OFFSET = 21;
    public static final int NS_GAN_PROCESS_ASSOCIATORS_OFFSET = 276;
    public static final int NS_GAN_IP_ADDRESSES_OFFSET = 284;
    public static final int NS_GAN_CLASS_OF_SERVICE_OFFSET = 300;
    public static final int NS_GAN_FC4_TYPES_OFFSET = 304;

    public UtilMsgNameServerGetAllNextPartTwo(UtilDestination utilDestination, UtilEventListener utilEventListener, int n) {
        super(utilDestination, utilEventListener, 4, 2, (byte)1);
        this.fcAddress = n;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        UtilMessage.encodeInt(this.fcAddress, this.dataBuffer, n + 12);
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        byte[] byArray;
        if (!super.unpack()) {
            return false;
        }
        if (this.messageRejected == 0 && (byArray = this.getResponsePayloadData()) != null && byArray.length >= 336) {
            this.nodeWorldWideName = UtilMessage.decodeLong(byArray, 12);
            int n = byArray[20];
            if (n < 0) {
                n += 256;
            }
            this.nodeName = new String();
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            int n2 = 0;
            while (n2 < n) {
                cArray[0] = (char)byArray[21 + n2];
                if (cArray[0] == '\u0000') break;
                this.nodeName = this.nodeName + new String(cArray);
                ++n2;
            }
            this.processAssociator = new int[2];
            this.processAssociator[0] = UtilMessage.decodeInt(byArray, 276);
            this.processAssociator[1] = UtilMessage.decodeInt(byArray, 280);
            this.ipAddress = new InetAddress[4];
            int n3 = 0;
            while (n3 < 4) {
                try {
                    this.ipAddress[n3] = InetAddress.getByName(UtilMessage.ipConvert(UtilMessage.decodeInt(byArray, 284 + n3 * 4)));
                }
                catch (Exception exception) {
                    this.ipAddress[n3] = null;
                }
                ++n3;
            }
            this.classOfService = UtilMessage.decodeInt(byArray, 300);
            this.fc4Types = new int[8];
            int n4 = 0;
            while (n4 < 8) {
                this.fc4Types[n4] = UtilMessage.decodeInt(byArray, 304 + n4 * 4);
                ++n4;
            }
            return true;
        }
        this.setStatus(105);
        return false;
    }

    public long getNodeWorldWideName() {
        return this.nodeWorldWideName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getProcessAssociator(int n) {
        if (n >= 0 && n < this.processAssociator.length) {
            return this.processAssociator[n];
        }
        return 0;
    }

    public InetAddress getIpAddress(int n) {
        if (n >= 0 && n < this.ipAddress.length) {
            return this.ipAddress[n];
        }
        return null;
    }

    public int getClassOfService() {
        return this.classOfService;
    }

    public int getFc4Type(int n) {
        if (n >= 0 && n < this.fc4Types.length) {
            return this.fc4Types[n];
        }
        return 0;
    }

    public String toString() {
        int n;
        String string = super.toString();
        string = string + new String("GET NEXT ALL NEXT Part 2\nnodeWorldWideName = " + Long.toHexString(this.nodeWorldWideName) + "\n" + "nodeName = " + this.nodeName + "\n" + "processAssociator[0] = " + this.processAssociator[0] + "\n" + "processAssociator[1] = " + this.processAssociator[1] + "\n");
        if (this.ipAddress != null) {
            n = 0;
            while (n < this.ipAddress.length) {
                string = string + new String(" " + this.ipAddress[n].getHostAddress() + ",");
                ++n;
            }
        }
        string = string + new String("classOfService = " + this.classOfService + "\n");
        if (this.fc4Types != null) {
            n = 0;
            while (n < this.fc4Types.length) {
                string = string + new String("Fc4Type[" + n + "]= " + this.fc4Types[n] + ",");
                ++n;
            }
        }
        string = string + "\n";
        return string;
    }
}

