/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UtilMsgIpConfig
extends UtilMessage {
    InetAddress address;
    int mask;
    int broadcast;
    InetAddress gateway;
    int useBootp;
    int arpTimeout;
    private static final int IPC_NETWORK_ADDRESS_OFFSET = 0;
    private static final int IPC_NETWORK_MASK_OFFSET = 4;
    private static final int IPC_NETWORK_BROADCAST_OFFSET = 8;
    private static final int IPC_GATEWAY_OFFSET = 12;
    private static final int IPC_USE_BOOTP_OFFSET = 16;
    private static final int IPC_ARP_TIMEOUT_OFFSET = 20;
    private static final int IPC_REQ_DATA_LENGTH = 0;
    private static final int IPC_SET_DATA_LENGTH = 24;
    private static final int IPC_RESP_DATA_LENGTH = 24;
    private static final int IPC_REQ_COMMAND = 132;
    private static final int IPC_SET_COMMAND = 133;

    public UtilMsgIpConfig() {
        super(null, 133, null, 24);
    }

    public UtilMsgIpConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, 132, utilEventListener, 0);
    }

    public boolean setSetCommand() {
        this.command = 133;
        this.setDataLength(24);
        return true;
    }

    public boolean setGetCommand() {
        this.command = 132;
        this.setDataLength(0);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.command == 133;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        if (this.command == 133) {
            int n = this.getSendPayloadDataOffset();
            int n2 = UtilMessage.inetToIp(this.address);
            UtilMessage.encodeInt(n2, this.dataBuffer, n + 0);
            UtilMessage.encodeInt(this.mask, this.dataBuffer, n + 4);
            UtilMessage.encodeInt(this.broadcast, this.dataBuffer, n + 8);
            int n3 = UtilMessage.inetToIp(this.gateway);
            UtilMessage.encodeInt(n3, this.dataBuffer, n + 12);
            UtilMessage.encodeInt(this.useBootp, this.dataBuffer, n + 16);
            UtilMessage.encodeInt(this.arpTimeout, this.dataBuffer, n + 20);
            this.encodeAndCalcCheckSum();
        }
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 24) {
            int n = UtilMessage.decodeInt(byArray, 0);
            this.mask = UtilMessage.decodeInt(byArray, 4);
            this.broadcast = UtilMessage.decodeInt(byArray, 8);
            int n2 = UtilMessage.decodeInt(byArray, 12);
            this.useBootp = UtilMessage.decodeInt(byArray, 16);
            this.arpTimeout = UtilMessage.decodeInt(byArray, 20);
            try {
                this.address = InetAddress.getByName(UtilMessage.ipConvert(n));
                this.gateway = InetAddress.getByName(UtilMessage.ipConvert(n2));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return true;
        }
        if (!this.getIsSetCommand()) {
            this.setStatus(105);
            return false;
        }
        return true;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getMask() {
        return this.mask;
    }

    public int getBroadcast() {
        return this.broadcast;
    }

    public InetAddress getGateway() {
        return this.gateway;
    }

    public int getUseBootp() {
        return this.useBootp;
    }

    public int getArpTimeout() {
        return this.arpTimeout;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public void setMask(int n) {
        this.mask = n;
    }

    public void setBroadcast(int n) {
        this.broadcast = n;
    }

    public void setGateway(InetAddress inetAddress) {
        this.gateway = inetAddress;
    }

    public void setUseBootp(int n) {
        this.useBootp = n;
    }

    public void setArpTimeout(int n) {
        this.arpTimeout = n;
    }

    public String toString() {
        return super.toString() + new String("IP CONFIG " + (this.getIsSetCommand() ? "SET" : "GET") + "\n" + "address = " + (this.address != null ? this.address.getHostAddress() : "null") + "\n" + "mask = " + Integer.toHexString(this.mask) + "\n" + "broadcast = " + Integer.toHexString(this.broadcast) + "\n" + "gateway = " + this.gateway + "\n" + "useBootp = " + this.useBootp + "\n" + "arpTimeout = " + this.arpTimeout + "\n");
    }
}

