/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgGetAllSwitchInternalCounters
extends UtilMsgConfig {
    int numberofAsics;
    int portsPerAsics;
    int numberOfCounters;
    int[] counters = null;
    private static final int GC_NUMBER_OF_S4_OFFSET = 0;
    private static final int GC_PORTS_PER_S4_OFFSET = 1;
    private static final int GC_COUNTERS_OFFSET = 4;
    private static final int GC_REQ_DATA_LENGTH = 0;
    private static final int GC_RESP_DATA_LENGTH = 104;
    private static final int GC_EXT_COMMAND = 96;

    public UtilMsgGetAllSwitchInternalCounters(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 0, 96);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        return super.pack();
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 104) {
            this.numberofAsics = byArray[0];
            this.portsPerAsics = byArray[1];
            this.numberOfCounters = 3 + this.numberofAsics * (3 + 2 * this.portsPerAsics);
            if (byArray.length == 4 + this.numberOfCounters * 4) {
                this.counters = new int[this.numberOfCounters];
                int n = 0;
                while (n < this.numberOfCounters) {
                    this.counters[n] = UtilMessage.decodeInt(byArray, 4 + n * 4);
                    ++n;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    public int getNumberOfAsics() {
        return this.numberofAsics;
    }

    public int getPortsPerAsic() {
        return this.portsPerAsics;
    }

    public int getNumberOfCounters() {
        return this.numberOfCounters;
    }

    public int getCounters(int n) {
        if (this.counters == null || n < 0 || n >= this.numberOfCounters) {
            return -1;
        }
        return this.counters[n];
    }

    public int[] getCounterArrayCopy() {
        int[] nArray = new int[this.counters.length];
        System.arraycopy(this.counters, 0, nArray, 0, this.counters.length);
        return nArray;
    }

    public String toString() {
        String string = super.toString() + new String("GET ALL COUNTERS\nnumberofAsics = " + this.numberofAsics + "\n" + "portsPerAsics = " + this.portsPerAsics + "\n" + "numberOfCounters = " + this.numberOfCounters + "\n");
        string = string + new String("Counters = ");
        int n = 0;
        while (n < this.numberOfCounters) {
            string = string + new String(this.counters[n] + ",");
            ++n;
        }
        string = string + "\n";
        return string;
    }
}

