/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgGetAllPortCounters
extends UtilMsgConfig {
    byte portNumber;
    long[] counters = null;
    private static final int GPC_NUMBER_OF_COUNTERS = 38;
    private static final int GPC_PORT_NUMBER_OFFSET = 0;
    private static final int GPC_COUNTERS_OFFSET = 4;
    private static final int GPC_REQ_DATA_LENGTH = 4;
    private static final int GPC_RESP_DATA_LENGTH = 156;
    private static final int GPC_EXT_COMMAND = 95;
    public static final int IN_FRAMES = 0;
    public static final int OUT_FRAMES = 1;
    public static final int DISCARDED_FRAMES = 2;
    public static final int BUSY_FRAMES = 3;
    public static final int REJECTED_FRAMES = 4;
    public static final int LINK_FAILURES = 5;
    public static final int PROTOCOL_ERRORS = 7;
    public static final int INVALID_TX_WORDS_RECV = 8;
    public static final int CRC_ERRORS = 9;
    public static final int DELIMITER_ERRORS = 10;
    public static final int ADDRESS_ID_ERRORS = 11;
    public static final int SHORT_FRAME_ERRORS = 25;
    public static final int LONG_FRAME_ERRORS = 26;
    public static final int SMOOTHING_OVERFLOW_ERRORS = 27;

    public UtilMsgGetAllPortCounters(UtilDestination utilDestination, UtilEventListener utilEventListener, byte by) {
        super(utilDestination, utilEventListener, 4, 95);
        this.portNumber = by;
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        this.dataBuffer[n + 0] = this.portNumber;
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length >= 156) {
            if (this.portNumber != byArray[0]) {
                this.setStatus(105);
                return false;
            }
            if (byArray.length == 156) {
                this.counters = new long[38];
                int n = 0;
                while (n < 38) {
                    this.counters[n] = UtilMessage.decodeUnsignedInt(byArray, 4 + n * 4);
                    ++n;
                }
                return true;
            }
            this.setStatus(105);
            return false;
        }
        this.setStatus(105);
        return false;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getNumberOfCounters() {
        return 38;
    }

    public long getCounters(int n) {
        if (this.counters == null || n < 0 || n >= this.counters.length) {
            return -1L;
        }
        return this.counters[n];
    }

    public long[] getCounterArrayCopy() {
        long[] lArray = new long[this.counters.length];
        System.arraycopy(this.counters, 0, lArray, 0, this.counters.length);
        return lArray;
    }

    public String toString() {
        String string = super.toString() + new String("GET ALL PORT COUNTERS\nportNumber = " + this.portNumber + "\n" + "numberOfCounters = " + 38 + "\n");
        string = string + new String("Counters = ");
        if (this.counters != null) {
            int n = 0;
            while (n < 38) {
                string = string + new String(this.counters[n] + ",");
                ++n;
            }
        } else {
            string = string + " null";
        }
        string = string + "\n";
        return string;
    }
}

