/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgChassisMode
extends UtilMsgConfig {
    byte chassisMode;
    private static final int CTR_CHASSIS_MODE_OFFSET = 0;
    private static final int CTR_REQ_DATA_LENGTH = 0;
    private static final int CTR_SET_DATA_LENGTH = 4;
    private static final int CTR_REQ_OPERATIONAL_EXT_COMMAND = 32;
    private static final int CTR_SET_ADMIN_EXT_COMMAND = 36;
    private static final int CTR_REQ_ADMIN_EXT_COMMAND = 33;

    public UtilMsgChassisMode(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 0, 32);
    }

    public boolean setSetCommand() {
        this.extCommand = 36;
        this.setDataLength(4);
        return true;
    }

    public boolean setGetCommand() {
        this.extCommand = 32;
        this.setDataLength(0);
        return true;
    }

    public boolean setGetAdmin() {
        this.extCommand = 33;
        this.setDataLength(0);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.extCommand == 36;
    }

    public boolean isAdmin() {
        return this.extCommand == 36 || this.extCommand == 33;
    }

    public boolean pack() {
        if (this.extCommand == 0) {
            return false;
        }
        if (this.extCommand == 36) {
            this.setDataLength(4);
        } else {
            this.setDataLength(0);
        }
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        if (this.extCommand == 36) {
            this.dataBuffer[n] = this.chassisMode;
        }
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (!this.getIsSetCommand()) {
            if (byArray != null) {
                if (byArray.length == 4) {
                    this.chassisMode = byArray[0];
                    return true;
                }
                this.setStatus(105);
                return false;
            }
            this.setStatus(105);
            return false;
        }
        if (byArray.length == 0) {
            return true;
        }
        this.setStatus(105);
        return false;
    }

    public byte getChassisMode() {
        return this.chassisMode;
    }

    public void setChassisMode(byte by) {
        this.chassisMode = by;
    }

    public String toString() {
        String string = this.extCommand == 36 ? "SET" : "GET";
        return super.toString() + new String(string + " CHASSIS MODE\n" + "ChassisMode= " + this.chassisMode + "\n");
    }
}

