/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgAllPortsStates
extends UtilMsgConfig {
    int numberOfPorts;
    PortStates[] portStates;
    private static final int GAP_NUMBER_OF_PORTS_OFFSET = 0;
    private static final int GAP_DATA_OFFSET = 4;
    private static final int GAP_REQ_DATA_LENGTH = 0;
    private static final int GAP_EXT_COMMAND = 80;

    public UtilMsgAllPortsStates(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 0, 80);
    }

    public boolean setSetCommand() {
        return false;
    }

    public boolean setGetCommand() {
        return true;
    }

    public boolean getIsSetCommand() {
        return false;
    }

    public boolean pack() {
        return super.pack();
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && byArray.length > 0) {
            this.numberOfPorts = byArray[0];
            if (this.numberOfPorts % 8 == 0 && byArray.length == 4 + this.numberOfPorts * 7) {
                this.portStates = new PortStates[this.numberOfPorts];
                int n = 0;
                while (n < this.numberOfPorts) {
                    this.portStates[n] = new PortStates();
                    this.portStates[n].setActiveAdminState(byArray[4 + this.numberOfPorts * 0 + n]);
                    this.portStates[n].setPendingAdminState(byArray[4 + this.numberOfPorts * 1 + n]);
                    this.portStates[n].setOperationalAdminState(byArray[4 + this.numberOfPorts * 2 + n]);
                    this.portStates[n].setPortType(byArray[4 + this.numberOfPorts * 3 + n]);
                    this.portStates[n].setLoggedIn(byArray[4 + this.numberOfPorts * 4 + n]);
                    this.portStates[n].setAlDisabled(byArray[4 + this.numberOfPorts * 5 + n]);
                    this.portStates[n].setMfsMode(byArray[4 + this.numberOfPorts * 6 + n]);
                    ++n;
                }
                return true;
            }
        }
        this.setStatus(105);
        return false;
    }

    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public PortStates getPortState(int n) {
        if (n >= 0 && n < this.numberOfPorts) {
            return this.portStates[n];
        }
        return null;
    }

    public String toString() {
        String string = super.toString() + new String("GET ALL PORTS STATES\nnumberOfPorts = " + this.numberOfPorts + "\n");
        int n = 0;
        while (n < this.numberOfPorts) {
            string = string + new String("Port " + n + "=");
            string = string + this.portStates[n].toString();
            ++n;
        }
        string = string + "\n";
        return string;
    }
}

