/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util.messages;

import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgConfig;

public class UtilMsgActiveTLConfig
extends UtilMsgConfig {
    byte portNum;
    boolean autoLearn;
    private static final int GET_REQ_DATA_LENGTH = 4;
    private static final int GET_RESP_DATA_LENGTH = 260;
    public static final int GET_COMMAND = 104;
    private static final int NUM_ALUT_ENTRIES = 31;
    public static final int SET_COMMAND = 103;
    private static final int SET_REQ_DATA_LENGTH = 256;
    private static final int SET_RESP_DATA_LENGTH = 0;
    private static final int PORT_NUM_OFFSET = 0;
    private static final int NUM_ALUT_OFFSET = 1;
    private static final int AUTO_LEARN_OFFSET = 4;
    private static final int PORT_WWN_OFFSET = 12;

    public UtilMsgActiveTLConfig() {
        super(null, null, 256, 103);
    }

    public UtilMsgActiveTLConfig(UtilDestination utilDestination, UtilEventListener utilEventListener) {
        super(utilDestination, utilEventListener, 4, 104);
    }

    public boolean setSetCommand() {
        this.extCommand = 103;
        this.setDataLength(256);
        return true;
    }

    public boolean setGetCommand() {
        this.extCommand = 104;
        this.setDataLength(4);
        return true;
    }

    public boolean getIsSetCommand() {
        return this.extCommand == 103;
    }

    public boolean pack() {
        if (!super.pack()) {
            return false;
        }
        int n = this.getSendPayloadDataOffset();
        if (this.extCommand == 103) {
            this.dataBuffer[n + 0] = this.portNum;
            this.dataBuffer[n + 4] = this.autoLearn ? (byte)1 : 0;
            int n2 = 0;
            while (n2 < 62) {
                this.dataBuffer[n + 12 + n2] = 0;
                ++n2;
            }
        } else if (this.extCommand == 104) {
            this.dataBuffer[n + 0] = this.portNum;
        }
        this.encodeAndCalcCheckSum();
        return true;
    }

    public boolean unpack() {
        if (!super.unpack()) {
            return false;
        }
        byte[] byArray = this.getResponsePayloadData();
        if (byArray != null && this.extCommand == 104) {
            this.portNum = byArray[0];
            if (byArray.length != 260) {
                this.setStatus(105);
                return false;
            }
            this.autoLearn = byArray[4] == 1;
        } else if (!this.getIsSetCommand()) {
            this.setStatus(105);
            return false;
        }
        return true;
    }

    public int getPortNum() {
        return this.portNum;
    }

    public void setPortNum(int n) {
        this.portNum = (byte)n;
    }

    public void setAutoLearn(boolean bl) {
        this.autoLearn = bl;
    }

    public boolean getAutoLearn() {
        return this.autoLearn;
    }

    public String toString() {
        String string = null;
        string = this.extCommand == 103 ? super.toString() + new String("SET TL PORT CONFIG:  port=" + this.portNum + " autoLearn=" + this.autoLearn) : super.toString() + new String("GET TL PORT CONFIG:  port=" + this.portNum + " autoLearn=" + this.autoLearn);
        return string;
    }
}

