/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.util;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCDiscoverer;
import com.qlogic.device.fcfabric.FCDiscovery;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.FwLoadError;
import com.qlogic.device.fcfabric.event.FwLoaderEvent;
import com.qlogic.device.fcfabric.event.FwLoaderEventListener;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgFlashLoad;
import com.qlogic.util.ftp.FtpClient;
import com.qlogic.util.ftp.FtpClientEvent;
import com.qlogic.util.ftp.FtpClientEventListener;
import com.qlogic.util.ftp.FtpReply;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class FwLoader
implements ChassisEventListener,
UtilEventListener,
FtpClientEventListener {
    private static final int IDLE = 0;
    private static final int CONNECT = 1;
    private static final int FTP_UPLOAD = 2;
    private static final int UTIL_UPLOAD = 3;
    private static final int REGISTER = 4;
    private static final int UNPACK = 5;
    private static final int UNREGISTER = 6;
    private static final int CANCEL = 7;
    private static final int CLEANUP = 8;
    private static int[] fwLoadPollFilter = new int[]{212, 240};
    private int state;
    private static final int MAX_UTIL_RETRYS = 2;
    private static final long UNPACK_TIMEOUT = 90000L;
    private static final int BUFSIZ = 1400;
    private static final String UTIL_FW_FILE_NAME = "/itasca/conf/firmware";
    private String imageName;
    private static final String FTP_USERNAME = "images";
    private static final String FTP_PASSWORD = "images";
    private Sanbox2 sw;
    private Sanbox2 targetSw;
    private File imageFile;
    private int imageLen;
    private int bufLen;
    private byte[] buffer;
    private int bytesSent;
    private BufferedInputStream image;
    private UtilDestination dest;
    private UtilAgent agent;
    private ArrayList eventListeners = new ArrayList();
    private FtpClient ftpClient;
    private int retrys;
    private Timer watchdog;
    Fabric fabric;
    private ErrorType exiterror;

    public FwLoader(Sanbox2 sanbox2, File file) throws FileNotFoundException {
        this.sw = this.targetSw = sanbox2;
        this.imageFile = file;
        this.imageLen = (int)file.length();
        this.bufLen = 1400;
        this.dest = sanbox2;
        this.agent = (UtilAgent)sanbox2.getComAgent();
        this.fabric = FabricList.getFabric(sanbox2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        FwLoader fwLoader = this;
        synchronized (fwLoader) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
        }
        this.quietFabric(true);
        this.chooseConnection();
    }

    private void chooseConnection() {
        if (this.sw.getDiscoveredByIpAddress()) {
            this.tryFtpConnect();
        } else {
            this.tryOobConnect();
        }
    }

    private void tryOobConnect() {
        UtilAgent utilAgent = new UtilAgent(this.sw.getIpInfo().getIpAddress());
        utilAgent.getLoginInfo().setUsername(this.fabric.getUserName());
        utilAgent.getLoginInfo().setPassword(this.fabric.getPassword());
        utilAgent.startMessageThread();
        FCDiscoverer fCDiscoverer = new FCDiscoverer();
        FCDiscovery fCDiscovery = fCDiscoverer.DiscoverSwitch(utilAgent);
        Chassis chassis = fCDiscovery.getChassis();
        if (chassis != null && chassis instanceof SanboxChassis && chassis.equals(this.sw)) {
            this.agent = utilAgent;
            this.sw = (Sanbox2)chassis;
            this.tryFtpConnect();
        } else {
            utilAgent.die();
            this.startUtilUpload();
        }
    }

    public synchronized void cancel() {
        if (this.state == 2 && this.ftpClient != null) {
            this.ftpClient.cancel();
        } else {
            this.state = 7;
        }
    }

    private synchronized boolean handleCancel() {
        if (this.state == 7) {
            this.goIdle(new FwLoadError(11));
            return true;
        }
        if (this.state == 8) {
            return false;
        }
        return false;
    }

    private void tryFtpConnect() {
        if (this.handleCancel()) {
            return;
        }
        try {
            this.ftpClient = new FtpClient(this.targetSw.getIpInfo().getIpAddress(), "images", "images");
        }
        catch (Exception exception) {
            this.startUtilUpload();
            return;
        }
        this.startFtpUpload();
    }

    private void startFtpUpload() {
        if (this.handleCancel()) {
            return;
        }
        this.state = 2;
        this.sw.addChassisEventListener(this);
        this.sw.requestAdmin();
    }

    private void ftpUpload() {
        if (this.handleCancel()) {
            return;
        }
        this.state = 2;
        this.fireEvent(6005, null, true);
        this.imageName = this.imageFile.getName();
        this.ftpClient.addEventListener(this);
        this.ftpClient.setType("bin");
        FtpReply ftpReply = this.ftpClient.put(this.imageFile);
        this.ftpClient.removeEventListener(this);
        FtpReply ftpReply2 = this.ftpClient.close();
        this.ftpClient = null;
        if (ftpReply.getCode() == 426) {
            this.goIdle(new FwLoadError(11));
        } else if (ftpReply.getCode() != 226) {
            this.goIdle(new FwLoadError(14, ftpReply.toString()));
        } else {
            this.registerForUnpackComplete();
        }
    }

    private void startUtilUpload() {
        if (this.handleCancel()) {
            return;
        }
        this.state = 3;
        this.sw.addChassisEventListener(this);
        this.sw.requestAdmin();
    }

    private void sendFirstBlock() {
        if (this.handleCancel()) {
            return;
        }
        this.fireEvent(6005, null, true);
        this.bytesSent = 0;
        this.imageName = UTIL_FW_FILE_NAME;
        this.buffer = new byte[this.bufLen];
        try {
            this.image = new BufferedInputStream(new FileInputStream(this.imageFile));
            this.image.read(this.buffer);
        }
        catch (IOException iOException) {
            this.goIdle(new FwLoadError(iOException.toString()));
        }
        UtilMsgFlashLoad utilMsgFlashLoad = new UtilMsgFlashLoad(this.dest, this, this.imageLen, this.bufLen);
        utilMsgFlashLoad.setBuffer(this.buffer);
        utilMsgFlashLoad.setTimeoutValue(2000);
        this.agent.loadFirmware(utilMsgFlashLoad);
    }

    private void sendNextBlock(UtilMsgFlashLoad utilMsgFlashLoad) {
        int n = utilMsgFlashLoad.getSeqNum() + 1;
        if (utilMsgFlashLoad.getStatus() != 103) {
            if (utilMsgFlashLoad.getStatus() != 107) {
                this.goIdle(new FwLoadError(14));
                return;
            }
            if (this.retrys > 2) {
                this.goIdle(new FwLoadError(12));
                return;
            }
            ++this.retrys;
            --n;
        } else {
            this.retrys = 0;
            this.bytesSent += utilMsgFlashLoad.getBufLen();
        }
        this.fireEvent(6000, (Object)new Long(this.bytesSent), true);
        if (this.bytesSent == this.imageLen) {
            this.registerForUnpackComplete();
            return;
        }
        int n2 = this.imageLen - this.bytesSent;
        if (n2 < this.bufLen) {
            this.bufLen = this.imageLen - this.bytesSent;
            this.buffer = new byte[this.bufLen];
        }
        try {
            this.image.read(this.buffer);
        }
        catch (IOException iOException) {
            this.goIdle(new FwLoadError(14, iOException.toString()));
            return;
        }
        UtilMsgFlashLoad utilMsgFlashLoad2 = new UtilMsgFlashLoad(this.dest, this, this.imageLen, this.bufLen);
        if (n == 0) {
            utilMsgFlashLoad2.setTimeoutValue(2000);
        }
        utilMsgFlashLoad2.setBuffer(this.buffer);
        utilMsgFlashLoad2.setSeqNum(n);
        if (!this.agent.loadFirmware(utilMsgFlashLoad2)) {
            this.goIdle(new FwLoadError(14));
        }
    }

    private void registerForUnpackComplete() {
        if (this.handleCancel()) {
            return;
        }
        this.state = 4;
        ((Sanbox2Sml)this.sw).registerForImageUnpackNotification(true);
    }

    private void unpackImage() {
        if (this.handleCancel()) {
            return;
        }
        this.state = 5;
        this.fireEvent(6004, null, true);
        this.sw.unpackFwImage(this.imageName);
    }

    private synchronized void goIdle(ErrorType errorType) {
        if (this.state != 7) {
            this.state = 8;
        }
        this.buffer = null;
        this.exiterror = errorType;
        if (this.state == 7) {
            ((Sanbox2Sml)this.sw).registerForImageUnpackNotification(false);
        } else {
            this.sw.releaseAdmin();
        }
    }

    private synchronized void idle() {
        this.sw.removeChassisEventListener(this);
        if (this.sw != this.targetSw) {
            this.agent.die();
            this.agent = (UtilAgent)this.targetSw.getComAgent();
            this.sw = this.targetSw;
        }
        this.quietFabric(false);
        this.fireEvent(6001, null, this.exiterror);
        this.exiterror = null;
        this.state = 0;
    }

    private void quietFabric(boolean bl) {
        this.fabric.setPollingFilter((int[])(bl ? fwLoadPollFilter : null));
        this.fabric.enableSessionTimer(!bl);
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        block0 : switch (chassisEvent.getEventType()) {
            case 238: {
                switch (this.state) {
                    case 2: {
                        if (chassisEvent.isSuccessful()) {
                            this.ftpUpload();
                            break block0;
                        }
                        this.goIdle(chassisEvent.getErrorType());
                        break block0;
                    }
                    case 3: {
                        if (chassisEvent.isSuccessful()) {
                            this.sendFirstBlock();
                            break block0;
                        }
                        this.goIdle(chassisEvent.getErrorType());
                        break block0;
                    }
                }
                this.handleCancel();
                break;
            }
            case 352: {
                if (this.state != 8 && this.state != 7) break;
                this.idle();
                break;
            }
            case 239: {
                if (this.state != 8 && this.state != 7) break;
                if (this.sw != this.targetSw) {
                    this.sw.closeMgmtSession();
                    break;
                }
                this.idle();
                break;
            }
            case 346: {
                if (this.state == 4) {
                    this.unpackImage();
                    break;
                }
                if (this.state == 7) {
                    this.sw.cleanupFwImage();
                    break;
                }
                this.handleCancel();
                break;
            }
            case 345: {
                if (this.state == 5) {
                    if (chassisEvent.isSuccessful()) {
                        this.fireEvent(6002, null, chassisEvent.getErrorType());
                        this.watchdog = new Timer();
                        this.watchdog.schedule((TimerTask)new FwWatchdogTask(), 90000L);
                        break;
                    }
                    this.goIdle(chassisEvent.getErrorType());
                    break;
                }
                this.handleCancel();
                break;
            }
            case 281: {
                if (this.state != 5) break;
                this.watchdog.cancel();
                this.goIdle(chassisEvent.getErrorType());
                break;
            }
            case 381: {
                if (this.state != 7) break;
                this.sw.releaseAdmin();
            }
        }
    }

    public void receiveEvent(FtpClientEvent ftpClientEvent) {
        switch (ftpClientEvent.getType()) {
            case 0: {
                this.fireEvent(6000, ftpClientEvent.getValue(), true);
            }
        }
    }

    public void receiveMessage(UtilMessage utilMessage) {
        if (!this.handleCancel() && this.state == 3 && utilMessage instanceof UtilMsgFlashLoad) {
            this.sendNextBlock((UtilMsgFlashLoad)utilMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(FwLoaderEventListener fwLoaderEventListener) {
        if (fwLoaderEventListener == null) {
            return;
        }
        ArrayList arrayList = this.eventListeners;
        synchronized (arrayList) {
            if (!this.eventListeners.contains(fwLoaderEventListener)) {
                this.eventListeners.add(fwLoaderEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(FwLoaderEventListener fwLoaderEventListener) {
        if (fwLoaderEventListener == null) {
            return;
        }
        ArrayList arrayList = this.eventListeners;
        synchronized (arrayList) {
            if (this.eventListeners.contains(fwLoaderEventListener)) {
                this.eventListeners.remove(fwLoaderEventListener);
            }
        }
    }

    public void fireEvent(int n, Object object, boolean bl) {
        this.fireEvent(new FwLoaderEvent(this, n, object, bl));
    }

    public void fireEvent(int n, Object object, ErrorType errorType) {
        this.fireEvent(new FwLoaderEvent(this, n, object, errorType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(FwLoaderEvent fwLoaderEvent) {
        ArrayList arrayList;
        ArrayList arrayList2 = this.eventListeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.eventListeners.clone();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((FwLoaderEventListener)iterator.next()).receiveEvent(fwLoaderEvent);
        }
    }

    class FwWatchdogTask
    extends TimerTask {
        FwWatchdogTask() {
        }

        public void run() {
            FwLoader.this.goIdle(new FwLoadError(13));
        }
    }
}

