/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.zoning.Sanbox2Zones;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import java.util.Vector;

public class ZoningConfiguredAttr
extends SwitchAttribute
implements UtilEventListener {
    public static final int UPDATE_COMPLETE_EVENT = 378;
    private static final int SML_GET_FIRST_ZONE_SET = 12;
    private static final int SML_GET_NEXT_ZONE_SET = 13;
    private static final int SML_GET_FIRST_ZONE = 14;
    private static final int SML_GET_NEXT_ZONE = 15;
    private static final int SML_GET_FIRST_ZONE_IN_SET = 16;
    private static final int SML_GET_NEXT_ZONE_IN_SET = 17;
    private static final int SML_GET_FIRST_MEMBER_IN_ZONE = 18;
    private static final int SML_GET_NEXT_MEMBER_IN_ZONE = 19;
    private static final int SML_START_ZONE_SAVE = 25;
    private static final int SML_CREATE_ZONE_SETS = 26;
    private static final int SML_CREATE_ZONES = 27;
    private static final int SML_FILL_ZONE_SET = 28;
    private static final int SML_FILL_ZONE = 29;
    private static final int SML_FINISH_ZONE_SAVE = 30;
    private static final int SML_FINISH_ZONE_APPLY_ABORT = 31;
    private static final int SML_FILL_ZONE_ALIAS = 57;
    private static final int SML_CREATE_ZONE_ALIASES = 56;
    private static final int SML_GET_FIRST_ZONE_ALIAS = 58;
    private static final int SML_GET_NEXT_ZONE_ALIAS = 59;
    private static final int SML_GET_FIRST_MEMBER_IN_ALIAS = 60;
    private static final int SML_GET_NEXT_MEMBER_IN_ALIAS = 61;
    private static final int SML_GET_ZONE_TYPE = 68;
    private static final int SML_GET_ZONING_INACTIVE_TIMESTAMP = 92;
    Sanbox2 sanbox2;
    int maxSets = 256;
    int maxAlias = 256;
    int maxZones = 256;
    int maxMembers = 2000;
    int maxMembersPerZone = 2000;
    int maxMembersPerAlias = 2000;
    int maxZonesInSets = 1000;
    UtilAgent utilAgent;
    ChassisEventHandler eventHandler;
    ErrorType applyErrorType = null;
    Sanbox2Zones tempEportZoningDB = new Sanbox2Zones();
    Sanbox2Zones eportZoningDB = new Sanbox2Zones();
    private static final int E_PORT_ZONING_STATE_IDLE = 0;
    private static final int E_PORT_ZONING_STATE_LOADING = 1;
    private static final int E_PORT_ZONING_STATE_SAVING = 3;
    private static final int E_PORT_ZONING_STATE_SAVING_CANCELING = 4;
    private int eportZoningState = 0;

    public ZoningConfiguredAttr(UtilAgent utilAgent, Sanbox2 sanbox2, ChassisEventHandler chassisEventHandler) {
        super((Sanbox2Sml)sanbox2, 378);
        this.utilAgent = utilAgent;
        this.sanbox2 = sanbox2;
        this.eventHandler = chassisEventHandler;
    }

    public void saveResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    public Sanbox2Zones getZones() {
        return this.eportZoningDB;
    }

    public void receiveMessage(UtilMessage utilMessage) {
        if (!(utilMessage instanceof UtilMsgSml)) {
            return;
        }
        UtilMsgSml utilMsgSml = (UtilMsgSml)utilMessage;
        if (utilMessage.getStatus() != 103 || !utilMsgSml.AllResponsesOk()) {
            if (utilMessage.getIsSetCommand()) {
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Zoning set message failed" + utilMessage.getDataTransfered());
            }
            ((Sanbox2Sml)this.sanbox2).updateStatusWithMsgResponse(utilMsgSml);
        }
        switch (utilMsgSml.getGroupKey()) {
            case 92: {
                if (utilMsgSml.getStatus() == 103) {
                    this.saveInactiveTimeStamp(utilMsgSml);
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 58: 
            case 59: {
                if (utilMsgSml.AllResponsesOk()) {
                    String string = utilMsgSml.getResponse(0).getResponse();
                    boolean bl = false;
                    Vector vector = this.getResponseElementList(string);
                    String string2 = null;
                    int n = 0;
                    while (n < vector.size()) {
                        string2 = (String)vector.elementAt(n);
                        if (!this.addZoneAlias(string2)) {
                            FabricUtilities.logMessage("Failed addZoneAlias name=" + string2);
                            this.cancelEPortZoningLoad();
                        }
                        ++n;
                    }
                    if (string.endsWith(",")) {
                        this.getNextZoneAlias(string2);
                        break;
                    }
                    if (this.finishedGettingAliases()) break;
                    FabricUtilities.logMessage("Failed finishedGettingAliases");
                    this.cancelEPortZoningLoad();
                    break;
                }
                if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    if (this.finishedGettingAliases()) break;
                    FabricUtilities.logMessage("Failed finishedGettingAliases");
                    this.cancelEPortZoningLoad();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 12: 
            case 13: {
                if (utilMsgSml.AllResponsesOk()) {
                    String string = utilMsgSml.getResponse(0).getResponse();
                    boolean bl = false;
                    Vector vector = this.getResponseElementList(string);
                    String string3 = null;
                    int n = 0;
                    while (n < vector.size()) {
                        string3 = (String)vector.elementAt(n);
                        if (!Sanbox2Zones.verifyName(string3)) {
                            FabricUtilities.logMessage("received a bad set name from the switch set->" + string3 + " util=" + utilMessage.getDataTransfered());
                            this.tempEportZoningDB.setErrorReading(true);
                        } else if (!this.addZoneSet(string3)) {
                            FabricUtilities.logMessage("Failed addZoneSet name=" + string3);
                            this.cancelEPortZoningLoad();
                        }
                        ++n;
                    }
                    if (string.endsWith(",")) {
                        this.getNextZoneSet(string3);
                        break;
                    }
                    if (this.finishedGettingSets()) break;
                    FabricUtilities.logMessage("Failed finishedGettingSets");
                    this.cancelEPortZoningLoad();
                    break;
                }
                if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    if (this.finishedGettingSets()) break;
                    FabricUtilities.logMessage("Failed finishedGettingSets");
                    this.cancelEPortZoningLoad();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 68: {
                if (utilMsgSml.AllResponsesOk()) {
                    int n = 0;
                    while (n < utilMsgSml.getNumberOfResponses()) {
                        String string = utilMsgSml.getRequest(n).getRequestWord(3);
                        String string4 = utilMsgSml.getResponse(n).getResponse();
                        Zone zone = this.tempEportZoningDB.findZone(string);
                        if (zone != null) {
                            if (string4.equals("Soft")) {
                                zone.setZoneType(0);
                            }
                            if (string4.equals("HardVPF")) {
                                zone.setZoneType(1);
                            }
                            if (string4.equals("HardACL")) {
                                zone.setZoneType(2);
                            }
                        }
                        ++n;
                    }
                    if (this.finishedGettingZoneTypes()) break;
                    FabricUtilities.logMessage("Failed finishedGettingZoneTypes");
                    this.cancelEPortZoningLoad();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 14: 
            case 15: {
                if (utilMsgSml.AllResponsesOk()) {
                    String string = utilMsgSml.getResponse(0).getResponse();
                    boolean bl = false;
                    Vector vector = this.getResponseElementList(string);
                    String string5 = null;
                    int n = 0;
                    while (n < vector.size()) {
                        string5 = (String)vector.elementAt(n);
                        if (!Sanbox2Zones.verifyName(string5)) {
                            FabricUtilities.logMessage("received a bad zone name from the switch zone->" + string5 + " util=" + utilMessage.getDataTransfered());
                            this.tempEportZoningDB.setErrorReading(true);
                        } else if (!this.addZone(string5)) {
                            FabricUtilities.logMessage("Failed addZone name=" + string5);
                            this.cancelEPortZoningLoad();
                        }
                        ++n;
                    }
                    if (string.endsWith(",")) {
                        this.getNextZone(string5);
                        break;
                    }
                    if (this.getZoneTypes()) break;
                    FabricUtilities.logMessage("Failed getZoneTypes");
                    this.cancelEPortZoningLoad();
                    break;
                }
                if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    if (this.getZoneTypes()) break;
                    FabricUtilities.logMessage("Failed getZoneTypes");
                    this.cancelEPortZoningLoad();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 16: 
            case 17: {
                boolean bl = false;
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                ZoneSet zoneSet = this.tempEportZoningDB.findZoneSet(string);
                if (zoneSet == null) {
                    FabricUtilities.logMessage("Failed set=null SML_GET_NEXT_ZONE_IN_SET canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                } else if (utilMsgSml.AllResponsesOk()) {
                    String string6 = utilMsgSml.getResponse(0).getResponse();
                    boolean bl2 = false;
                    Vector vector = this.getResponseElementList(string6);
                    String string7 = null;
                    int n = 0;
                    while (n < vector.size()) {
                        string7 = (String)vector.elementAt(n);
                        if (!this.addZoneToSet(zoneSet, string7)) {
                            FabricUtilities.logMessage("Failed addZoneToSet set=" + zoneSet + " name=" + string7);
                            this.cancelEPortZoningLoad();
                        }
                        ++n;
                    }
                    if (string6.endsWith(",")) {
                        this.getNextZoneInSet(zoneSet, string7);
                    } else {
                        bl = true;
                    }
                } else if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    bl = true;
                } else {
                    FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
                if (!bl) break;
                if ((zoneSet = this.tempEportZoningDB.getNextZoneSet(zoneSet)) != null) {
                    if (this.getFirstZoneInSet(zoneSet)) break;
                    FabricUtilities.logMessage("Failed getFirstZoneInSet set=" + zoneSet);
                    this.cancelEPortZoningLoad();
                    break;
                }
                if (this.finishedLoadingZoneSetMembers()) break;
                FabricUtilities.logMessage("Failed finishedLoadingZoneSetMembers");
                this.cancelEPortZoningLoad();
                break;
            }
            case 60: 
            case 61: {
                boolean bl = false;
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                ZoneAlias zoneAlias = this.tempEportZoningDB.findZoneAlias(string);
                if (zoneAlias == null) {
                    FabricUtilities.logMessage("Failed zoneAlias=null SML_GET_NEXT_MEMBER_IN_ALIAS sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                } else if (utilMsgSml.AllResponsesOk()) {
                    String string8 = utilMsgSml.getResponse(0).getResponse();
                    boolean bl3 = false;
                    Vector vector = this.getResponseElementList(string8);
                    if (!this.addZoneMembersToAlias(zoneAlias, vector)) {
                        FabricUtilities.logMessage("Failed addZoneMembersToAlias alias=" + zoneAlias + " member=" + string8);
                        this.cancelEPortZoningLoad();
                    }
                    if (string8.endsWith(",")) {
                        if (vector.size() > 0) {
                            String string9 = (String)vector.elementAt(vector.size() - 1);
                            int n = string9.indexOf(45);
                            if (n > 0) {
                                this.getNextMemberInAlias(zoneAlias, string9.substring(n + 1));
                            } else {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                } else if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    bl = true;
                } else {
                    FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
                if (!bl) break;
                if ((zoneAlias = this.tempEportZoningDB.getNextZoneAlias(zoneAlias)) != null) {
                    if (this.getFirstMemberInAlias(zoneAlias)) break;
                    FabricUtilities.logMessage("Failed getFirstMemberInAlias name=" + zoneAlias);
                    this.cancelEPortZoningLoad();
                    break;
                }
                if (this.finishedLoadingZoneAliases()) break;
                FabricUtilities.logMessage("Failed finishedLoadingZoneAliases");
                this.cancelEPortZoningLoad();
                break;
            }
            case 18: 
            case 19: {
                boolean bl = false;
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                Zone zone = this.tempEportZoningDB.findZone(string);
                if (zone == null) {
                    FabricUtilities.logMessage("Failed zone=null SML_GET_NEXT_MEMBER_IN_ZONE sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                } else if (utilMsgSml.AllResponsesOk()) {
                    String string10 = utilMsgSml.getResponse(0).getResponse();
                    boolean bl4 = false;
                    Vector vector = this.getResponseElementList(string10);
                    if (!this.addZoneMembers(zone, vector)) {
                        FabricUtilities.logMessage("Failed addZoneMembers zone=" + zone + " member=" + string10);
                        this.cancelEPortZoningLoad();
                    }
                    if (string10.endsWith(",")) {
                        if (vector.size() > 0) {
                            String string11 = (String)vector.elementAt(vector.size() - 1);
                            int n = string11.indexOf(45);
                            if (n > 0) {
                                this.getNextMemberInZone(zone, string11.substring(n + 1));
                            } else {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                } else if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    bl = true;
                } else {
                    FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
                if (!bl) break;
                if ((zone = this.tempEportZoningDB.getNextZone(zone)) != null) {
                    this.getFirstMemberInZone(zone);
                    break;
                }
                this.finishedLoadingZoneMembers();
                break;
            }
            case 25: {
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.createZoneAliases()) break;
                    FabricUtilities.logMessage("Failed SML_START_ZONE_SAVE msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_START_ZONE_SAVE");
                this.cancelEPortZoningSave();
                break;
            }
            case 56: {
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.finishedCreatingZoneAliases()) break;
                    FabricUtilities.logMessage("Failed SML_CREATE_ZONE_ALIASES msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_CREATE_ZONE_ALIASES");
                this.cancelEPortZoningSave();
                break;
            }
            case 26: {
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.finishedCreatingZoneSets()) break;
                    FabricUtilities.logMessage("Failed SML_CREATE_ZONE_SETS msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_CREATE_ZONE_SETS");
                this.cancelEPortZoningSave();
                break;
            }
            case 27: {
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.finishedCreatingZones()) break;
                    FabricUtilities.logMessage("Failed SML_CREATE_ZONES msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_CREATE_ZONES");
                this.cancelEPortZoningSave();
                break;
            }
            case 57: {
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                ZoneAlias zoneAlias = this.tempEportZoningDB.findZoneAlias(string);
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.fillZoneAlias(zoneAlias = this.tempEportZoningDB.getNextZoneAlias(zoneAlias))) break;
                    FabricUtilities.logMessage("Failed SML_FILL_ZONE_ALIAS msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_FILL_ZONE_ALIAS");
                this.cancelEPortZoningSave();
                break;
            }
            case 28: {
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                ZoneSet zoneSet = this.tempEportZoningDB.findZoneSet(string);
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.fillZoneSet(zoneSet = this.tempEportZoningDB.getNextZoneSet(zoneSet))) break;
                    FabricUtilities.logMessage("Failed SML_FILL_ZONE_SET msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_FILL_ZONE_SET");
                this.cancelEPortZoningSave();
                break;
            }
            case 29: {
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                Zone zone = this.tempEportZoningDB.findZone(string);
                if (utilMsgSml.AllResponsesOk()) {
                    if (this.fillZone(zone = this.tempEportZoningDB.getNextZone(zone))) break;
                    FabricUtilities.logMessage("Failed SML_FILL_ZONE msg ok");
                    this.cancelEPortZoningSave();
                    break;
                }
                this.setApplyError(utilMsgSml.getErrorType());
                FabricUtilities.logMessage("Failed SML_FILL_ZONE");
                this.cancelEPortZoningSave();
                break;
            }
            case 30: {
                this.finishedSavingZones(utilMsgSml.getErrorType());
                break;
            }
            case 31: {
                this.finishedSavingZones(this.applyErrorType);
                break;
            }
        }
    }

    public void setApplyError(ErrorType errorType) {
        if (this.applyErrorType == null) {
            this.applyErrorType = errorType;
        }
    }

    public void resetApplyError() {
        this.applyErrorType = null;
    }

    private Vector getResponseElementList(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        boolean bl = string.length() == 0;
        while (!bl) {
            String string2;
            int n2 = string.indexOf(44, n);
            if (n2 >= 0) {
                string2 = string.substring(n, n2);
                vector.add(string2);
                n = n2 + 1;
                continue;
            }
            if (n < string.length()) {
                string2 = string.substring(n);
                vector.add(string2);
            }
            bl = true;
        }
        return vector;
    }

    public boolean update() {
        if (this.eportZoningState != 0) {
            return false;
        }
        this.newZoningState(1);
        return this.getInactiveTimeStamp();
    }

    private boolean getInactiveTimeStamp() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(92);
        utilMsgSml.addSmlCommand("Oper.Zoning.InactiveTime");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxZoneSets");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxZones");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxAliases");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxTotalMem");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxMemPerZone");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxMemPerAlias");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxLinkedZones");
        utilMsgSml.addSmlCommand("Oper.Zoning.MergeDifference");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private void saveInactiveTimeStamp(UtilMsgSml utilMsgSml) {
        String string = utilMsgSml.getResponse(0).getResponse();
        if (string.length() > 0 && this.eportZoningDB.isTimeStampTheSame(string) && !this.eportZoningDB.getErrorReading()) {
            this.finishedLoadingZoning();
        } else {
            if (utilMsgSml.getResponse(1).getErrorCode() == 0 && utilMsgSml.getResponse(2).getErrorCode() == 0 && utilMsgSml.getResponse(3).getErrorCode() == 0 && utilMsgSml.getResponse(4).getErrorCode() == 0) {
                this.maxSets = Integer.parseInt(utilMsgSml.getResponse(1).getResponse());
                this.maxZones = Integer.parseInt(utilMsgSml.getResponse(2).getResponse());
                this.maxAlias = Integer.parseInt(utilMsgSml.getResponse(3).getResponse());
                this.maxMembers = Integer.parseInt(utilMsgSml.getResponse(4).getResponse());
            }
            if (utilMsgSml.getResponse(5).getErrorCode() == 0) {
                this.maxMembersPerZone = Integer.parseInt(utilMsgSml.getResponse(5).getResponse());
            }
            if (utilMsgSml.getResponse(6).getErrorCode() == 0) {
                this.maxMembersPerAlias = Integer.parseInt(utilMsgSml.getResponse(6).getResponse());
            }
            if (utilMsgSml.getResponse(7).getErrorCode() == 0) {
                this.maxZonesInSets = Integer.parseInt(utilMsgSml.getResponse(7).getResponse());
            }
            this.tempEportZoningDB = new Sanbox2Zones(this.maxSets, this.maxAlias, this.maxZones, this.maxMembers, this.maxMembersPerZone, this.maxMembersPerAlias, this.maxZonesInSets);
            this.tempEportZoningDB.setZoningMergeDiff(utilMsgSml.getResponse(8).getResponse().equals("True"));
            this.tempEportZoningDB.setLimitsEnforced(false);
            this.tempEportZoningDB.setTimeStamp(string);
            this.getFirstZoneAlias();
        }
    }

    public void cancelEPortZoningLoad() {
        if (this.eportZoningState == 1) {
            this.tempEportZoningDB = new Sanbox2Zones();
            this.newZoningState(0);
        }
        this.eventHandler.fireChassisEvent(378, null, false);
    }

    private boolean addZoneAlias(String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null && string.length() > 0) {
            ZoneAlias zoneAlias = this.tempEportZoningDB.createZoneAlias(string);
            return zoneAlias != null;
        }
        return false;
    }

    private boolean addZoneSet(String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null) {
            ZoneSet zoneSet = this.tempEportZoningDB.createZoneSet(string);
            return zoneSet != null;
        }
        return false;
    }

    private boolean finishedGettingAliases() {
        ZoneAlias zoneAlias = this.tempEportZoningDB.getFirstZoneAlias();
        if (zoneAlias != null) {
            return this.getFirstMemberInAlias(zoneAlias);
        }
        return this.finishedLoadingZoneAliases();
    }

    private boolean finishedGettingSets() {
        return this.getFirstZone();
    }

    private boolean addZone(String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null && string.length() > 0) {
            Zone zone = this.tempEportZoningDB.createZone(string);
            return zone != null;
        }
        return false;
    }

    private boolean finishedGettingZoneTypes() {
        Zone zone = this.tempEportZoningDB.getFirstZone();
        if (zone != null) {
            return this.getFirstMemberInZone(zone);
        }
        return this.finishedLoadingZoneMembers();
    }

    private boolean finishedLoadingZoneAliases() {
        return this.getFirstZoneSet();
    }

    private boolean finishedLoadingZoneMembers() {
        ZoneSet zoneSet = this.tempEportZoningDB.getFirstZoneSet();
        if (zoneSet != null) {
            return this.getFirstZoneInSet(zoneSet);
        }
        return this.finishedLoadingZoneSetMembers();
    }

    private boolean addZoneMembersToAlias(ZoneAlias zoneAlias, Vector vector) {
        if (this.eportZoningState != 1) {
            return false;
        }
        Vector<ZoneMember> vector2 = new Vector<ZoneMember>();
        int n = 0;
        while (n < vector.size()) {
            int n2;
            String string = (String)vector.elementAt(n);
            if (string != null && (n2 = string.indexOf(45)) > 0) {
                ZoneMember zoneMember;
                String string2 = string.substring(n2 + 1);
                if (string.charAt(0) != '4' && (zoneMember = this.tempEportZoningDB.createZoneMember(string2)) != null) {
                    vector2.add(zoneMember);
                }
            }
            ++n;
        }
        if (vector2.size() > 0) {
            return this.tempEportZoningDB.addZoneMembersToZone(zoneAlias, vector2) == 0;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addZoneMembers(Zone zone, Vector vector) {
        if (this.eportZoningState != 1) {
            return false;
        }
        Vector<ZoneMember> vector2 = new Vector<ZoneMember>();
        int n = 0;
        while (n < vector.size()) {
            int n2;
            String string = (String)vector.elementAt(n);
            if (string != null && (n2 = string.indexOf(45)) > 0) {
                String string2 = string.substring(n2 + 1);
                if (string.charAt(0) == '4') {
                    ZoneAlias zoneAlias = this.tempEportZoningDB.findZoneAlias(string2);
                    if (zoneAlias == null) return false;
                    vector2.add(zoneAlias);
                } else {
                    ZoneMember zoneMember = this.tempEportZoningDB.createZoneMember(string2);
                    if (zoneMember == null) return false;
                    vector2.add(zoneMember);
                }
            }
            ++n;
        }
        if (vector2.size() <= 0) return true;
        if (this.tempEportZoningDB.addZoneMembersToZone(zone, vector2) != 0) return false;
        return true;
    }

    private boolean addZoneToSet(ZoneSet zoneSet, String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null) {
            Zone zone = this.tempEportZoningDB.createZone(string);
            if (zone == null) {
                return false;
            }
            return this.tempEportZoningDB.addZoneToSet(zone, zoneSet) == 0;
        }
        return false;
    }

    private boolean finishedLoadingZoneSetMembers() {
        this.tempEportZoningDB.setLimitsEnforced(true);
        this.eportZoningDB = this.tempEportZoningDB;
        this.tempEportZoningDB = new Sanbox2Zones();
        this.eportZoningDB.setCurrentWithSwitch(true);
        return this.finishedLoadingZoning();
    }

    public boolean finishedLoadingZoning() {
        this.eventHandler.fireChassisEvent(378, (Object)this.eportZoningDB, true);
        this.newZoningState(0);
        return true;
    }

    private boolean getFirstZoneAlias() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(58);
        utilMsgSml.addSmlCommand("Oper.Zoning.AliasList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getFirstZoneSet() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(12);
        utilMsgSml.addSmlCommand("Oper.Zoning.ZoneSetList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextZoneAlias(String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(59);
        utilMsgSml.addSmlCommand("Oper.Zoning.AliasList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextZoneSet(String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(13);
        utilMsgSml.addSmlCommand("Oper.Zoning.ZoneSetList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getFirstZoneInSet(ZoneSet zoneSet) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(16);
        utilMsgSml.addSmlCommand("Oper.Zoning.ZoneSet." + zoneSet.getName() + ".ZoneList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextZoneInSet(ZoneSet zoneSet, String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(17);
        utilMsgSml.addSmlCommand("Oper.Zoning.ZoneSet." + zoneSet.getName() + ".ZoneList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getFirstZone() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(14);
        utilMsgSml.addSmlCommand("Oper.Zoning.ZoneList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextZone(String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(15);
        utilMsgSml.addSmlCommand("Oper.Zoning.ZoneList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getZoneTypes() {
        if (this.tempEportZoningDB.getNumberOfZones() > 0) {
            UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setGroupKey(68);
            Zone zone = this.tempEportZoningDB.getFirstZone();
            while (zone != null) {
                utilMsgSml.addSmlCommand("Oper.Zoning.Zone." + zone.getName() + ".ZoneType");
                zone = this.tempEportZoningDB.getNextZone(zone);
            }
            return this.utilAgent.sendSml(utilMsgSml);
        }
        return this.finishedGettingZoneTypes();
    }

    private boolean getFirstMemberInAlias(ZoneAlias zoneAlias) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(60);
        utilMsgSml.addSmlCommand("Oper.Zoning.Alias." + zoneAlias.getName() + ".ZoneMemberList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getFirstMemberInZone(Zone zone) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(18);
        utilMsgSml.addSmlCommand("Oper.Zoning.Zone." + zone.getName() + ".ZoneMemberList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextMemberInAlias(ZoneAlias zoneAlias, String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(61);
        utilMsgSml.addSmlCommand("Oper.Zoning.Alias." + zoneAlias.getName() + ".ZoneMemberList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextMemberInZone(Zone zone, String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(19);
        utilMsgSml.addSmlCommand("Oper.Zoning.Zone." + zone.getName() + ".ZoneMemberList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyEPortZoning(Zones zones) {
        if (!(zones instanceof Sanbox2Zones)) {
            return false;
        }
        switch (this.eportZoningState) {
            case 1: {
                this.cancelEPortZoningLoad();
                this.newZoningState(3);
                break;
            }
            case 0: {
                this.newZoningState(3);
                break;
            }
            default: {
                return false;
            }
        }
        this.resetApplyError();
        this.tempEportZoningDB = (Sanbox2Zones)zones;
        return this.startZoneSave();
    }

    public void cancelEPortZoningSave() {
        this.cancelZoningChanges();
    }

    private boolean startZoneSave() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setSetCommand();
        utilMsgSml.setGroupKey(25);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Zoning.EditConfig");
        utilMsgSml.addSmlCommand("Cmd.Zoning.ClearConfig");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean createZoneSets() {
        if (this.eportZoningState != 3) {
            return false;
        }
        ZoneSet zoneSet = this.tempEportZoningDB.getFirstZoneSet();
        if (zoneSet != null) {
            UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setSetCommand();
            utilMsgSml.setGroupKey(26);
            while (zoneSet != null) {
                utilMsgSml.addSmlCommand("Cmd.Zoning.ZoneSet." + zoneSet.getName() + ".Create");
                zoneSet = this.tempEportZoningDB.getNextZoneSet(zoneSet);
            }
            return this.utilAgent.sendSml(utilMsgSml);
        }
        return this.finishedCreatingZoneSets();
    }

    private boolean createZoneAliases() {
        if (this.eportZoningState != 3) {
            return false;
        }
        ZoneAlias zoneAlias = this.tempEportZoningDB.getFirstZoneAlias();
        if (zoneAlias != null) {
            UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setSetCommand();
            utilMsgSml.setGroupKey(56);
            while (zoneAlias != null) {
                utilMsgSml.addSmlCommand("Cmd.Zoning.Alias." + zoneAlias.getName() + ".Create");
                zoneAlias = this.tempEportZoningDB.getNextZoneAlias(zoneAlias);
            }
            return this.utilAgent.sendSml(utilMsgSml);
        }
        return this.finishedCreatingZoneAliases();
    }

    private boolean finishedCreatingZoneAliases() {
        ZoneAlias zoneAlias = this.tempEportZoningDB.getFirstZoneAlias();
        return this.fillZoneAlias(zoneAlias);
    }

    private boolean finishedCreatingZoneSets() {
        return this.createZones();
    }

    private boolean createZones() {
        if (this.eportZoningState != 3) {
            return false;
        }
        Zone zone = this.tempEportZoningDB.getFirstZone();
        if (zone != null) {
            UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setSetCommand();
            utilMsgSml.setGroupKey(27);
            while (zone != null) {
                utilMsgSml.addSmlCommand("Cmd.Zoning.Zone." + zone.getName() + ".Create");
                String string = null;
                switch (zone.getZoneType()) {
                    case 0: {
                        string = "Soft";
                        break;
                    }
                    case 1: {
                        string = "HardVPF";
                        break;
                    }
                    case 2: {
                        string = "HardACL";
                    }
                }
                if (string != null) {
                    utilMsgSml.addSmlCommand("Cmd.Zoning.Zone." + zone.getName() + ".ZoneType." + string);
                }
                zone = this.tempEportZoningDB.getNextZone(zone);
            }
            return this.utilAgent.sendSml(utilMsgSml);
        }
        return this.finishedCreatingZones();
    }

    private boolean finishedCreatingZones() {
        ZoneSet zoneSet = this.tempEportZoningDB.getFirstZoneSet();
        return this.fillZoneSet(zoneSet);
    }

    private boolean fillZoneAlias(ZoneAlias zoneAlias) {
        if (this.eportZoningState != 3) {
            return false;
        }
        if (zoneAlias != null) {
            ZoneMember zoneMember = zoneAlias.getFirstMember();
            if (zoneMember != null) {
                UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
                utilMsgSml.setGroupKey(57);
                utilMsgSml.setSetCommand();
                while (zoneMember != null) {
                    utilMsgSml.addSmlCommand("Cmd.Zoning.Alias." + zoneAlias.getName() + ".AddZoneMember." + zoneMember.getMemberStorageString());
                    zoneMember = zoneAlias.getNextMember(zoneMember);
                }
                return this.utilAgent.sendSml(utilMsgSml);
            }
            zoneAlias = this.tempEportZoningDB.getNextZoneAlias(zoneAlias);
            return this.fillZoneAlias(zoneAlias);
        }
        return this.finishedFillingZoneAliases();
    }

    private boolean fillZoneSet(ZoneSet zoneSet) {
        if (this.eportZoningState != 3) {
            return false;
        }
        if (zoneSet != null) {
            Zone zone = zoneSet.getFirstZone();
            if (zone != null) {
                UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
                utilMsgSml.setGroupKey(28);
                utilMsgSml.setSetCommand();
                while (zone != null) {
                    utilMsgSml.addSmlCommand("Cmd.Zoning.ZoneSet." + zoneSet.getName() + ".AddZone." + zone.getName());
                    zone = zoneSet.getNextZone(zone);
                }
                return this.utilAgent.sendSml(utilMsgSml);
            }
            zoneSet = this.tempEportZoningDB.getNextZoneSet(zoneSet);
            return this.fillZoneSet(zoneSet);
        }
        return this.finishedFillingZoneSets();
    }

    private boolean finishedFillingZoneAliases() {
        return this.createZoneSets();
    }

    private boolean finishedFillingZoneSets() {
        Zone zone = this.tempEportZoningDB.getFirstZone();
        return this.fillZone(zone);
    }

    private boolean fillZone(Zone zone) {
        if (this.eportZoningState != 3) {
            return false;
        }
        if (zone != null) {
            ZoneMember zoneMember = zone.getFirstMember();
            if (zoneMember != null) {
                UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
                utilMsgSml.setGroupKey(29);
                utilMsgSml.setSetCommand();
                while (zoneMember != null) {
                    utilMsgSml.addSmlCommand("Cmd.Zoning.Zone." + zone.getName() + ".AddZoneMember." + zoneMember.getMemberStorageString());
                    zoneMember = zone.getNextMember(zoneMember);
                }
                return this.utilAgent.sendSml(utilMsgSml);
            }
            zone = this.tempEportZoningDB.getNextZone(zone);
            return this.fillZone(zone);
        }
        return this.finishedFillingZones();
    }

    private boolean finishedFillingZones() {
        return this.saveZoningChanges();
    }

    private boolean cancelZoningChanges() {
        if (this.eportZoningState != 3) {
            return false;
        }
        this.newZoningState(4);
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(31);
        utilMsgSml.setSetCommand();
        utilMsgSml.addSmlCommand("Cmd.Zoning.CancelConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean saveZoningChanges() {
        if (this.eportZoningState != 3) {
            return false;
        }
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(30);
        utilMsgSml.setSetCommand();
        utilMsgSml.addSmlCommand("Cmd.Zoning.SaveConfig");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private void finishedSavingZones(ErrorType errorType) {
        this.tempEportZoningDB = new Sanbox2Zones();
        this.newZoningState(0);
        this.eventHandler.fireChassisEvent(242, null, errorType);
    }

    private void newZoningState(int n) {
        this.eportZoningState = n;
    }
}

