/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import com.qlogic.device.fcfabric.zoning.Sanbox2Zones;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class ZoningActiveAttr
extends SwitchAttribute
implements UtilEventListener {
    public static final int UPDATE_COMPLETE_EVENT = 377;
    private static final int SML_GET_ACTIVE_ZONE_SET = 20;
    private static final int SML_GET_FIRST_ACTIVE_ZONE = 21;
    private static final int SML_GET_NEXT_ACTIVE_ZONE = 22;
    private static final int SML_GET_FIRST_MEMBER_IN_ACTIVE_ZONE = 23;
    private static final int SML_GET_NEXT_MEMBER_IN_ACTIVE_ZONE = 24;
    private static final int SML_ACTIVATE_ZONE_SET = 36;
    private static final int SML_DEACTIVATE_ZONE_SET = 45;
    private static final int SML_GET_ACTIVE_ZONE_TYPE = 69;
    private static final int SML_POLL_ACTIVE_ZONE_SET = 71;
    private static final int SML_GET_ZONING_ACTIVE_TIMESTAMP = 93;
    Sanbox2 sanbox2;
    private boolean updateNeeded = false;
    int maxSets = 256;
    int maxAlias = 256;
    int maxZones = 256;
    int maxMembers = 2000;
    int maxMembersPerZone = 2000;
    int maxMembersPerAlias = 2000;
    int maxZonesInSets = 1000;
    UtilAgent utilAgent;
    ChassisEventHandler eventHandler;
    Sanbox2Zones tempEportActiveZoning = new Sanbox2Zones();
    Sanbox2Zones eportActiveZoning = new Sanbox2Zones();
    Timer pollingTimer;
    String setActivated = null;
    long activateTimeOut = 0L;
    private static final int E_PORT_ZONING_STATE_IDLE = 0;
    private static final int E_PORT_ZONING_STATE_LOADING = 1;
    private static final int E_PORT_ZONING_STATE_ACTIVATION = 2;
    private static final int E_PORT_ZONING_STATE_DEACTIVATION = 3;
    private static final int E_PORT_ZONING_ACTIVATION_TIME_OUT_SECONDS = 60;
    private int eportZoningState = 0;

    public ZoningActiveAttr(UtilAgent utilAgent, Sanbox2 sanbox2, ChassisEventHandler chassisEventHandler) {
        super((Sanbox2Sml)sanbox2, 377);
        this.utilAgent = utilAgent;
        this.sanbox2 = sanbox2;
        this.eventHandler = chassisEventHandler;
    }

    public void saveResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    public Sanbox2Zones getZones() {
        return this.eportActiveZoning;
    }

    public void receiveMessage(UtilMessage utilMessage) {
        if (!(utilMessage instanceof UtilMsgSml)) {
            return;
        }
        UtilMsgSml utilMsgSml = (UtilMsgSml)utilMessage;
        if (utilMessage.getStatus() != 103 || !utilMsgSml.AllResponsesOk()) {
            if (utilMessage.getIsSetCommand()) {
                FabricUtilities.logMessage("Zoning set message failed" + utilMessage.getDataTransfered());
            }
            ((Sanbox2Sml)this.sanbox2).updateStatusWithMsgResponse(utilMsgSml);
        }
        switch (utilMsgSml.getGroupKey()) {
            case 93: {
                if (utilMsgSml.getStatus() == 103) {
                    this.saveActiveTimeStamp(utilMsgSml);
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 20: {
                if (utilMsgSml.AllResponsesOk()) {
                    String string = utilMsgSml.getResponse(0).getResponse();
                    if (this.setActiveZoneSet(string)) break;
                    FabricUtilities.logMessage("Failed setActiveZoneSet name=" + string);
                    this.cancelEPortZoningLoad();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 69: {
                if (utilMsgSml.AllResponsesOk()) {
                    int n = 0;
                    while (n < utilMsgSml.getNumberOfResponses()) {
                        String string = utilMsgSml.getRequest(n).getRequestWord(3);
                        String string2 = utilMsgSml.getResponse(n).getResponse();
                        Zone zone = this.tempEportActiveZoning.findZone(string);
                        if (zone != null) {
                            if (string2.equals("Soft")) {
                                zone.setZoneType(0);
                            }
                            if (string2.equals("HardVPF")) {
                                zone.setZoneType(1);
                            }
                            if (string2.equals("HardACL")) {
                                zone.setZoneType(2);
                            }
                        }
                        ++n;
                    }
                    this.finishedGettingActiveZoneTypes();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 21: 
            case 22: {
                if (utilMsgSml.AllResponsesOk()) {
                    String string = utilMsgSml.getResponse(0).getResponse();
                    boolean bl = false;
                    Vector vector = this.getResponseElementList(string);
                    String string3 = null;
                    int n = 0;
                    while (n < vector.size()) {
                        string3 = (String)vector.elementAt(n);
                        if (!this.addActiveZone(string3)) {
                            FabricUtilities.logMessage("Failed addActiveZone name=" + string3);
                            this.cancelEPortZoningLoad();
                        }
                        ++n;
                    }
                    if (string.endsWith(",")) {
                        this.getNextActiveZone(string3);
                        break;
                    }
                    if (this.getActiveZoneTypes()) break;
                    FabricUtilities.logMessage("Failed getActiveZoneTypes");
                    this.cancelEPortZoningLoad();
                    break;
                }
                if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    if (this.getActiveZoneTypes()) break;
                    FabricUtilities.logMessage("Failed getActiveZoneTypes");
                    this.cancelEPortZoningLoad();
                    break;
                }
                FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                this.cancelEPortZoningLoad();
                break;
            }
            case 23: 
            case 24: {
                boolean bl = false;
                String string = utilMsgSml.getRequest(0).getRequestWord(3);
                Zone zone = this.tempEportActiveZoning.findZone(string);
                if (zone == null) {
                    FabricUtilities.logMessage("Active zone=null SML_GET_NEXT_MEMBER_IN_ACTIVE_ZONE sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                } else if (utilMsgSml.AllResponsesOk()) {
                    String string4 = utilMsgSml.getResponse(0).getResponse();
                    boolean bl2 = false;
                    Vector vector = this.getResponseElementList(string4);
                    if (!this.addActiveZoneMembers(zone, vector)) {
                        FabricUtilities.logMessage("Failed addActiveZoneMembers zone=" + zone + " member=" + string4);
                        this.cancelEPortZoningLoad();
                    }
                    if (string4.endsWith(",")) {
                        if (vector.size() > 0) {
                            String string5 = (String)vector.elementAt(vector.size() - 1);
                            int n = string5.indexOf(45);
                            if (n > 0) {
                                this.getNextMemberInActiveZone(zone, string5.substring(n + 1));
                            } else {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                } else if (utilMsgSml.getNumberOfResponses() > 0 && utilMsgSml.getResponse(0).getErrorCode() == 24) {
                    bl = true;
                } else {
                    FabricUtilities.logMessage("canceled zoning load sml=" + utilMsgSml.getDataTransfered());
                    this.cancelEPortZoningLoad();
                }
                if (!bl) break;
                if ((zone = this.tempEportActiveZoning.getNextZone(zone)) != null) {
                    this.getFirstMemberInActiveZone(zone);
                    break;
                }
                this.finishedLoadingActiveZoneMembers();
                break;
            }
            case 36: {
                if (utilMsgSml.AllResponsesOk()) {
                    this.pollActiveZoneSet();
                    break;
                }
                this.finishedActivation(utilMsgSml.getErrorType());
                break;
            }
            case 71: {
                String string;
                boolean bl = false;
                if (utilMsgSml.AllResponsesOk() && this.eportZoningState == 2 && (string = utilMsgSml.getResponse(0).getResponse()).equals(this.setActivated)) {
                    bl = true;
                    this.finishedActivation(null);
                }
                if (bl || System.currentTimeMillis() <= this.activateTimeOut) break;
                this.finishedActivation(new GuiError(102));
                break;
            }
            case 45: {
                this.finishedDeactivation(utilMsgSml.getErrorType());
                break;
            }
        }
    }

    private Vector getResponseElementList(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        boolean bl = string.length() == 0;
        while (!bl) {
            String string2;
            int n2 = string.indexOf(44, n);
            if (n2 >= 0) {
                string2 = string.substring(n, n2);
                vector.add(string2);
                n = n2 + 1;
                continue;
            }
            if (n < string.length()) {
                string2 = string.substring(n);
                vector.add(string2);
            }
            bl = true;
        }
        return vector;
    }

    public boolean update() {
        if (this.eportZoningState != 0) {
            this.updateNeeded = true;
            return true;
        }
        return this.updateActive();
    }

    private boolean updateActive() {
        this.updateNeeded = false;
        this.newZoningState(1);
        return this.getActiveTimeStamp();
    }

    private boolean getActiveTimeStamp() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(93);
        utilMsgSml.addSmlCommand("Oper.Zoning.ActiveTime");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxZoneSets");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxZones");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxAliases");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxTotalMem");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxMemPerZone");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxMemPerAlias");
        utilMsgSml.addSmlCommand("Oper.Zoning.MaxLinkedZones");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private void saveActiveTimeStamp(UtilMsgSml utilMsgSml) {
        String string = utilMsgSml.getResponse(0).getResponse();
        if (string.length() > 0 && this.eportActiveZoning.isTimeStampTheSame(string) && !this.eportActiveZoning.getErrorReading()) {
            this.finishedLoadingZoning();
        } else {
            if (utilMsgSml.getResponse(1).getErrorCode() == 0 && utilMsgSml.getResponse(2).getErrorCode() == 0 && utilMsgSml.getResponse(3).getErrorCode() == 0 && utilMsgSml.getResponse(4).getErrorCode() == 0) {
                this.maxSets = Integer.parseInt(utilMsgSml.getResponse(1).getResponse());
                this.maxZones = Integer.parseInt(utilMsgSml.getResponse(2).getResponse());
                this.maxAlias = Integer.parseInt(utilMsgSml.getResponse(3).getResponse());
                this.maxMembers = Integer.parseInt(utilMsgSml.getResponse(4).getResponse());
            }
            if (utilMsgSml.getResponse(5).getErrorCode() == 0) {
                this.maxMembersPerZone = Integer.parseInt(utilMsgSml.getResponse(5).getResponse());
            }
            if (utilMsgSml.getResponse(6).getErrorCode() == 0) {
                this.maxMembersPerAlias = Integer.parseInt(utilMsgSml.getResponse(6).getResponse());
            }
            if (utilMsgSml.getResponse(7).getErrorCode() == 0) {
                this.maxZonesInSets = Integer.parseInt(utilMsgSml.getResponse(7).getResponse());
            }
            this.tempEportActiveZoning = new Sanbox2Zones(this.maxSets, this.maxAlias, this.maxZones, this.maxMembers, this.maxMembersPerZone, this.maxMembersPerAlias, this.maxZonesInSets);
            this.tempEportActiveZoning.setLimitsEnforced(false);
            this.tempEportActiveZoning.setTimeStamp(string);
            this.getActiveZoneSet();
        }
    }

    public void cancelEPortZoningLoad() {
        if (this.eportZoningState == 1) {
            this.tempEportActiveZoning = new Sanbox2Zones();
            this.newZoningState(0);
        }
        this.eventHandler.fireChassisEvent(377, null, false);
    }

    private boolean setActiveZoneSet(String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null && string.length() > 0) {
            ZoneSet zoneSet = this.tempEportActiveZoning.createZoneSet(string);
            if (zoneSet != null) {
                this.tempEportActiveZoning.setActiveZoneSet(zoneSet);
                return this.getFirstActiveZone();
            }
        } else {
            return this.finishedGettingActiveZoneTypes();
        }
        return false;
    }

    private boolean addActiveZone(String string) {
        if (this.eportZoningState != 1) {
            return false;
        }
        if (string != null) {
            Zone zone = this.tempEportActiveZoning.createZone(string);
            if (zone == null) {
                return false;
            }
            ZoneSet zoneSet = this.tempEportActiveZoning.getActiveZoneSet();
            return this.tempEportActiveZoning.addZoneToSet(zone, zoneSet) == 0;
        }
        return false;
    }

    private boolean finishedGettingActiveZoneTypes() {
        Zone zone = this.tempEportActiveZoning.getFirstZone();
        if (zone != null) {
            return this.getFirstMemberInActiveZone(zone);
        }
        return this.finishedLoadingActiveZoneMembers();
    }

    private boolean addActiveZoneMembers(Zone zone, Vector vector) {
        if (this.eportZoningState != 1) {
            return false;
        }
        Vector<ZoneMember> vector2 = new Vector<ZoneMember>();
        int n = 0;
        while (n < vector.size()) {
            String string;
            ZoneMember zoneMember;
            int n2;
            String string2 = (String)vector.elementAt(n);
            if (string2 != null && (n2 = string2.indexOf(45)) > 0 && (zoneMember = this.tempEportActiveZoning.createZoneMember(string = string2.substring(n2 + 1))) != null) {
                vector2.add(zoneMember);
            }
            ++n;
        }
        if (vector2.size() > 0) {
            return this.tempEportActiveZoning.addZoneMembersToZone(zone, vector2) == 0;
        }
        return false;
    }

    private boolean finishedLoadingActiveZoneMembers() {
        this.tempEportActiveZoning.setLimitsEnforced(true);
        this.tempEportActiveZoning.setCurrentWithSwitch(true);
        this.eportActiveZoning = this.tempEportActiveZoning;
        this.tempEportActiveZoning = new Sanbox2Zones();
        return this.finishedLoadingZoning();
    }

    public boolean finishedLoadingZoning() {
        this.eventHandler.fireChassisEvent(377, (Object)this.eportActiveZoning, true);
        this.newZoningState(0);
        return true;
    }

    private boolean pollActiveZoneSet() {
        this.pollingTimer = new Timer();
        this.pollingTimer.schedule((TimerTask)new PollActiveSet(), 0L, 1000L);
        return true;
    }

    private boolean getActiveZoneSet() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(20);
        utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZoneSet");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getFirstActiveZone() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(21);
        utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZoneSet.ZoneList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getActiveZoneTypes() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(69);
        Zone zone = this.tempEportActiveZoning.getFirstZone();
        while (zone != null) {
            utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZone." + zone.getName() + ".ZoneType");
            zone = this.tempEportActiveZoning.getNextZone(zone);
        }
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextActiveZone(String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(22);
        utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZoneSet.ZoneList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getFirstMemberInActiveZone(Zone zone) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(23);
        utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZone." + zone.getName() + ".ZoneMemberList.1400");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    private boolean getNextMemberInActiveZone(Zone zone, String string) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(24);
        utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZone." + zone.getName() + ".ZoneMemberList.1400." + string);
        return this.utilAgent.sendSml(utilMsgSml);
    }

    public boolean applyActivateZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null) {
            switch (this.eportZoningState) {
                case 1: {
                    this.cancelEPortZoningLoad();
                    this.newZoningState(2);
                    break;
                }
                case 0: {
                    this.newZoningState(2);
                    break;
                }
                default: {
                    return false;
                }
            }
            UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
            utilMsgSml.setGroupKey(36);
            utilMsgSml.setSetCommand();
            utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
            utilMsgSml.addSmlCommand("Cmd.Zoning.ZoneSet." + zoneSet.getName() + ".Activate");
            utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
            this.setActivated = zoneSet.getName();
            this.activateTimeOut = System.currentTimeMillis() + 60000L;
            if (this.utilAgent.sendSml(utilMsgSml)) {
                return true;
            }
            this.setActivated = null;
            this.activateTimeOut = 0L;
        }
        return false;
    }

    public void receivedZoningMergeAlarm(String string) {
        if (this.eportZoningState != 2) {
            return;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) == '[') break;
            --n;
        }
        if (n >= 0) {
            string = string.substring(n + 1, string.length() - 2);
        }
        this.eventHandler.fireChassisEvent(363, null, new GuiError(104, string));
    }

    public boolean applyDeactivateZoneSet() {
        switch (this.eportZoningState) {
            case 1: {
                this.cancelEPortZoningLoad();
                this.newZoningState(3);
                break;
            }
            case 0: {
                this.newZoningState(3);
                break;
            }
            default: {
                return false;
            }
        }
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(45);
        utilMsgSml.setSetCommand();
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.Zoning.ZoneSet.Deactivate");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    void finishedActivation(ErrorType errorType) {
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
        }
        if (this.eportZoningState != 2) {
            return;
        }
        this.newZoningState(0);
        this.setActivated = null;
        this.activateTimeOut = 0L;
        this.eventHandler.fireChassisEvent(247, null, errorType);
    }

    private void finishedDeactivation(ErrorType errorType) {
        this.newZoningState(0);
        this.eventHandler.fireChassisEvent(260, null, errorType);
    }

    private void newZoningState(int n) {
        this.eportZoningState = n;
        if (n == 0 && this.updateNeeded) {
            this.updateActive();
        }
    }

    class PollActiveSet
    extends TimerTask {
        int polled = 0;

        PollActiveSet() {
        }

        public void run() {
            ++this.polled;
            if (this.polled > 60) {
                ZoningActiveAttr.this.pollingTimer.cancel();
            }
            UtilMsgSml utilMsgSml = new UtilMsgSml(ZoningActiveAttr.this.sanbox2, ZoningActiveAttr.this);
            utilMsgSml.setGroupKey(71);
            utilMsgSml.addSmlCommand("Oper.Zoning.ActiveZoneSet");
            ZoningActiveAttr.this.utilAgent.sendSml(utilMsgSml);
        }
    }
}

