/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class TempMonitoringAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    public static final int UPDATE_COMPLETE_EVENT = 358;
    public static final int APPLY_COMPLETE_EVENT = 359;
    private static final String[] updateStrings = new String[]{"Config.System.TempMonEnable", "Config.System.TempWarning", "Config.System.TempFailure"};

    public TempMonitoringAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 358, updateStrings, 359, null);
        this.sanbox2 = sanbox2Sml;
    }

    public boolean apply(int n, int n2, int n3) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setSetCommand();
        utilMsgSml.setTimeoutValue(3000);
        utilMsgSml.addSmlCommand("Cmd.Switch.ReqAdmin");
        utilMsgSml.addSmlCommand("Cmd.System.StartSetup");
        if (n == 1) {
            utilMsgSml.addSmlCommand("Config.System.TempMonEnable.True");
        } else {
            utilMsgSml.addSmlCommand("Config.System.TempMonEnable.False");
        }
        if (n2 < 0 || n2 > 100) {
            return false;
        }
        if (n3 < 0 || n3 > 100) {
            return false;
        }
        if (n2 > this.sanbox2.getFailureTemp()) {
            utilMsgSml.addSmlCommand("Config.System.TempFailure." + Integer.toString(n3));
            utilMsgSml.addSmlCommand("Config.System.TempWarning." + Integer.toString(n2));
        } else if (n3 < this.sanbox2.getWarningTemp()) {
            utilMsgSml.addSmlCommand("Config.System.TempWarning." + Integer.toString(n2));
            utilMsgSml.addSmlCommand("Config.System.TempFailure." + Integer.toString(n3));
        } else {
            utilMsgSml.addSmlCommand("Config.System.TempWarning." + Integer.toString(n2));
            utilMsgSml.addSmlCommand("Config.System.TempFailure." + Integer.toString(n3));
        }
        utilMsgSml.addSmlCommand("Cmd.System.SaveSetup");
        utilMsgSml.addSmlCommand("Cmd.System.ActSetup");
        utilMsgSml.addSmlCommand("Cmd.Switch.RelAdmin");
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        String string = utilMsgSml.getResponse(0).getResponse();
        if (string.equals("True")) {
            this.sanbox2.setTempMonEnable(1);
        } else if (string.equals("False")) {
            this.sanbox2.setTempMonEnable(2);
        }
        string = utilMsgSml.getResponse(1).getResponse();
        this.sanbox2.setWarningTemp(Integer.parseInt(string));
        string = utilMsgSml.getResponse(2).getResponse();
        this.sanbox2.setFailureTemp(Integer.parseInt(string));
    }

    public String toString() {
        return "TempMonitoringAttr: switch=" + this.theSwitch.getChassisName();
    }
}

