/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.EPortEntry;
import com.qlogic.device.fcfabric.EPortEntryList;
import com.qlogic.device.fcfabric.EPortLink;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.UnknownErrorType;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;

public class LsdbAttr
extends SwitchAttribute {
    public static final int UPDATE_COMPLETE_EVENT = 232;
    private static final int READ_TIMESTAMP = 0;
    private static final int READ_DOMAIN_IDS = 1;
    private static final int READ_DOMAINS = 2;
    private static final int READ_LINKS = 3;
    private static final int IDLE = 0;
    private static final int READING_TIMESTAMP = 1;
    private static final int READING_LSDB = 2;
    private boolean lastUpdateFailed;
    private int state;
    EPortEntryList newLsdb;

    public LsdbAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 232);
    }

    public boolean update() {
        if (this.state == 0) {
            this.state = 1;
            return this.readTimeStamp();
        }
        return false;
    }

    private boolean readTimeStamp() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setGroupKey(0);
        utilMsgSml.addSmlCommand("Oper.Eport.ChangedTime");
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    private boolean saveTimeStamp(UtilMsgSml utilMsgSml) {
        String string = utilMsgSml.getResponse(0).getResponse();
        if (string == null || !string.equals(this.theSwitch.getLsdbTs())) {
            this.theSwitch.setLsdbTs(string);
            return true;
        }
        return false;
    }

    private boolean readDomainIds() {
        this.state = 2;
        this.newLsdb = new EPortEntryList();
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setGroupKey(1);
        utilMsgSml.addSmlCommand("Oper.Eport.LsdbRecordList.0");
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    private boolean readDomains(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.getStatus() != 103 || !utilMsgSml.AllResponsesOk()) {
            this.errorExit(utilMsgSml.getErrorType());
            return false;
        }
        String string = utilMsgSml.getResponse(0).getResponse();
        utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setGroupKey(2);
        String string2 = "Oper.Eport.LsdbRecord.";
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(44, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            int n3 = Integer.parseInt(string.substring(n, n2));
            utilMsgSml.addSmlCommand(string2 + n3 + ".WWN");
            utilMsgSml.addSmlCommand(string2 + n3 + ".Hops");
            utilMsgSml.addSmlCommand(string2 + n3 + ".PortOut");
            utilMsgSml.addSmlCommand(string2 + n3 + ".Cost");
            utilMsgSml.addSmlCommand(string2 + n3 + ".Age");
            utilMsgSml.addSmlCommand(string2 + n3 + ".Incarnation");
            utilMsgSml.addSmlCommand(string2 + n3 + ".NumberOfLinks");
            utilMsgSml.addSmlCommand("Oper.Fabric.Entry." + n3 + ".NodeIPAddress");
            n = n2 + 1;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    private void saveDomains(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.getStatus() != 103) {
            this.errorExit(utilMsgSml.getErrorType());
            return;
        }
        int n = 0;
        int n2 = utilMsgSml.getNumberOfResponses();
        while (n < n2) {
            if (utilMsgSml.getResponse(n).getErrorCode() == 0) {
                int n3 = Integer.parseInt(utilMsgSml.getRequest(n).getRequestWord(3));
                WorldWideName worldWideName = new WorldWideName(utilMsgSml.getResponse(n).getResponse());
                int n4 = Integer.parseInt(utilMsgSml.getResponse(n + 1).getResponse());
                if (n4 != 255) {
                    if (worldWideName == null || !worldWideName.isFcWwn()) {
                        FabricUtilities.logMessage("LSDB LSR for domain " + n3 + " returned an invalid WWN: " + worldWideName);
                    } else {
                        int n5 = Integer.parseInt(utilMsgSml.getResponse(n + 2).getResponse());
                        int n6 = Integer.parseInt(utilMsgSml.getResponse(n + 3).getResponse());
                        int n7 = Integer.parseInt(utilMsgSml.getResponse(n + 4).getResponse());
                        int n8 = (int)Long.parseLong(utilMsgSml.getResponse(n + 5).getResponse(), 16);
                        int n9 = Integer.parseInt(utilMsgSml.getResponse(n + 6).getResponse());
                        InetAddress inetAddress = null;
                        int n10 = 0;
                        try {
                            n10 = Integer.parseInt(utilMsgSml.getResponse(n + 7).getResponse(), 16);
                            inetAddress = InetAddress.getByName(UtilMessage.ipConvert(n10));
                        }
                        catch (UnknownHostException unknownHostException) {
                            FabricUtilities.logMessage(this + " " + unknownHostException.toString() + " [" + UtilMessage.ipConvert(n10) + "]");
                        }
                        catch (NumberFormatException numberFormatException) {
                            FabricUtilities.logMessage(this + ".saveDomains() bad ip addr " + utilMsgSml.getResponse(n + 7).getResponse() + " for entry " + Integer.toHexString(n3));
                        }
                        this.newLsdb.add(new EPortEntry(n3, worldWideName, n4, n5, n6, n7, n8, n9, inetAddress));
                    }
                }
            }
            n += 8;
        }
        this.readLinks();
    }

    private boolean readLinks() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setGroupKey(3);
        Iterator iterator = this.newLsdb.iterator();
        while (iterator.hasNext()) {
            EPortEntry ePortEntry = (EPortEntry)iterator.next();
            if (ePortEntry.getLinkCount() == 0) continue;
            String string = "Oper.Eport.LsdbRecord." + ePortEntry.getDomainId() + ".Link.";
            int n = 0;
            int n2 = ePortEntry.getLinkCount();
            while (n < n2) {
                String string2 = string + n;
                utilMsgSml.addSmlCommand(string2 + ".LocalPort");
                utilMsgSml.addSmlCommand(string2 + ".Neighbor");
                utilMsgSml.addSmlCommand(string2 + ".RemotePort");
                utilMsgSml.addSmlCommand(string2 + ".LinkCost");
                ++n;
            }
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    private void saveLinks(UtilMsgSml utilMsgSml) {
        if (utilMsgSml.getStatus() != 103) {
            this.errorExit(utilMsgSml.getErrorType());
        }
        int n = 0;
        int n2 = utilMsgSml.getNumberOfResponses() - 3;
        while (n < n2) {
            if (utilMsgSml.getResponse(n).getErrorCode() == 0) {
                int n3 = Integer.parseInt(utilMsgSml.getRequest(n).getRequestWord(3));
                int n4 = Integer.parseInt(utilMsgSml.getResponse(n).getResponse());
                int n5 = Integer.parseInt(utilMsgSml.getResponse(n + 1).getResponse());
                int n6 = Integer.parseInt(utilMsgSml.getResponse(n + 2).getResponse());
                int n7 = Integer.parseInt(utilMsgSml.getResponse(n + 3).getResponse());
                EPortLink ePortLink = new EPortLink(n3, n4, n5, n6, n7);
                EPortEntry ePortEntry = this.newLsdb.getEntryByDomain(n3);
                ePortEntry.addLink(ePortLink);
            }
            n += 4;
        }
        this.theSwitch.setLsdb(this.newLsdb);
        this.lastUpdateFailed = false;
        this.theSwitch.eventHandler.fireChassisEvent(232, (Object)this.newLsdb, true);
        this.state = 0;
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        if (!utilMsgSml.AllResponsesOk() && utilMsgSml.getGroupKey() == 0) {
            this.errorExit(utilMsgSml.getErrorType());
        } else {
            this.saveResponse(object);
        }
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        switch (utilMsgSml.getGroupKey()) {
            case 0: {
                if (this.saveTimeStamp(utilMsgSml) || this.lastUpdateFailed) {
                    this.readDomainIds();
                    break;
                }
                this.abort();
                break;
            }
            case 1: {
                this.readDomains(utilMsgSml);
                break;
            }
            case 2: {
                this.saveDomains(utilMsgSml);
                break;
            }
            case 3: {
                this.saveLinks(utilMsgSml);
            }
        }
    }

    protected void abort() {
        this.state = 0;
        this.theSwitch.eventHandler.fireChassisEvent(232, null, new UnknownErrorType());
    }

    protected void errorExit(ErrorType errorType) {
        this.state = 0;
        this.lastUpdateFailed = true;
        this.theSwitch.eventHandler.fireChassisEvent(232, null, errorType);
    }
}

