/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FwVersion;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlashVersionAttr
extends SwitchAttribute {
    public static final int UPDATE_COMPLETE_EVENT = 240;
    private static final String[] updCmds = new String[]{"Oper.Switch.SwVersion.0", "Oper.Switch.SwTimestamp.0", "Oper.Switch.SwVersion.1", "Oper.Switch.SwTimestamp.1", "Oper.Blade.0.FlasherVersion", "Config.System.OBSecEnable", "Oper.Switch.ActiveVer", "Oper.Switch.ActiveTimestamp", "Oper.Switch.PendingVer", "Oper.Switch.PendingTimestamp"};
    private static final String[] updCmdsPre2_0 = new String[]{"Oper.Switch.SwVersion.0", "Oper.Switch.SwTimestamp.0", "Oper.Switch.SwVersion.1", "Oper.Switch.SwTimestamp.1", "Oper.Blade.0.FlasherVersion", "Config.System.OBSecEnable", "Oper.Switch.ActiveVersion"};
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");

    public FlashVersionAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 240);
    }

    public boolean apply(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public boolean update() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        String[] stringArray = this.theSwitch.getFirmwareVersion() < 6 ? updCmdsPre2_0 : updCmds;
        int n = 0;
        while (n < stringArray.length) {
            utilMsgSml.addSmlCommand(stringArray[n]);
            ++n;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        if (utilMsgSml.AllResponsesOk()) {
            this.saveResponse(object);
        } else {
            this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, utilMsgSml.getErrorType());
        }
    }

    protected void saveResponse(Object object) {
        Date date;
        String string;
        Date date2;
        String string2;
        String string3;
        String string4;
        Date[] dateArray;
        String[] stringArray;
        block13: {
            stringArray = new String[2];
            dateArray = new Date[2];
            UtilMsgSml utilMsgSml = (UtilMsgSml)object;
            try {
                stringArray[0] = utilMsgSml.getResponse(0).getResponse();
                dateArray[0] = this.dateFormat.parse(utilMsgSml.getResponse(1).getResponse());
                stringArray[1] = utilMsgSml.getResponse(2).getResponse();
                dateArray[1] = this.dateFormat.parse(utilMsgSml.getResponse(3).getResponse());
                string4 = utilMsgSml.getResponse(4).getResponse();
                string3 = utilMsgSml.getResponse(5).getResponse();
                int n = utilMsgSml.getNumberOfResponses();
                if (n == updCmds.length) {
                    string2 = utilMsgSml.getResponse(6).getResponse();
                    date2 = this.dateFormat.parse(utilMsgSml.getResponse(7).getResponse());
                    string = utilMsgSml.getResponse(8).getResponse();
                    date = this.dateFormat.parse(utilMsgSml.getResponse(9).getResponse());
                    break block13;
                }
                if (n == updCmdsPre2_0.length) {
                    int n2 = Integer.parseInt(utilMsgSml.getResponse(6).getResponse());
                    string2 = stringArray[n2];
                    date2 = dateArray[n2];
                    string = null;
                    date = null;
                    break block13;
                }
                String string5 = DeviceUtilities.getResource("FlashVersionAttr.wrongRspCnt");
                this.fireParseError(string5);
                return;
            }
            catch (ParseException parseException) {
                this.fireParseError(parseException.toString());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.fireParseError(numberFormatException.toString());
                return;
            }
        }
        this.theSwitch.setFlashVersionString(string2);
        this.theSwitch.setFlashTimestamp(date2);
        this.theSwitch.setPendingVersionString(string);
        this.theSwitch.setPendingTimestamp(date);
        if (string != null) {
            this.theSwitch.setPendingVersion(new FwVersion(string));
        } else {
            this.theSwitch.setPendingVersion(FwVersion.UNKNOWN_VERSION);
        }
        if (stringArray[0].equals(string2) && dateArray[0].equals(date2)) {
            this.theSwitch.setInactiveFlashVersionString(stringArray[1]);
            this.theSwitch.setInactiveFlashTimeStamp(dateArray[1]);
        } else {
            this.theSwitch.setInactiveFlashVersionString(stringArray[0]);
            this.theSwitch.setInactiveFlashTimeStamp(dateArray[0]);
        }
        this.theSwitch.setSwPromVersionString(string4);
        if ("True".equals(string3)) {
            this.theSwitch.setSecurityEnabled(2);
        } else if ("False".equals(string3)) {
            this.theSwitch.setSecurityEnabled(1);
        } else {
            this.theSwitch.setSecurityEnabled(0);
        }
        this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, true);
    }

    private void fireParseError(String string) {
        GuiError guiError = new GuiError(107, string);
        this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, guiError);
    }
}

