/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class ChassisInfoAttr
extends SwitchAttribute {
    public static final int UPDATE_COMPLETE_EVENT = 200;
    private static final int GET_COUNTS = 0;
    private static final int GET_INFO = 1;
    private int fanCount;
    private int psCount;

    public ChassisInfoAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 200);
    }

    public boolean update() {
        return this.updateCounts();
    }

    private boolean updateCounts() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setGroupKey(0);
        utilMsgSml.addSmlCommand("Oper.Chassis.0.Fans");
        utilMsgSml.addSmlCommand("Oper.Chassis.0.PowerSupplies");
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    private boolean updateChassisInfo() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setGroupKey(1);
        utilMsgSml.addSmlCommand("Oper.Blade.0.TempStatus");
        utilMsgSml.addSmlCommand("Oper.Blade.0.BoardTemp.0");
        utilMsgSml.addSmlCommand("Oper.Blade.0.BoardTemp.1");
        utilMsgSml.addSmlCommand("Config.Mfg.BrandName");
        int n = 0;
        while (n < this.fanCount) {
            utilMsgSml.addSmlCommand("Oper.Chassis.0.Fan." + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.psCount) {
            utilMsgSml.addSmlCommand("Oper.Chassis.0.PowerSupply." + n2);
            ++n2;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean apply(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        if (utilMsgSml.AllResponsesOk()) {
            switch (utilMsgSml.getGroupKey()) {
                case 0: {
                    this.saveCounts(utilMsgSml);
                    this.updateChassisInfo();
                    break;
                }
                case 1: {
                    this.saveResponse(utilMsgSml);
                    this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, true);
                }
            }
        } else {
            this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, utilMsgSml.getErrorType());
        }
    }

    private void saveCounts(UtilMsgSml utilMsgSml) {
        this.fanCount = Integer.parseInt(utilMsgSml.getResponse(0).getResponse());
        this.psCount = Integer.parseInt(utilMsgSml.getResponse(1).getResponse());
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        int n = 0;
        int n2 = this.translateTempStatus(utilMsgSml.getResponse(n++).getResponse());
        this.theSwitch.setTemperatureStatus(n2);
        n2 = Math.max(Integer.parseInt(utilMsgSml.getResponse(n++).getResponse()), Integer.parseInt(utilMsgSml.getResponse(n++).getResponse()));
        this.theSwitch.setTemperature(n2);
        this.theSwitch.setMfgVendorName(utilMsgSml.getResponse(n++).getResponse());
        this.theSwitch.setFanCount(this.fanCount);
        int n3 = 0;
        while (n3 < this.fanCount) {
            n2 = this.translateStatus(utilMsgSml.getResponse(n++).getResponse());
            this.theSwitch.setFanStatus(n3, n2);
            ++n3;
        }
        this.theSwitch.setPowerSupplyCount(this.psCount);
        int n4 = 0;
        while (n4 < this.psCount) {
            n2 = this.translateStatus(utilMsgSml.getResponse(n++).getResponse());
            this.theSwitch.setPowerSupplyStatus(n4, n2);
            ++n4;
        }
    }

    private int translateTempStatus(String string) {
        if (string.equals("Normal")) {
            return 0;
        }
        if (string.equals("Warm")) {
            return 1;
        }
        if (string.equals("Overheating")) {
            return 2;
        }
        return 3;
    }

    private int translateStatus(String string) {
        if (string.equals("Good")) {
            return 0;
        }
        if (string.equals("Bad")) {
            return 2;
        }
        if (string.equals("NotInstalled")) {
            return 4;
        }
        return 3;
    }
}

