/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.event;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import java.util.Vector;

public class ChassisEventHandler {
    protected Vector listeners = new Vector();
    protected Chassis theSwitch = null;

    public ChassisEventHandler(Chassis chassis) {
        this.theSwitch = chassis;
    }

    public synchronized void addChassisEventListener(ChassisEventListener chassisEventListener) {
        if (!this.listeners.contains(chassisEventListener)) {
            this.listeners.addElement(chassisEventListener);
        }
    }

    public synchronized void removeChassisEventListener(ChassisEventListener chassisEventListener) {
        if (this.listeners.contains(chassisEventListener)) {
            this.listeners.removeElement(chassisEventListener);
        }
    }

    public void fireChassisEvent(int n, Object object, boolean bl) {
        ChassisEvent chassisEvent = new ChassisEvent(this.theSwitch, n, object, bl);
        this.fireChassisEvent(chassisEvent);
    }

    public void fireChassisEvent(int n, Object object, ErrorType errorType) {
        ChassisEvent chassisEvent = new ChassisEvent(this.theSwitch, n, object, errorType);
        this.fireChassisEvent(chassisEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChassisEvent(ChassisEvent chassisEvent) {
        Vector vector;
        ChassisEventHandler chassisEventHandler = this;
        synchronized (chassisEventHandler) {
            vector = (Vector)this.listeners.clone();
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ChassisEventListener chassisEventListener = (ChassisEventListener)vector.elementAt(n2);
            chassisEventListener.receiveEvent(chassisEvent);
            ++n2;
        }
    }
}

